/* 
 * device.c
 * 
 * devices stuff.
 *
 * Copyright (c) Tuomo Valkonen 1996-1997.
 */
 
#include<stdio.h>
#include<strings.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<fcntl.h>
#include<errno.h>
#include<linux/fs.h>
#include<linux/fd.h>
#include<linux/hdreg.h>
#include<dirent.h>

#include<chos/chos.h>
#include<chos/main.h>
#include<chos/image.h>
#include<chos/install.h>
#include<chos/map.h>
#include<chos/mapfile.h>

#define DEVPATH 	"/dev"	

int last_dev(char* dirname,int lmaj,int incr)
{
	DIR		*dp;
	struct dirent	*dir;
	int		max,this,fd;
	struct stat	st;
	
	if( (dp=opendir(dirname))==NULL)
		die(errno,dirname);

	max=0;
	
	while( dir=readdir(dp) ){
		// Find devices which have the same major
		sprintf(tmpstr,"%s/%s",dirname,dir->d_name);
		if( stat(tmpstr,&st)>=0 ){
			if( S_ISBLK(st.st_mode) && MAJOR(st.st_rdev)==lmaj &&
			(MINOR(st.st_rdev) & (incr-1)) == 0){
				this=MINOR(st.st_rdev)/incr+1;
				if(this>max){
					/* Can we read it ?*/
					if( (fd=open(tmpstr,O_RDONLY))>=0 ){
						if( read(fd,&tmpstr,1)==1)
							max=this;
						close(fd);
					}
				}
			}
		}
	}
	return max;
}
							
	
	
// Get geometry of a device where fdp is on or fdp is
//
int get_device( int fdp, GEOMETRY *geo)
{
	int 			fd;
	struct 	floppy_struct 	fdgeo;
	struct 	hd_geometry 	hdgeo;
        struct 	stat 		st;
        int			device;
        int			tmp_flags;
        
        if( fstat(fdp,&st)<0 )
        	return 0;
        
        if( S_ISBLK(st.st_mode) ){
        	device=st.st_rdev;
        	fd=fdp;
        	// assume block size is sector size
        	geo->spb=1;
        }else{	// It's a file...
        	device=st.st_dev;
        	// Get block size
        	if( ioctl(fdp,FIGETBSZ,&(geo->spb))<0)
        		return 0;
     
        	geo->spb=geo->spb/SECTORSIZE;
        	fd=open_dev(device);
	}
	
	switch(MAJOR(device)){
	case MAJOR_FD:
		if(ioctl(fd,FDGETPRM,&fdgeo)<0)
			die(errno,dev_name(device));
			geo->heads=fdgeo.head;
		geo->cylinders=fdgeo.track;
		geo->sectors=fdgeo.sect;
		geo->start=0;
		geo->device=MINOR(device)&3;
		break;

	case MAJOR_HD:
		if(ioctl(fd,HDIO_GETGEO,&hdgeo)<0)
			die(errno,dev_name(device));
			
		geo->heads=hdgeo.heads;
		geo->cylinders=hdgeo.cylinders;
		geo->sectors=hdgeo.sectors;
		geo->start=hdgeo.start;
		geo->device=0x80+(MINOR(device)>>6);
		break;
	case MAJOR_XT:
	case MAJOR_IDE2:
		if(ioctl(fd,HDIO_GETGEO,&hdgeo)<0)
			die(errno,dev_name(device));
		
		geo->heads=hdgeo.heads;
		geo->cylinders=hdgeo.cylinders;
		geo->sectors=hdgeo.sectors;
		geo->start=hdgeo.start;
		geo->device=0x80+(MINOR(device)>>6)+
		last_dev(DEVPATH,MAJOR_HD,64);
		break;
	case MAJOR_SD:
		if(ioctl(fd,HDIO_GETGEO,&hdgeo)<0)
			die(errno,dev_name(device));
			
		geo->heads=hdgeo.heads;
		geo->cylinders=hdgeo.cylinders;
		geo->sectors=hdgeo.sectors;
		geo->start=hdgeo.start;
			
		// LILO does it something like this...
		// I don't know if this works as I don't have SCSI
		// disks...
		if(!hdgeo.sectors){
			die(-1,"Invalid harddisk geometry gotten\n"
			       " (some1 should add the option to manually tell geometry!)\n");
		}
		geo->device=0x80+(MINOR(device)>>4)+
			last_dev(DEVPATH,MAJOR_HD,64);
		break;
		
	default:
		die(-1,"Dunno how to handle device %s.",dev_name(device));
	}

	return 1;					
}
 
 
// Scan /dev directory for a device.
//
char* dev_name( dev_t device )
{
	DIR 		*ds;
	struct dirent 	*dir;
	struct stat 	st;
	int 		fd;
	
	if( (ds=opendir(DEVPATH))==NULL)
		die(errno,DEVPATH);
	
	while( dir=readdir(ds) ){
		sprintf(tmpstr,DEVPATH"/%s",dir->d_name);
		if(stat(tmpstr,&st)>=0){
			if(S_ISBLK(st.st_mode) && st.st_rdev==device){
				closedir(ds);
				return tmpstr;
			}
		}		
	}

	die(-1,"(%02x:%02x):No such device in "DEVPATH" !!!\n",
		MAJOR(device),MINOR(device));
}			

int open_dev(dev_t device)
{
	int	fd;
	if((fd=open(dev_name(device),3))<0)
		die(errno,tmpstr);
		
	return fd;
}
		
// Gets linear sector address of sector sect of file fd on device geo.
//
int get_addr( int fd, int sect, GEOMETRY *geo )
{
	struct 	stat 	st;
	int		block,sector;
	
	if( fstat(fd,&st)<0 )
		return -1;
	
	/* Is it a block special file ? - return start address in geo	*/
	if( S_ISBLK(st.st_mode) )
		return geo->start+sect;
	
	/* Count block address	*/
	block=sect/geo->spb;
	
	if( ioctl(fd,FIBMAP,&block)<0 )
		return -1;

	if(block==0)
		return	0;
	
	/* Count the sector address	*/
	sector=(block*geo->spb)+(sect%geo->spb);
	sector+=geo->start;
	
	return sector;
}	

// Verifies that BIOS can read sector address addr with geometry geo.
//
int verify_bios_read(GEOMETRY *geo,ulong addr)
{
	unsigned char 	head,sector;
	unsigned short 	cylinder;
	
	sector   = addr % geo->sectors + 1;
	head     = addr / geo->sectors % geo->heads;
	cylinder = addr / geo->sectors / geo->heads;
	
	if( sector > geo->sectors || head > geo->heads )
		die(-1,"Geometry calculation error !!!\n");
	if( cylinder >= geo->cylinders && geo->cylinders!=1)
		die(-1,"Cylinder beyond end of media (%d>%d)\n",cylinder,geo->cylinders-1);
	if( cylinder > 1023 )
		return 0;
	
	return 1;
}	
