/*
 * misc.S
 * 
 * misc stuff.
 * 
 * Copyright (c) Tuomo Valkonen 1996-1997.
 */


// Error handling
///////////////////
lin_cyl_exceed:
	mov	si,#cyl_exceed
	jmp	die
lin_error:
	mov	si,#errtxt
	
// I wonder what this does...
///////////////////////////////
die:
	call	crlf
	call	print
forever:hlt
	jmp	forever


// Turn floppy drive motor off
////////////////////////////////
motor_off:
	mov	dx,#0x3f2
	xor 	al,al
	outb
	ret

// Reset stuff - we're ready to enter the OS
//////////////////////////////////////////////
end_load:
	call	motor_off
	
	//mov	si,image
	mov	dl,#0 //(si+BID_DRIV_OFF)	// map file
	call	reset_drive
	
	// Reset color - at least my bios uses last color used with int 0x10/0x9 with
	// non-color prints too... sucks...
	mov	byte ptr chos_color,#0x07
	call	crlf
	
	ret

#define KEY_ENTER	0x1c0d
#define	KEY_BACKSPC	0x0e08
#define KEY_ESC		0x011b

// Just reads user input at ES:DI.
// Maximum characters to read = DX-1
//////////////////////////////////////
get_cmdline:
	pusha
	mov	si,#text_cmdline
	call	print
	popa

	dec	dx
	dec	dx
	xor	bx,bx

print_cmdline:
	seg	es
	mov	al,(di+bx)
	test	al,al
	je	wait_key
	call	putch
	inc	bx
	jmp	print_cmdline

wait_key:
	mov	ah,#0
	int	#0x16
  	cmp	ax,#KEY_ENTER		// is it enter ?
	je	enter_press
	cmp	ax,#KEY_BACKSPC		// is it backspace ?
	je	backspc_press
	cmp	ax,#KEY_ESC
	je	esc_press
	cmp	al,#32			// is it special character ?
	jb	wait_key
	
	cmp	bx,dx
	jae	wait_key
	seg	es			// put the character there
	mov	(di+bx),al
	inc	bx
	call	putch
	jmp	wait_key

enter_press:
	seg	es
	mov	(di+bx),#0
	call	crlf
	ret

backspc_press:
	cmp	bx,#0
	je	wait_key
	dec	bx
//	seg	es			// This was missing...
//	mov	(di+bx),#0		// Actually this isn't even needed...

	push	dx			// Save counters
	push	bx

	mov	ah,#03			
	xor	bh,bh
	int	#0x10
	cmp	dl,#0
	jne	not_start_row
	dec	dh
	mov	dl,#80
not_start_row:
	dec	dl
	mov	ah,#02
	int	#0x10
	mov	ax,#0x0e00
	int	#0x10
	mov	ah,#02
	int	#0x10

	pop	bx			// Restore counters
	pop	dx

	jmp	wait_key

// Esc clears the command line
esc_press:
	test	bx,bx
	je	wait_key
	push	dx
	push	bx
	mov	ah,#03
	xor	bh,bh
	int	#0x10
	pop	bx
	xor	ah,ah
	mov	al,dl
	sub	ax,bx
	jge	esc_pr20
esc_pr10:
	dec	dh
	add	ax,#80
	jl	esc_pr10
esc_pr20:
	mov	dl,al
	push	dx
	push	bx
	mov	ah,#02
	xor	bh,bh
	int	#0x10
	pop	bx
esc_pr30:
	mov	al,#0
	call	putch
	dec	bx
	jg	esc_pr30
	pop	dx
	mov	ah,#02
	xor	bh,bh
	int	#0x10
	xor	bx,bx
//	seg	es
//	mov	(di+bx),#0
	pop	dx
	br	wait_key

// Convert letter in AL to upper case.
////////////////////////////////////////
toupper:
	cmp	al,#97
	jl	no_low
	cmp	al,#122
	ja	no_low
	sub	al,#97-65
no_low:
	ret


// data
/////////
str_loading:	.ascii	"Loading "
		.byte	0
dots:		.ascii	"..."
		.byte	0

text_cmdline:	.ascii	"Command line: "
		.byte	0

text_done:	.ascii	"Done."
		.byte	0

errtxt:		.ascii	"BIOS disk error."
		.byte	0
		
cyl_exceed:	.ascii	"Cylinder nr. exceeds max."
		.byte	0
