static char dqs_start_p4_rcsid[]="$Id: dqs_start_p4.c,v 1.2 1997/04/11 14:47:09 green Exp $";

/*----------------------------------------------------
 * dqs_start_p4.c Tom Green Sat Jun  4 12:05:53 EDT 1994
 *
 * Copyright 1994
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_start_p4.c,v $
 * Revision 1.2  1997/04/11 14:47:09  green
 * applied Curtis Janssen's patch to open "/dev/null" rather than "/" for
 * stdin
 *
 * Revision 1.1.1.1  1997/04/10 15:10:34  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.10  1996/11/20 23:04:39  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.9  1996/06/27  01:56:09  nrl
 * changes to accomodate osf gcc
 *
 * Revision 3.8  1996/03/22  04:21:31  nrl
 * Added error cataloguing number to all routines
 *
 * Revision 3.7  1995/02/19  22:37:57  nrl
 * Simplified pvm and tcgmsg interface to a minimalist scheme requiring
 * user scripts to start the daemons
 *
 * Revision 3.6  1994/06/16  22:59:32  green
 * the master exec_str may or may not be filled - handle exeception
 *
 * Revision 3.5  1994/06/08  17:48:11  green
 * added P4 support(with the help of Ralph Butler - Thanks Ralph!)
 *
 * backed down to Rev. 3.3 of dqs_check_to_do_list.c
 *
 * Revision 3.4  1994/06/06  23:29:37  green
 * fixed bug in generating Makefile.h(actually not a bug - but AIX
 * couldn't dijest it...)
 *
 * added dqs_parse_exec_str.c(and added in Makefile.proto)
 *
 * built a more "generic" conf_file and resolve_file
 *
 * updated dqs_execd.c and dqs_start_p4.c to utilize dqs_parse_exec_str()
 *
 * had DQS_DSHD_BIN and DQS_DSH_BIN misnamed in prognames.h
 *
 * Revision 3.3  1994/06/05  16:53:56  green
 * added DQS_DSHD_SERVICE and dqs_dshd_service to required support files
 *
 * forced a SIGQUIT to children on death of parent(eg: "master") in
 * dqs_sig_handlers.c
 *
 * Revision 3.2  1994/06/05  15:27:30  green
 * forced death of children(local and remote) at death of "master"
 * foresee a lot of confusion here when combined with "-notify"...
 *
 * Revision 3.1  1994/06/04  17:38:29  green
 * added support for dqs_start_p4()
 *
 *
 *--------------------------------------------------*/

 
#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"
#include "prognames.h"


/************************************************************************/
void dqs_start_p4(shell_path,job,queue)
char           *shell_path;
dqs_job_type   *job;
dqs_queue_type *queue;

/*
   dqs_start_p4 - is used soley by the dqs_execd.

   this routine is responsible for starting the remote P4/MPI processes
   prior to the execl of the "master" script.

*/

{
     
     string        tmpstr;
     dqs_list_type *lp;

     DENTER((DQS_EVENT,"dqs_start_p4"));

     dqs_parse_p4_exec_str(job);

     dqs_start_p4_slave(job,queue);

     lp=job->granted_destin_identifier_list;
     lp=lp->next;

     if (!job->granted_destin_identifier_list->str3)
     job->granted_destin_identifier_list->str3=dqs_malloc(MAX_STRING_SIZE);

     strcat(job->granted_destin_identifier_list->str3," -remote_info");
	
     while (lp)
     {
	  strcat(job->granted_destin_identifier_list->str3," ");
	  strcat(job->granted_destin_identifier_list->str3,lp->str1);
	  sprintf(tmpstr," %d",lp->int0);
	  strcat(job->granted_destin_identifier_list->str3,tmpstr);
          strcat(job->granted_destin_identifier_list->str3," 1 ");
          strcat(job->granted_destin_identifier_list->str3,lp->str2);
	  lp=lp->next;
     }

     DEXIT;
     return;

}

/************************************************************************/
void dqs_start_p4_slave(job,queue)
dqs_job_type   *job;
dqs_queue_type *queue;

/*
/margit/c/users/rbutler/p4-1.4a.2/messages/systest1 \
    -p4pginfo 1 ibm11 1 dirac 5555 3
*/

{

     int           i,fd;
     int           in,out,err;
     char          *stdout_path;
     char          *stderr_path;
     string        exec_str;
     dqs_list_type *lp;

     DENTER((DQS_EVENT,"dqs_start_p4_slave"));

     if (!fork())
     {
	  for (i=0; i<_NFILE-1; i++)
	  close(i);

	  in=open("/dev/null",O_RDONLY);
	  if (in<0)
	  {
	       ERROR((DQS_EVENT,"DQS_ERROR_0512 error: cannot open stdin file \"/\""));
	       DEXITE;
	       exit(DQS_ENOENT);
	  }

	  stdout_path=dqs_get_path(job->stdout_path_list,job->job_name,
                                   job->job_number,DQS_PAR_STDOUT);
          stderr_path=dqs_get_path(job->stderr_path_list,job->job_name,
                                   job->job_number,DQS_PAR_STDERR);

	  out=open(stdout_path,O_WRONLY|O_CREAT|O_TRUNC,0744);
	  if (out<0)
	  {
	       ERROR((DQS_EVENT,"DQS_ERROR_0513 error: cannot open output file \"%s\"",
		      stdout_path));
	       DEXITE;
	       exit(DQS_ENOENT);
	  }

	  err=open(stderr_path,O_WRONLY|O_CREAT|O_TRUNC,0744);
	  if (err<0)
	  {
	       ERROR((DQS_EVENT,"DQS_ERROR_0514 error: cannot open stdout \"%s\"",
		      stderr_path));
	       DEXITE;
	       exit(DQS_ENOENT);
	  }
    
	  lp=job->granted_destin_identifier_list;
	  lp=lp->next; /* first is the "master" */
	  
	  bzero(exec_str,sizeof(exec_str));
	  sprintf(exec_str,"%s/%s",conf.dqs_bin,DSH_BINARY);

	  while (lp)
	  {
	       if ((lp->str1)&&(lp->str3))
	       if (!fork())
	       {
                    INFO((DQS_EVENT,"DQS_ERROR_0515 JID %d execl'ing(%s,%s,%s,%s)",
                           job->job_number,exec_str,DSH_BINARY,
                           lp->str1,lp->str3));

		    execl(exec_str,DSH_BINARY,lp->str1,lp->str3,0);
		    ERROR((DQS_EVENT,"DQS_ERROR_0516 JID %d execl(%s,%s,%s,%s) - failed",
			   job->job_number,exec_str,DSH_BINARY,
			   lp->str1,lp->str3));
	       }
	       lp=lp->next;
	  }
	  
	  DEXIT;
	  exit(0);
     }
     else
     {
	  DEXIT;
	  return;
     }

}

/**********************************************************************/
void dqs_parse_p4_exec_str(job)
dqs_job_type *job;

{
     
     int           nodenum=0;
     int           total_numnodes;
     dqs_list_type *granted_lp;

     DENTER((DQS_EVENT,"dqs_parse_exec_str"));

     if (!job)
     {
          DEXITE;
          return;
     }

     if (!job->granted_destin_identifier_list)
     {
          DEXITE;
          return;
     }

     total_numnodes=dqs_length_of_list(job->granted_destin_identifier_list);
     granted_lp=job->granted_destin_identifier_list;

     while (granted_lp)
     {
	  if (!nodenum)
	  {
	       granted_lp->str3=dqs_malloc(MAX_STRING_SIZE);
	       sprintf(granted_lp->str3,
		       " -execer_id DQS -master_host %s -my_hostname %s -my_nodenum %d -my_numprocs 1 -total_numnodes %d -job_id %d",
		       job->granted_destin_identifier_list->str1,
		       granted_lp->str1,
		       nodenum,
		       total_numnodes,
		       job->job_number);
	  }
	  else
	  {
               granted_lp->str3=dqs_malloc(MAX_STRING_SIZE);
               sprintf(granted_lp->str3,
                       "%s -execer_id DQS -master_host %s -my_hostname %s -my_nodenum %d -my_numprocs 1 -total_numnodes %d -job_id %d",
		       granted_lp->str2,
                       job->granted_destin_identifier_list->str1,
                       granted_lp->str1,
                       nodenum,
                       total_numnodes,
                       job->job_number);
          }
	  granted_lp->int0=nodenum;
	  nodenum++;
	  granted_lp=granted_lp->next;

     }

     DEXIT;
     return;

}

