static char qstat_rcsid[]="$Id: qstat.c,v 1.2 1997/08/08 19:00:12 decker Exp $";

/*----------------------------------------------------
 * qstat.c Tom Green Mon Jan 31 10:43:12 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: qstat.c,v $
 * Revision 1.2  1997/08/08 19:00:12  decker
 * Added patch concerning resources.
 *
 * Revision 1.1.1.1  1997/04/10 15:10:35  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.16  1996/08/26 14:21:14  nrl
 * Incorporated SCRI scheduling changes
 *
 * Revision 3.15  1996/07/13  02:52:25  nrl
 * repaired formatting of ouput of job ID separated from
 * job priority
 *
 * Revision 3.14  1996/06/27  01:56:20  nrl
 * changes to accomodate osf gcc
 *
 * Revision 3.13  1996/03/26  00:03:27  nrl
 * changed hold/release to explicit use of hold types
 *
 * Revision 3.12  1996/03/22  04:21:49  nrl
 * Added error cataloguing number to all routines
 *
 * Revision 3.11  1996/03/21  22:00:30  nrl
 * Added "reasons for being queued" to the qstat short listing as
 * well as the long listing
 *
 * Revision 3.10  1996/02/19  19:02:30  nrl
 * added a separate subpriority field, pluys scheduling_flags and
 * job_seq_number to remove the 3.1.2.4 kludges , modified the
 * scheduling algorith once again
 *
 * Revision 3.9  1996/01/19  20:59:25  nrl
 * merged SCRI code and new job and queue structure changes
 *
 * Revision 3.8  1995/06/22  19:31:12  nrl
 * Added kludgie "subpriority" field to differentiate jobs from the
 * same user. Also fixed MAXUJOBS and added "MAXU" warning to
 * the "qstat" command.
 *
 * Revision 3.7  1995/06/21  16:58:04  nrl
 * Major scheduling changes... added a subpriority field to manage
 * things within the user submitted priority. Added priority info to the
 * accounting file.
 *
 * Revision 3.6  1995/05/17  12:29:17  nrl
 * adjusted priority display to account for BASE_PRIORITY offset
 *
 * Revision 3.5  1995/03/20  23:19:50  nrl
 * Fixed oversight in job prinint, fogort to subtract BASE_PRIORITY
 * for simple output.
 *
 * Revision 3.4  1995/03/05  03:47:55  nrl
 * Included Axel Brandes job scheduling mechanism to keep one
 * user from hawging the queue.
 *
 * Revision 3.3  1995/03/01  12:14:49  nrl
 * Changed formatting of output to get items to line up in columns
 *
 * Revision 3.2  1994/06/11  19:20:08  green
 * moved the execl(dshd) out of /etc/inetd.conf and into the dqs_execd.
 * (not nearly as easy as I had thought...)
 *
 * no longer need DQS_DSHD_SERVICE
 *
 * mods were required to dqs_send_receive_list() which need to be
 * propogated to ALL ancillaries...
 *
 * Revision 3.1  1994/04/20  23:26:01  green
 * added qhold.c qrls.c
 *
 * Revision 3.0  1994/03/07  04:15:22  green
 * 3.0 freeze
 *
 * Revision 1.1.1.1  1994/02/01  17:57:51  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/

 
char *dqs_ctime();
#define MAINPROGRAM
#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

int              q_suitability=0;
int              j_suitability=0;
int              l_suitability=0;

/************************************************************************/

main(argc, argv,envp)
int argc;
char **argv;
char **envp;

{
     
     int              valid_q;
     int              first;
     int              pending_head=FALSE;
     dqs_list_type    *lp;
     dqs_list_type    *lp2;
     dqs_list_type    *lp3;
     dqs_list_type    listel;
     dqs_list_type    *argv_list=(dqs_list_type *) NULL;
     dqs_list_type    *resp=(dqs_list_type *) NULL;
     dqs_job_type     *qstat_conf;
     dqs_job_type     *j;
     
     DENTER_MAIN((DQS_EVENT,"qstat"));   
     
     dqs_setup(QSTAT,argv[0]);
     dqs_setup_sig_handlers();     

     argv_list=dqs_args2list(++argv,argc);
     qstat_conf=dqs_parse_job(argv_list,envp);
     
     if (!qstat_conf) 
     {
	  CRITICAL((DQS_EVENT,"DQS_ERROR_0563 dqs_parse_job() returned NULL"));
	  exit(DQS_EAGAIN);
	  
     }
     
     if (qstat_conf->verify)
     {
          dqs_show_qstat_request(qstat_conf);
	  DEXIT;
          exit(0);
     }
     
     /* get copies of the Queue_list, Job_list, and Complex_list */
     bzero((char *)&listel,sizeof(listel));
     listel.type=QSTAT;
     if (dqs_send_receive_list(me.default_cell,conf.qmaster_service,&listel,&resp)<0)
     {
	  DEXITE;
	  exit(DQS_EAGAIN);
     }
     
     /* oops, a problem was encountered */
     if (resp->status!=DQS_ACK)
     {
	  dqs_show_acknak_list(resp);
	  DEXITE;
	  exit(resp->int0);
     }
     
     /* we tagged the Queue_list onto the "chain" field */
     /* add all queues to local tables                  */
     lp=resp->chain;
     while (lp)
     {
	  (void) dqs_add_queue(lp->queue);
	  lp=lp->next;
     }
     
     /* we tagged the Job_list onto the "next" field */
     /* add all jobs to local tables                 */
     lp=resp->next;
     while (lp)
     {
          (void) dqs_add_job(lp->job);
          lp=lp->next;
     }
     
     /* we tagged the Complex_list onto the "tid" field */
     /* add all complexes to local tables               */
     lp=resp->tid;
     while (lp)
     {
          (void) dqs_add_complex(lp);
          lp=lp->next;
     }
     
     /* the reason we went to all the trouble in adding the queues/jobs/complexes    */
     /* to the local has tables is so we could use parts of the scheduler to extract */
     /* requested fields.  It could be argued that all this should be done on the    */
     /* qmaster to cut down on the data transferred - but this was method simpler    */
     /* to code...                                                                   */
     
     
     /* forst we tag any specifice queues which might have been requested            */
     
     lp=qstat_conf->hard_queue_list;
     while (lp)
     {
	  lp2=Queue_head;
	  while (lp2)
	  {
	       if (dqs_wildmat(lp->str0,lp2->queue->qname))
	       {
		    if (!q_suitability)
		    q_suitability=1;
		    lp2->queue->suitable=1;
	       }
	       lp2=lp2->next;
	  }
          lp=lp->next;
     }
     
     /* now run through the hard_resource_list setting the "suitability" field of the */
     /* respective queues.                                                            */
     
     lp=qstat_conf->hard_resource_list;
     while (lp)
     {
          dqs_select_queues(lp->chain, NULL);
          q_suitability+=dqs_length_of_list(lp->chain);
          lp=lp->next;
     }
     
     /* ok, now we tag the jobs if the user_list was specified                        */

     j_suitability=dqs_length_of_list(qstat_conf->user_list);
     lp2=Job_head;
     while (lp2)
       {
     lp=qstat_conf->user_list;

     if (lp)
       {
         while (lp)
           {
         if (dqs_wildmat(lp->str0,lp2->job->owner)){
           lp2->job->suitable++;
         }
         lp=lp->next;
           }
       } else lp2->job->suitable++;
     lp2=lp2->next;
       }

   /* now we walk the pending list and check -l args */

   l_suitability=dqs_length_of_list(qstat_conf->hard_resource_list);
   lp=Job_head;
   while (lp)
     {
   DTRACE;
   if (VALID(QUEUED,lp->job->state))
     {
       if (lp->job->hard_resource_list) {
         lp3=lp->job->hard_resource_list->chain;
         while(lp3)
       {
         if (qstat_conf->hard_resource_list) {
           lp2=qstat_conf->hard_resource_list->chain;
           while(lp2)
             {
           /*scan the list and set suitablility*/
           DTRACE;
           if (dqs_wildmat(lp3->str0,lp2->str0))
             lp->job->suitable++;
           lp2=lp2->next;
             }                          /*while lp2*/
         }                              /*if qstat_conf*/
         else {
          /*lp->job->suitable++; */
         }
         lp3=lp3->next;
       }                                /*while lp3*/
       }                                    /*if lp->job*/
     }
   lp=lp->next;
     }



     
     /* now we are ready for business - run the queue and job list                   */

    if (qstat_conf->full_listing) {
      printf ("Queue Name\t\t\t Queue Type    Quan  Load          State\n");
      printf ("----------\t\t\t ----------    ----  ----          -----\n");
    }
     
     lp=Queue_head;
     while (lp)
     {
	  DTRACE;
	  valid_q=FALSE;
	  if (lp->queue->suitable>=q_suitability) /* fits queue profile */
	  {
	       DTRACE;
	       if (j_suitability) /* requested based on specific users */
	       {
		    DTRACE;
		    lp3=lp->queue->job_list;
		    while (lp3) /* make sure queue has specified user under it */
		    {
			 DTRACE;
			 j=dqs_locate_job(lp3->str0);
			 if (!j)
			 {
			      DTRACE;
			      ERROR((DQS_EVENT,"DQS_ERROR_0564 error: cannot locate job \"%s\"",lp3->str0));
			      lp3=lp3->next;
			      continue;
			 }
			 if (j->suitable)
			 valid_q=TRUE;
			 lp3=lp3->next;
		    }
		    DTRACE;
		    
		    if (!valid_q)
		    {
			 lp=lp->next;
			 continue;
		    }
		    DTRACE;
	       }
	       dqs_qstat_print_queue(qstat_conf,lp->queue);
	       DTRACE;
	  }
	  lp=lp->next;
	  DTRACE;
     }
     
     /* now we print out pending jobs */
     
     lp=Job_head;
     while (lp)
     {
	  DTRACE;
	  if (VALID(QUEUED,lp->job->state))
	  {
	       DTRACE;
           if (lp->job->suitable>=(j_suitability+l_suitability))
	       {
		    if (!pending_head){
                printf("\n\n----Pending Jobs ---------------------------------------------------------------\n");
			 pending_head=TRUE;
		    }
		    dqs_print_job(qstat_conf,"NA      ",lp->job, "NONE");
	       }
	  }
	  lp=lp->next;
     }
     printf("\n");
     exit(0);  
} 

/***************************************************************************/
int dqs_qstat_print_queue(qstat_conf,q)
dqs_job_type *qstat_conf;
dqs_queue_type *q;

{
     
     float         load_avg;
     dqs_list_type *lp, *lp3;
     dqs_job_type  *j;
     string   queue_name;
     int name_length;
     int i, first;
     
     DENTER((DQS_EVENT,"dqs_qstat_print_queue"));

     if (qstat_conf->ext)
     {
	  printf("***************************************************************\n");
	  dqs_show_queue(q);
     }
     else if (qstat_conf->full_listing)
     {
          /*Patch fixed here*/
           if (q->load_avg>=q->load_alarm)
	  {
	       SETBIT(ALARM,q->state);
	  }
	  load_avg=(float)q->load_avg/100;

      strcpy(queue_name,q->qname);
      name_length= strlen(queue_name);

      for(i=name_length;i<16;i++)strcat(queue_name," ");  /* pad out name */
      
     printf("%-33s%7s%2d/%-4d%2.2f  ",
     queue_name,queue_type[q->qtype],q->qty_active,q->qty,load_avg);
	  dqs_show_states(DQS_STDOUT,q->state);
	  printf("\n");
     }
     
     lp=q->job_list;
     while (lp)
     {
	  j=dqs_locate_job(lp->str0);
	  if (!j)
	  {
	       ERROR((DQS_EVENT,"DQS_ERROR_0565 error: cannot locate job \"%s\"",lp->str0)); 
	       lp=lp->next;
	       continue;
	  }
	  if (j->suitable>=j_suitability)
	  {
         dqs_print_job(qstat_conf,master_slave[lp->int1],j,q->qname);
	  }
	  lp=lp->next;
     }

     DEXIT;
     return;
}

/***************************************************************************/
int dqs_print_job(qstat_conf,master,job, qname)
dqs_job_type *qstat_conf;
char         *master;
dqs_job_type *job;
string qname;

{
     dqs_list_type *lp3;
     string job_name;
     char res[80];
     char res2[80];
     char rel[3];
     int    name_length;
     int i, first;
     int priority,sub_priority, save_priority, tmp_priority, max_flag;
     string max_string;

     DENTER((DQS_EVENT,"dqs_print_job"));

     strcpy(job_name,job->job_name);
     name_length=strlen(job_name);
     for(i=name_length;i<16;i++)strcat(job_name," ");
     priority= job->priority;
     sub_priority=0;
     max_flag=0;
     if(job->scheduling_flags== MAX_JOBS_EXCEEDED)     	max_flag=1;

     
     sub_priority= job->subpriority ;
     priority=priority-BASE_PRIORITY;

     
     if (qstat_conf->ext){
     	/* we must dummy priority back to old format  */
     	save_priority= job->priority;
     	job->priority= priority+BASE_PRIORITY;
	    dqs_show_job(job);
	    job->priority= save_priority;
     }
     else if (qstat_conf->full_listing) {
        if (VALID(QUEUED,job->state)) {
           printf ("%-9s%-10.9s",job->owner,job->job_name);
           first=1;
           if(job->hard_resource_list){
              if (job->hard_resource_list->chain) { 
               lp3=job->hard_resource_list->chain;
              }
              else {
                lp3=NULL;
              }
           }
           else{
           	lp3=NULL;
           }
           sprintf(res," ");
           sprintf(rel," ");

           while (lp3) {

              if (!first) {
                 strcat(res,", ");
              } else first=0;
     
              if(lp3->str0) {

                 strcat (res,lp3->str0);

                 if (lp3->int0) {
                    sprintf(rel,"");
                    if (lp3->int1) {
               
                        switch (lp3->int1) {
                          case EQ_OP:
                            strcat(rel,"=");  break;
                          case GT_OP:
                            strcat(rel,">"); break;
                          case GE_OP:
                            strcat(rel,">=");  break;
                          case LE_OP:
                            strcat(rel,"<=");  break;
                          case LT_OP:
                            strcat(rel,"<"); break;
                          case NE_OP:
                            strcat(rel,"<>"); break;
                        }
                        sprintf (res2,"%s%d",rel,lp3->int0);
                        strcat(res,res2);
                    }
                 }  /*  if lp3->int0)    */
                 if (lp3->str1) strcat (res,lp3->str1);
                 lp3=lp3->next;
              }  /* if lp3->str0  */
           } /* while lp3  */
           strcat(res,"\0");

           if(max_flag) {
                    printf (" %6.6s%4d:%-2d%-25.25s MAXJOB ",
                           job->dqs_job_name,priority,sub_priority,res);
           } else {
		      if ((VALID(USER,job->hold) ) || (VALID(SYSTEM,job->hold) ) ||
		                  (VALID(OTHER,job->hold) ) ){
		      	
                 printf (" %6.6s%4d:%-2d%-25.25s HELD   ",
                           job->dqs_job_name,priority,sub_priority,res);
			  }
			  else{
                 printf (" %6.6s%4d:%-2d%-25.25s QUEUED ",
                    job->dqs_job_name,priority,sub_priority,res);
			  }
           }                           


        } else {   /* VALID QUEUE_SSTATE  */
            printf ("    %-9s%-10.9s%8.8s%8s%4d:%-3d ",
                     job->owner,job->job_name,"",job->dqs_job_name,
           priority,sub_priority  );
           dqs_show_states(DQS_STDOUT,job->state);
     }  /*  VALID QUEUE STATE  */

     if (!job->start_time) printf("%s",dqs_ctime(job->submission_time));
     else  printf("%s",dqs_ctime(job->start_time));

      if (job->hold)
      {
      printf("\thold                  ");
      dqs_show_hold_list(job->hold,DQS_STDOUT);
      }

     printf("\n");

   }  /* if full listing  */
     else {

     if (VALID(QUEUED,job->state)) {

           printf ("%-9s%-10.9s",job->owner,job->job_name);
           first=1;
           if(job->hard_resource_list){
               if (job->hard_resource_list->chain) { 
                 lp3=job->hard_resource_list->chain;
               }
               else {
                 lp3=NULL;
               }
           }
           else{
           	lp3=NULL;
           }
           sprintf(res," ");
           sprintf(rel," ");

           while (lp3) {

              if (!first) {
                 strcat(res,", ");
              } else first=0;
     
              if(lp3->str0) {

                 strcat (res,lp3->str0);

                 if (lp3->int0) {
                    sprintf(rel,"");
                    if (lp3->int1) {
               
                        switch (lp3->int1) {
                          case EQ_OP:
                            strcat(rel,"=");  break;
                          case GT_OP:
                            strcat(rel,">="); break;
                          case GE_OP:
                            strcat(rel,">");  break;
                          case LE_OP:
                            strcat(rel,"<");  break;
                          case LT_OP:
                            strcat(rel,"<="); break;
                          case NE_OP:
                            strcat(rel,"<>"); break;
                        }
                        sprintf (res2,"%s%d",rel,lp3->int0);
                        strcat(res,res2);
                    }
                 }  /*  if lp3->int0)    */
                 if (lp3->str1) strcat (res,lp3->str1);
                 lp3=lp3->next;
              }  /* if lp3->str0  */
           } /* while lp3  */
           strcat(res,"\0");

           if(max_flag) {
                 printf (" %6.6s%4d:%-2d%-25.25s MAXJOB ",
                           job->dqs_job_name,priority,sub_priority,res);
           } else {
                if( (VALID(USER,job->hold) ) || (VALID(SYSTEM, job->hold) )||
                         ( VALID(OTHER,job->hold ))){
                     printf (" %6.6s%4d:%-2d%-25.25s HELD   ",
                           job->dqs_job_name,priority,sub_priority,res);
				}
				else{

                 printf (" %6.6s%4d:%-2d%-25.25s QUEUED ",
                           job->dqs_job_name,priority,sub_priority,res);
                }
           }                           


        } else {   /* VALID QUEUE_DTATE  */
            printf ("%-9s%-10.9s%-12s%8s%4d:%-3d ",
            job->owner,job->job_name,qname,job->dqs_job_name,
           priority,sub_priority  );
           dqs_show_states(DQS_STDOUT,job->state);
     }  /*  qstat full listing  */

      if (!job->start_time) printf("%s",dqs_ctime(job->submission_time));
      else    printf("%s",dqs_ctime(job->start_time));

      if (job->hold)
         {
         printf("\thold                  ");
         dqs_show_hold_list(job->hold,DQS_STDOUT);
         }

      printf("\n");
    }

    DEXIT;
    return;

}

