static char  globals_rcsid[] = "globals.h,v 1.3 1994/11/28 16:54:53 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *  globals.h,v
 * Revision 1.3  1994/11/28  16:54:53  kerce
 * *** empty log message ***
 *
 * Revision 1.6  1994/09/13  18:01:59  raju
 * prototyepe declarations
 *
 * Revision 1.5  1994/08/21  02:57:22  raju
 * *** empty log message ***
 *
 * Revision 1.4  1994/07/20  01:01:35  raju
 * added a couple of functions
 *
 * Revision 1.3  1994/07/15  18:12:20  raju
 * indented ,
 *
 * Revision 1.2  1994/07/15  11:57:50  raju
 * Added MENUTYPE define
 *
 * Revision 1.1  1994/07/11  15:25:50  raju
 * Initial revision
 *
 *
 *
 **********************************************************/
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <stdlib.h>

#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/cursorfont.h>

#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Clock.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Logo.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/StripChart.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Cardinals.h>
#include "prognames.h"

#define GRPFILE            ".qmongrpcf"
#define BITMAPCONF            "bitmap.conf"
/*
 * The following defines have to be set at compile time, either in Makefile
 * or as an argument to make program. BITMAPDIR ; RESOLVE_FILE 
 */
#define DEFAULTRUNNINGCOLOR   "green"
#define DEFAULTIDLECOLOR      "cyan"
#define DEFAULTSUSPENDEDCOLOR "yellow"
#define DEFAULTSUSCOMPCOLOR   "gray"
#define DEFAULTALARMCOLOR     "red"
#define DEFAULTRUNNINGBW      "white"
#define DEFAULTIDLEBW         "black"
#define DEFAULTSUSPENDEDBW    "white"
#define DEFAULTSUSCOMPBW      "white"
#define DEFAULTALARMBW        "white"
#define ERRORFILE             ".qmonerrlog"
#define ICON_REFRESH_RATE     60/* every n sec */
#define OUTPUTWIN_REFRESH_RATE 1000	/* ms          */
#define DUMMY_NUMBER	      9999	/* for oldstate, assumes state is not
					 * 9999 */
#define IOBUFLEN              1024
#define PROGNAME              "qmon"
#define MAX_COLORS            1000
#define MAX_GROUPS            100
#define MAX_ADD_ICONS         100
#define MAX_HIERARCHY_COLORS  4
#define VERSION               "v3.6"

/*
 * #define GETQUEUES	      strcat(QCONF_BINARY," -qmon") 
 */
#define GETQUEUES	      "cat /margit/a/users/raju/dqs/aqmon3.4/QUES"
#define DATESTRING	      "date +%D%t%r"
#define SCANFORMAT	"\n%[^:]:%d:%[^:]:%[^:]:%d:%d:%d:%[^:]:%[^:]:%[^:]"
#define SCANFORMAT1	"\n%[^:]:%d:%[^:]:%[^:]:%d:%d:%d::%[^:]:%[^:]"
#define INFOLABEL       "R/A   :\nLoad  :\nStates:"

#define INPUTTYPE             (1)
#define FLAGTYPE              (2)
#define ACTIONTYPE            (3)
#define RADIOTYPE             (4)
#define MENUTYPE              (5)
#define BITMAPBITS	160
#define GETCWD
#define MAX_STRING_SIZE   1024	/* Same as DQS 3.0 def.h */
#if defined(MACH)
#undef GETCWD
#endif

#define STACK_OPEN(headp)    (*(headp) = NULL)
#define EACH_STACK(head,p)   for ((p)= (head); (p) != NULL; (p) = (p)->next )
#define STACK_IS_EMPTY(head) ((head) == NULL
#define STACK_FIRST(head)    (head)
#define STACK_NEXT(p)        ((p)->next)
#define PNN_BAD(p)           (fprintf(stderr,"NULL\n"),p)
#define PNNC(p,t)            ((p) != NULL ? (t)(p): (t)PNN_BAD(p))
#define STACK_P(p)           PNNC(p, STACK_NODE *)
#define STACK_PP(p)          PNNC(p, STACK_NODE **)
/*
#define STACK_CLOSE(h)       (stack_close(STACK_PP(h)))
#define STACK_POP(h)         (stack_pop(STACK_PP(h)))
*/
#define STACK_PUSH(h,p)      (stack_push(STACK_PP(h),STACK_P(p)))

typedef struct stack_node
{
        struct stack_node *next;
        char name[MAX_STRING_SIZE];
} STACK_NODE;

struct liststruct {
	Widget          widgetid;
	char           *name;
	char           *flag;
	int             type;
	char           *defaultarg;
	STACK_NODE     *list;
};

struct optionstruct {
	Widget          widgetid;
	char           *name;
	char           *flag;
	int             type;
	char           *defaultarg;
	STACK_NODE     *list;
};

typedef struct {
	char            magic_cookie[MAX_STRING_SIZE];
	int             seqnum;
	char            hostname[MAX_STRING_SIZE];
	char            name[MAX_STRING_SIZE];
	char            oldname[MAX_STRING_SIZE];
	char            group[MAX_STRING_SIZE];
	char            cmplx_list[MAX_STRING_SIZE];
	char            arc[MAX_STRING_SIZE];
	char            state[MAX_STRING_SIZE];
	char            oldstate[MAX_STRING_SIZE];
	int             loadavg;
	int             old_loadavg;
	int             max_jobs;
	int             old_max_jobs;
	int             active_jobs;
	int             old_active_jobs;
	int             dummy;
	int             alarm;
	int             running;
	int             idle;
	int             suspended;
	int             sus_on_comp;
	int             managed;
	int             mapped;
	Pixmap          pix;
	GC              gc;
	Widget          outer;
	Widget          bgpixmap;
	Widget          info_label;
	Widget          info;
	Widget          info_form;
	Widget          pushme;
}               queueiconstruct;

typedef struct {

	Pixmap          pix;
	GC              gc;
	Dimension       width, height;

} pixmap_data;

typedef struct {
	char            ident[MAX_STRING_SIZE];
	char            bitmap[MAX_STRING_SIZE];
	pixmap_data     pix_data;
	int             pixexist;
	char   bits[BITMAPBITS];
	XImage         *image;
}               queuepixstruct;


static int      hash_init;
static int      added_icons;
extern GC       gc;
extern int      max_icons;
extern int      max_usergrps;

extern STACK_NODE     *resource_list;
extern STACK_NODE     *destination_list;
extern STACK_NODE     *account_list;
extern STACK_NODE     *user_list;
extern STACK_NODE     *manager_list;
extern STACK_NODE     *operator_list;
extern char     *complex_list;
extern char	*currentdirectory;
extern STACK_NODE     *cell_list;
extern STACK_NODE     *host_list;
extern STACK_NODE     *queue_list;

extern char     current_cell[MAX_STRING_SIZE];
extern char     current_resource[MAX_STRING_SIZE];
extern char     current_destination[MAX_STRING_SIZE];
extern char     current_date[MAX_STRING_SIZE];
extern char     current_account[MAX_STRING_SIZE];
extern char     current_interval[MAX_STRING_SIZE];
extern char     current_errpath[MAX_STRING_SIZE];
extern char     current_mqueue[MAX_STRING_SIZE];
extern char     current_jobname[MAX_STRING_SIZE];
extern char     current_outpath[MAX_STRING_SIZE];
extern char     current_priority[MAX_STRING_SIZE];
extern char     current_passwdfile[MAX_STRING_SIZE];
extern char     current_shellpath[MAX_STRING_SIZE];
extern char     current_exportvars[MAX_STRING_SIZE];
extern char     current_user[MAX_STRING_SIZE];

extern Boolean  current_parallel;
extern Boolean  current_holduser;
extern Boolean  current_holdsys;
extern Boolean  current_holdother;
extern Boolean  current_nohold;
extern Boolean  current_hard;
extern Boolean  current_soft;
extern Boolean  current_rerun;

/* function prototypes */
#include "funcproto.h"
