static char showstat_c_rcsid[]="showstat.c,v 1.3 1994/12/01 14:45:59 kerce Exp";

/*-----------------------------------------------------------------------------
 * Kingsley Kerce
 *
 * Copyright (c) 1994
 *
 * Supercomputer Computations Research Institute (SCRI)
 * Florida State University
 *
 * SCRI representatives make no claims about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * showstat.c,v
 * Revision 1.3  1994/12/01  14:45:59  kerce
 * Solaris 2.x mods
 *
 * Revision 1.2  1994/06/25  16:25:23  kerce
 * changed version numbers from 3.05 to 3.1.0
 *
 * Revision 1.1.1.1  1994/06/18  19:43:30  kerce
 * DQS X Distribution
 *
 *---------------------------------------------------------------------------*/

#define MAINPROGRAM
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <sys/time.h>
#if defined(SYSV) || defined(SVR4)
#include <string.h>
#else
#include <strings.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "proto.h"
#include "error.h"
#include "stdstuff.h"
#include "cpyright.h"
#include "statfile.h"
#include "util.h"

char *ProgramName = NULL;
void (*FatalErrorHook)();
char *Title = "DQS Stat File Viewer";

#ifndef __DATE__
char *Version = " v3.1.0 beta";
#else
char *Version = " v3.1.0 beta (compiled " __DATE__ " " __TIME__ ")";
#endif

static char *AboutTextString = COPYRIGHT;

static void
ShowUsage ()
{
  fprintf (stderr, "Usage: %s ", ProgramName);
  fprintf (stderr, "[-f StatFileName] ");
  fprintf (stderr, "[-x] ");

  fprintf (stderr, "\n");
  
  fprintf (stderr, "   or: %s -help\n", ProgramName);
  fprintf (stderr, "   or: %s -version\n", ProgramName);
}

static void
ShowHelp ()
{
  ShowUsage ();
  fprintf (stderr, "\n");
  fprintf (stderr, "where: StatFileName is the name of a stat file\n");
  fprintf (stderr, "       `x' (exactly) means echo the stat file as-is\n");
}

static void
ShowVersion ()
{
  fprintf (stderr, BuildAboutTextString (Title, Version, AboutTextString));
}

static void
ProcessCmdLine (argc, argv, EnvStatFileName, StatFileName, Exactly)
     int *argc;
     char **argv;
     char *EnvStatFileName;
     char **StatFileName;
     BOOLEAN *Exactly;
{
  char c;
  BOOLEAN NextOption;
  int sscanfResult;

  DENTER ((DQS_EVENT, "ProcessCmdLine"));

  if (DEBUG_ON == 1)
    DisplayArgs (*argc, argv);
  
  while ((--*argc > 0) && ((*++argv)[0] == '-'))
    {
      NextOption = FALSE;
      while ((c = *++argv[0]) && (NextOption == FALSE))
	switch (c)
	  {
	  case 'f':
	    --*argc;
	    if (*argc > 0)
	      {
		argv++;
		if (EnvStatFileName != NULL)
		  Error (NULL, 0, 0,
			 "WARNING: overriding environment variable %s=%s",
			 STATFILEENVVARNAME, EnvStatFileName);

		*StatFileName = argv[0];
		NextOption = TRUE;
	      }
	    else
	      {
		Error (NULL, 0, 0,
		       "-f option must be followed by a file name");
		ShowUsage ();
		DEXIT;
		exit (EXIT_FAILURE);
	      }

	    break;

	  case 'x':
	    *Exactly = TRUE;
	    break;

	  case 'h':
	  case '?':
	    ShowHelp ();
	    DEXIT;
	    exit (EXIT_SUCCESS);
	    break;
	    
	  case 'v':
	    ShowVersion ();
	    DEXIT;
	    exit (EXIT_SUCCESS);
	    break;
	    
	  default:
	    Error (NULL, 0, 0, "unknown option `%c'", c);
	    break;
	  }
    }

  if (DEBUG_ON == 1)
    DisplayArgs (*argc, argv);

  if (*argc > 0)
    {
      Error (NULL, 0, 0,
	     "WARNING: the following command line arguments were unused:");

      while (*argc > 0)
	{
	  fprintf (stderr, "%s ", argv[0]);
	  *argc -= 1;
	  argv++;
	}

      fputc ('\n', stderr);
    }

  fflush (stderr);
  DEXIT;
}

void
WriteStats (Stats, QComplexStr, Exactly)
     dqs_stats_type Stats;
     char * QComplexStr;
     BOOLEAN Exactly;
{
  if (Exactly == FALSE)
    {
      printf ("time:\t\t\t%d (%s)\n", Stats.time,
	      TimeC ((time_t *) Stats.time));
      printf ("qname:\t\t\t\\%s\\\n", Stats.qname);
      printf ("hostname:\t\t\\%s\\\n", Stats.hostname);
      printf ("load_avg:\t\t%d\n", Stats.load_avg);
      printf ("qty:\t\t\t%d\n", Stats.qty);
      printf ("qty_active:\t\t%d\n", Stats.qty_active);
      printf ("complex:\t\t\\%s\\\n", QComplexStr);
      printf ("states:\t\t\t\\%s\\\n", Stats.states);
      
      printf ("---------------------------------------------------------------\n");
    }
  else
    /*
     *  The following should exactly reproduce the stat_file.
     */
    {
      printf ("%d:", Stats.time);
      printf ("%s:", Stats.qname);
      printf ("%s:", Stats.hostname);
      printf ("%d:", Stats.load_avg);
      printf ("%d:", Stats.qty);
      printf ("%d:", Stats.qty_active);
      printf ("%s:", QComplexStr);
      printf ("%s", Stats.states);
      putchar ('\n');
    }
}

int
main (argc, argv)
     int argc;
     char **argv;
{
  char *EnvStatFileName;
  char *StatFileName;
  int sscanfResult;
  FILE *StatFilePtr;
  int read_statsResult;
  dqs_stats_type Stats;
  char QComplexStr[10240];
  BOOLEAN Exactly, GotSomeData;

  DENTER_MAIN ((DQS_EVENT, "showstat"));
  dqs_setup (QSUB, argv[0]);

  FatalErrorHook = NULL;
  ProgramName = argv[0];

  if (DEBUG_ON == 1)
    DisplayArgs (argc, argv);

  EnvStatFileName = getenv (STATFILEENVVARNAME);
  StatFileName = EnvStatFileName;

  Exactly = FALSE;
  ProcessCmdLine (&argc, argv, EnvStatFileName, &StatFileName, &Exactly);

  if (StatFileName == (char *) NULL)
    {
      StatFileName = BuildFileName (STATF);
      if (StatFileName == (char *) NULL)
	{
	  Error (__FILE__, __LINE__, 0, "FATAL ERROR: out of memory");
	  exit (EXIT_FAILURE);
	}
    }
  
  StatFilePtr = fopen (StatFileName, "r");
  if (StatFilePtr == NULL)
    {
      Error (NULL, 0, errno,
	     "FATAL ERROR: can't open stat file named `%s'",
	     StatFileName);
      exit (EXIT_FAILURE);
    }

  read_statsResult = 0;
  GotSomeData = FALSE;

  while (read_statsResult == 0)
    {
      read_statsResult =
	dqs_read_stats (StatFilePtr, &Stats, QComplexStr);

      switch (read_statsResult)
	{
	case -3:
	  /* The file should be open... */
	  Error (__FILE__, __LINE__, 0, "FATAL INTERNAL ERROR");
	  exit (-3);
	  break;

	case -2:
	  Error (NULL, 0, 0,
		 "Unexpectedly reached end of stat file named `%s'",
		 StatFileName);
	  exit (-2);
	  break;

	case -1:
	  Error (NULL, 0, 0, "Cannot parse data in stat file named `%s'",
		 StatFileName);
	  exit (-1);
	  break;

	case 0:
	  GotSomeData = TRUE;
	  WriteStats (Stats, QComplexStr, Exactly);
	  break;

	case 1:
	  if ((Exactly == FALSE) && (GotSomeData == FALSE))
	    Error (NULL, 0, 0, "WARNING: stat file named `%s' is empty",
		   StatFileName);
	  break;

	default:
	  Error (__FILE__, __LINE__, 0, "INTERNAL ERROR");
	  break;
	}	  
    }

  return (0);
}


/* Set Emacs C-mode style.
   Local Variables:
   c-style: GNU
   End:
 */
