/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/
# ifndef cstringSList_H
# define cstringSList_H

typedef /*@observer@*/ cstring ob_cstring;

abst_typedef /*@null@*/ struct _cstringSList
{
  int      nelements;
  int      nspace;
  /*@reldef@*/ /*@relnull@*/ ob_cstring *elements;
} *cstringSList ;

/*@constant null cstringSList cstringSList_undefined;@*/
# define cstringSList_undefined ((cstringSList) NULL)

extern /*@falsenull@*/ bool cstringSList_isDefined (cstringSList p_s) /*@*/ ;
# define cstringSList_isDefined(s)   ((s) != cstringSList_undefined)

extern int cstringSList_size (/*@sef@*/ cstringSList) /*@*/ ;
# define cstringSList_size(s) (cstringSList_isDefined (s) ? (s)->nelements : 0)

extern /*@falsenull@*/ bool cstringSList_empty (/*@sef@*/ cstringSList) /*@*/ ;
# define cstringSList_empty(s) (cstringSList_size(s) == 0)

extern /*@only@*/ cstringSList cstringSList_new (void) /*@*/ ;
extern cstringSList 
  cstringSList_add (/*@returned@*/ cstringSList p_s, /*@exposed@*/ cstring p_el) 
  /*@modifies p_s@*/ ;

extern void cstringSList_alphabetize (cstringSList p_s);

extern /*@only@*/ cstring cstringSList_unparseAbbrev (cstringSList p_s) /*@*/ ;
extern /*@unused@*/ /*@only@*/ cstring cstringSList_unparse (cstringSList p_s) ;
extern void cstringSList_free (/*@only@*/ cstringSList p_s) ;

extern void cstringSList_printSpaced (cstringSList p_s, int p_indent, int p_gap, int p_linelen);

/*@constant int cstringSListBASESIZE;@*/
# define cstringSListBASESIZE MIDBASESIZE

/*@iter cstringSList_elements (sef cstringSList x, yield exposed cstring el); @*/
# define cstringSList_elements(x, m_el) \
   { if (cstringSList_isDefined (x)) { \
       int m_ind; cstring *m_elements = &((x)->elements[0]); \
	 for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
	   { cstring m_el = *(m_elements++); 

# define end_cstringSList_elements }}}

# else
# error "Multiple include"
# endif




