/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/
# ifndef enumNameLIST_H
# define enumNameLIST_H

typedef cstring enumName ;

extern /*@only@*/ enumName enumName_create (/*@only@*/ cstring p_s) /*@*/ ;

# define enumName_create(s)  (s)

typedef /*@only@*/ enumName o_enumName;

abst_typedef struct _enumNameList
{
  int nelements;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ o_enumName  *elements;
} *enumNameList ;

/*@iter enumNameList_elements (sef enumNameList x, yield exposed enumName el); @*/
# define enumNameList_elements(x, m_el) \
   { int m_ind; enumName *m_elements = &((x)->elements[0]); \
     for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
       { enumName m_el = *(m_elements++); 

# define end_enumNameList_elements }}

extern int enumNameList_size (enumNameList);

# define enumNameList_size(s) ((s)->nelements)   

extern /*@only@*/ enumNameList enumNameList_new(void);
extern bool enumNameList_member (enumNameList p_s, cstring p_m);
extern enumNameList enumNameList_push (/*@returned@*/ enumNameList p_s, /*@only@*/ enumName p_el);
extern void enumNameList_addh (enumNameList p_s, /*@keep@*/ enumName p_el) 
     /*@modifies p_s@*/;

extern /*@only@*/ cstring enumNameList_unparse (enumNameList p_s) /*@*/ ;
extern void enumNameList_free (/*@only@*/ enumNameList p_s) ;

extern bool enumNameList_match (enumNameList p_e1, enumNameList p_e2) /*@*/ ;
extern /*@only@*/ enumNameList enumNameList_single (/*@keep@*/ enumName p_t) /*@*/ ;
extern /*@only@*/ enumNameList 
  enumNameList_subtract (enumNameList p_source, enumNameList p_del) /*@*/ ;
extern /*@only@*/ enumNameList enumNameList_copy (enumNameList p_s) /*@*/ ;
extern /*@only@*/ enumNameList enumNameList_undump(char **p_s);
extern /*@only@*/ cstring enumNameList_dump (enumNameList p_s);
extern /*@only@*/ cstring enumNameList_unparseBrief (enumNameList p_s);

/*@constant int enumNameListBASESIZE;@*/
# define enumNameListBASESIZE SMALLBASESIZE

# else
# error "Multiple include"
# endif




