/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/
/*
** flag_codes.h
*/

# ifndef FLAGCODES_H
# define FLAGCODES_H

/*
** attempt to keep order consistent with that in flags.c 
*/

typedef enum  
{ 
  SKIP_FLAG = -2,
  INVALID_FLAG = -1,
# include "flag_codes.gen"
  LAST_FLAG
} flagcode;

/*@constant flagcode NUMFLAGS; @*/
# define NUMFLAGS       (LAST_FLAG)

/*@constant int NUMVALUEFLAGS; @*/
# define NUMVALUEFLAGS       12

/*@constant int NUMSTRINGFLAGS; @*/
# define NUMSTRINGFLAGS      19

/*@iter allFlagCodes (yield flagcode f); @*/
# define allFlagCodes(m_code) \
  { /*@+enumint@*/ flagcode m_code; for (m_code = 0; m_code < NUMFLAGS; m_code++) \
      /*@=enumint@*/ { 

# define end_allFlagCodes }}

# else
# error "Multiple include"
# endif
