/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/
/*
** globSet.c
*/

# include "lclintMacros.nf"
# include "basic.h"

globSet
globSet_new ()
{
  return (globSet_undefined);
}

void
globSet_clear (globSet g)
{
  sRefSet_clear (g);
}

globSet
globSet_insert (/*@returned@*/ globSet s, sRef el)
{
  if (sRef_isKnown (el) && !sRef_isConst (el) && !sRef_isType (el))
    {
      llassertprint (sRef_isGlobal (el) || sRef_isKindSpecial (el),
		     ("el: %s", sRef_unparse (el)));
      
      return (sRefSet_insert (s, el));
    }
  else
    {
      return s;
    }
}

globSet
  globSet_copy (/*@returned@*/ globSet s1, /*@exposed@*/ globSet s2)
{
  return (sRefSet_copy (s1, s2));
}

/*@only@*/ globSet
globSet_newCopy (globSet s)
{
  return (sRefSet_newCopy (s));
}

bool
globSet_member (globSet s, sRef el)
{
  return (sRefSet_member (s, el));
}

/*@exposed@*/ sRef globSet_lookup (globSet s, sRef el)
{
  sRefSet_allElements (s, e)
    {
      if (sRef_similar (e, el))
	{
	  return e;
	}
    } end_sRefSet_allElements;

  return sRef_undefined;
}

bool
globSet_hasStatic (globSet s)
{
  sRefSet_allElements (s, el)
    {
      if (sRef_isFileStatic (el))
	{
	  return TRUE;
	}
    } end_sRefSet_allElements;

  return FALSE;
}

void
globSet_free (/*@only@*/ globSet s)
{
  sRefSet_free (s);
}

/*@only@*/ cstring
globSet_dump (globSet lset)
{
  cstring st = cstring_undefined;
  bool first = TRUE;

  DPRINTF (("sRefSet dump: %s", sRefSet_unparse (sl)));

  sRefSet_allElements (lset, el)
    {
      if (!first)
	{
	  st = cstring_appendChar (st, ',');
	}
      else
	{
	  first = FALSE;
	}

      st = cstring_concatFree (st, sRef_dumpGlobal (el));
    } end_sRefSet_allElements;

  return st;
}

globSet
globSet_undump (char **s)
{
  char c;
  sRefSet sl = sRefSet_new ();

  while ((c = **s) != '#' && c != '@' && c != '$' && c != '&')
    {
      sl = sRefSet_insert (sl, sRef_undumpGlobal (s));

      DPRINTF (("undump: %s", sRefSet_unparse (sl)));

      if (**s == ',')
	{
	  (*s)++;
	}
    }

  DPRINTF (("sRefSet_undump -> %ld : %s", sl, sRefSet_unparseDebug (sl)));
  return sl;
}

/*@only@*/ cstring
globSet_unparse (globSet ll)
{
  return (sRefSet_unparse (ll));
}

int 
globSet_compare (globSet l1, globSet l2)
{
  return (sRefSet_compare (l1, l2));
}

