/*
  Optimizer
  IdEntry C++ file
*/

/*
 *  Copyright (C) 1997,1998  Jesper Pedersen <jews@imada.ou.dk>
 *  This code is released under GNU GPL version 2 or later
 */

#include "Global.h"
#include "Misc.h"
#include "IdEntry.h"
#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <string.h>

//
//	Method name : IdEntry
//
//	Description : Constructor to IdEntry
//	Input : ---
//	Output : ---
//
IdEntry::IdEntry(char *s1,char *s2) {
  unsigned int length;

  this->next = (PIdEntry) NULL;
  if (strcmp(s1,"")) {
    length = strlen(s1) + 1;
    this->name = new char[length];
    if (!this->name) alloc_error();
    strcpy(this->name,s1);
  } else {
    length = 1;
    this->name = new char[length];
    if (!this->name) alloc_error();
    strcpy(this->name,"");
  }
  if (strcmp(s2,"")) {
    length = strlen(s2) + 1;
    this->label = new char[length];
    if (!this->label) alloc_error();
    strcpy(this->label,s2);
  } else {
    length = 1;
    this->label = new char[length];
    if (!this->label) alloc_error();
    strcpy(this->label,"");
  }
  length = 1;
  this->align = new char[length];
  if (!this->align) alloc_error();
  strcpy(this->align,"");
}


//
//	Method name : ~IdEntry
//
//	Description : Destructor to IdEntry
//	Input : ---
//	Output : ---
//
IdEntry::~IdEntry() {
  delete[] this->name; 
  delete[] this->label;
  delete[] this->align;
}

//
//	Method name : getname
//
//	Description : Returns the name
//	Input : ---
//	Output : The name
//
char *IdEntry::getname(void){
  return this->name;
}

//
//	Method name : getlabel
//
//	Description : Returns the label
//	Input : ---
//	Output : The label
//
char *IdEntry::getlabel(void){
  return this->label;
}

//
//	Method name : setlabel
//
//	Description : Sets the label
//	Input : The label
//	Output : ---
//
void IdEntry::setlabel(char *s){
  unsigned int length;
  delete[] this->label;
  length = strlen(s) + 1;
  this->label = new char[length];
  if (!this->label) alloc_error();
  strcpy(this->label,s);
}

//
//	Method name : getalign
//
//	Description : Returns the alignment
//	Input : ---
//	Output : The alignment
//
char *IdEntry::getalign(void){
  return this->align;
}

//
//	Method name : setalign
//
//	Description : Sets the alignment
//	Input : The alignment
//	Output : ---
//
void IdEntry::setalign(char *s){
  unsigned int length;
  delete[] this->align;
  length = strlen(s) + 1;
  this->align = new char[length];
  if (!this->align) alloc_error();
  strcpy(this->align,s);
}

//
//	Method name : getsize
//
//	Description : Returns the size
//	Input : ---
//	Output : The size
//
unsigned int IdEntry::getsize(void){
  return atoi(this->align);
}
//
//	Method name : convert
//
//	Description : Converts the name string
//	Input : ---
//	Output : ---
//
void IdEntry::convert(void) {   
  unsigned int length;
  bool cont = true;
  char *tmpstr = new char[MaxSize];

  if (!tmpstr) alloc_error();
    
  while (cont == true) {
    if (strstr(this->name,"\\n")) {             // \n
      strcpy(tmpstr,this->name);
      strdel(&tmpstr,"\\n","\", 10, \"");
      delete[] this->name;
      length = strlen(tmpstr) + 1;
      this->name = new char[length];
      if (!this->name) alloc_error();
      strcpy(this->name,tmpstr);
    } else if (strstr(this->name,"\\t")) {      // \t
      strcpy(tmpstr,this->name);
      strdel(&tmpstr,"\\t","        ");
      delete[] this->name;
      length = strlen(tmpstr) + 1;
      this->name = new char[length];
      if (!this->name) alloc_error();
      strcpy(this->name,tmpstr);
    } else if (strstr(this->name,"\\\"")) {     // \"
      strcpy(tmpstr,this->name);
      strdel(&tmpstr,"\\\"","\", '\"', \"");
      delete[] this->name;
      length = strlen(tmpstr) + 1;
      this->name = new char[length];
      if (!this->name) alloc_error();
      strcpy(this->name,tmpstr);
    } else {
      cont = false;
    }
  }
  cont = true;
  while (cont == true) {
    if (strstr(this->name,", \"\"")) {
      strcpy(tmpstr,this->name);
      strdel(&tmpstr,", \"\"","");
      delete[] this->name;
      length = strlen(tmpstr) + 1;
      this->name = new char[length];
      if (!this->name) alloc_error();
      strcpy(this->name,tmpstr);
    } else {
      cont = false;
    }
  }
  cont = true;
  while (cont == true) {
    if (strstr(this->name," \", ")) {
      strcpy(tmpstr,this->name);
      strdel(&tmpstr," \", ","");
      delete[] this->name;
      length = strlen(tmpstr) + 1;
      this->name = new char[length];
      if (!this->name) alloc_error();
      strcpy(this->name,tmpstr);
    } else {
      cont = false;
    }
  }
  delete[] tmpstr;
}


//
//	Method name : print
//
//	Description : Prints the IdEntry
//	Input : ---
//	Output : ---
//
void IdEntry::print(void) {
  cout << "IdEntry label : " << this->label << "\n";
  cout << "IdEntry name  : " << this->name << "\n\n";
  cout << "IdEntry align : " << this->align << "\n\n";
}
