// Copyright (c) 1997 Philip A. Hardin (pahardin@cs.utexas.edu)
//
// You may reuse and/or modify this source code for non-profit,
// non-commercial purposes without further permission from the author,
// provided that the source code retains this copyright/permission notice.
// Use of the source code for any other purpose requires prior permission
// from the author.


#ifndef SHAPES_h
#define SHAPES_h

#include <stdio.h>   // gets definition of NULL
#include <limits.h>  // to get INT_MAX, LONG_MAX
#include "table.h"
#include "bb.h"
#include "bbcolor.h"


#define NUMINSIGNIA 6

extern const int EXPLSPIKES, TANKHELIRGNS, BANGRGNS;

extern rgn3
  tankRgn, turrRgn, barrRgn, shellRgn,
  ballRgn, hqRgns[], heliRgn, bladeRgn,
  treeRgn, mtnRgn, mtn2Rgn, mtn3Rgn, mtn4Rgn,
  tankHeliRgns[], turrBladRgns[], planeRgn, saucerRgn,
  canopyRgn, engineRgn, tailRgn, lwingRgn, rwingRgn,
  tankBRgn, tankBFinRgn, turrBRgn, barrBRgn, bangRgns[], horizonRgn,
  boundRgn, explRgn,
  trainRgn, turrCRgn, barrCRgn,
  railRgn40, railRgn100, railRgn260,
  pillarRgn;

extern rgn3 trainRgn, railRgn;
#ifdef NONRELEASE
extern rgn3
  tunnelRgn, destroyerRgn, wheelRgn, mntn2Rgn, vtolRgn, rpelRgn, rperRgn,
  prp3Rgn;
#endif

extern rgn2
  turr2dRgn, heli2dRgn, capitalBRgn, decorRgn, plne2dRgn,
  sauc2dRgn, arrowRgn, bound2dRgn,
  insigniaRgns[],insignia2Rgns[];

void InitRegions(int numTeams, bool fancy, double hqDist, int ir);

#endif
