///////////////////////////////////////////////////////////////////////////////
// $Id: misc.cxx,v 1.1 1995/01/08 06:52:51 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// misc.cxx - Various support routines for the widgets to use
//
//
// Bradford W. Mott
// Copyright (C) 1994
// December 11,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: misc.cxx,v $
// Revision 1.1  1995/01/08  06:52:51  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#include "BasicWidget.hxx"
#include "UIApplication.hxx"
#include "misc.hxx"

///////////////////////////////////////////////////////////////////////////////
// Draw a 3D border around the widget!
///////////////////////////////////////////////////////////////////////////////
void Draw3DBorder(BasicWidget* widget, int borderWidth, BorderStyle style)
{
  int i;
  int w = widget->width();
  int h = widget->height();

  // Draw the top left hightlight
  if(style == Sunken) 
    XSetForeground(application->display(), application->gc(), 
      widget->backgroundLow());
  else if(style == Raised)
    XSetForeground(application->display(), application->gc(), 
      widget->backgroundHigh());
  else 
    return;

  for(i = 0; i < borderWidth; i++)
  {
    XDrawLine(application->display(), widget->window(),
        application->gc(), i, h-i-1, i, i);
    XDrawLine(application->display(), widget->window(),
        application->gc(), i, i, w-i-1, i);
  }

  // Draw the bottom right hightlight
  if(style == Sunken) 
    XSetForeground(application->display(), application->gc(), 
      widget->backgroundHigh());
  else
    XSetForeground(application->display(), application->gc(), 
      widget->backgroundLow());

  for(i = 0; i < borderWidth; i++)
  {
    XDrawLine(application->display(), widget->window(),
        application->gc(), i+1, h-i-1, w-i-1, h-i-1);
    XDrawLine(application->display(), widget->window(),
        application->gc(), w-i-1, h-i-1, w-i-1, i+1);
  }
}

