/*
 * $Id: uzipsupp.c $
 *
 * Author: Tomi Ollila <too@iki.fi>
 *
 * 	Copyright (c) 1997 Tomi Ollila
 * 	    All rights reserved
 *
 * Created: Fri Aug  1 09:22:46 1997 too
 * Last modified: Sat Aug  2 10:30:48 1997 too
 *
 * HISTORY 
 * $Log: $
 */

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <fcntl.h>
#include <errno.h>
/* little patch for some libc's */
extern char   *sys_errlist[];

#include "uzipsupp.h"

/***************************************************************************/

ulg makelong(unsigned char * sig)
{
  return ((ulg)sig[3] << 24) | ((ulg)sig[2] << 16)
    |    ((ulg)sig[1] << 8)  |  (ulg)sig[0];
}

ush makeword(unsigned char * sig)
{
    return ((ush)sig[1] << 8) | (ush)sig[0];
}

/***************************************************************************/
									       extern int errno;
/* const char * sys_errlist[]; */

void perrf(char * format, ...)
{
  va_list ap;
  int e = errno;
  
  va_start(ap, format);
  vfprintf(stderr, format, ap);
  va_end(ap);

  fprintf(stderr, ": %s\n", sys_errlist[e]);
}

void errf(char * format, ...)
{
  va_list ap;

  va_start(ap, format);
  vfprintf(stderr, format, ap);
  va_end(ap);
  putc('\n', stderr);
}

/***************************************************************************/


struct NeedData * createNeedData(int bufsize)
{
  struct NeedData * nd = (struct NeedData *)malloc(bufsize + sizeof * nd);

  if (!nd) {
    errf("Out of memory!!!\n");
    return NULL;
  }
  
  nd->bufsize = bufsize;
  nd->fd = -1;
  
  return nd;
}

void initNeedData(struct NeedData * nd, int fd)
{
  nd->bufp = nd->rlen = 0;
  nd->fd = fd;
  nd->buf = (char *)(nd + 1);
}
  

char * needData(struct NeedData * nd, int amount)
{
  char * rvp;
  int len;
  
  if (amount > nd->rlen - nd->bufp)
  {
    if (nd->bufp) {
      memcpy(nd->buf, nd->buf + nd->bufp, nd->rlen - nd->bufp);
      nd->rlen -= nd->bufp;
      nd->bufp = 0;
    }
    len = read(nd->fd, nd->buf + nd->rlen, nd->bufsize - nd->rlen);
    if (len < 0) {
      perrf("needData: read");
      return NULL;
    }

    nd->rlen += len;

    if (amount > nd->rlen - nd->bufp) {
      errf("needData: File ended too early\n");
      return NULL; /* does not have enough data left */
    }
  }
  rvp = nd->buf + nd->bufp;
  nd->bufp += amount;

  return rvp;
}
    
void deleteNeedData(struct NeedData * nd)
{
  if (nd->fd >= 0)
    close(nd->fd);
  free(nd);
}
