/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgStats.c                                                    */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:58 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Stats"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *in1;
  int width,height,x,y;
  it_float *in1_ptr;
  double val,sum,sumsqs,pixels,rms,ave,std;

  IFHELP
    {
      fprintf(stderr,"img%s - Calculate statistical information\n",PRGNAME);
      fprintf(stderr,"  stdin: Float\n");
      fprintf(stderr,"  stdout: None\n");
      exit(0);
    }

  imgStart(PRGNAME);

  /* Loop for all images */
  do {
    in1=i_read_image_file(stdin,IT_FLOAT,IM_FRAGMENT);
    if(in1==NULL)
      ERROR("can't import image file");
    width=in1->width;
    height=in1->height;

    sum=0.0;
    sumsqs=0.0;
    for(y=0;y<height;y++)
      {
	in1_ptr=im_float_row(in1,y);
	for(x=0;x<width;x++)
	  {
	    val= *in1_ptr++;
	    sumsqs+=(val*val);
	    sum+=val;
	  }
      }
    pixels=width*height;
    rms=sqrt(sumsqs/pixels);
    ave=sum/pixels;
    std=sqrt((sumsqs-sum*sum/pixels)/pixels);
    i_destroy_image(in1);

    fprintf(stderr,"%s: mean    %g\n",PRGNAME,ave);
    fprintf(stderr,"%s: rms     %g\n",PRGNAME,rms);
    fprintf(stderr,"%s: std-dev %g\n",PRGNAME,std);

  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
