/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgSub.c                                                      */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:59 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Sub"
#define OPERATOR -
#define ERROR(e) imgError(e,PRGNAME)
#define ARG_ERROR(e,arg) imgArgError(e,arg,PRGNAME)

int main(int argc,char **argv)
{
  it_image *in1,*in2,*out1;
  int width,height,load_file,x,y;
  double con,val,min,max;
  it_float *in1_ptr,*in2_ptr,*out_ptr;
  char *jjj;
  double strtod();

  IFHELP
    {
      fprintf(stderr,"img%s - Subtract images or subtract constant\n",PRGNAME);
      fprintf(stderr,"img%s [constant]\n",PRGNAME);
      fprintf(stderr,"img%s [filename]\n",PRGNAME);
      fprintf(stderr,"  stdin: Float\n");
      fprintf(stderr,"  stdout: Float\n");
      fprintf(stderr,"  file: Float\n");
      exit(0);
    }

  imgStart(PRGNAME);

  if(argc!=1 && argc!=2)
    ERROR("invalid arguments");
  con=0.0;
  load_file=0;
  if(argc==2)
    {
      con=strtod(argv[1],&jjj);
      if(jjj==argv[1])
	load_file=1;
    }

  /* Loop for all images */
  do {
    in2=NULL;

    in1=i_read_image_file(stdin,IT_FLOAT,IM_FRAGMENT);
    if(in1==NULL)
      ERROR("can't import image file");
    width=in1->width;
    height=in1->height;

    out1=i_create_image(width,height,IT_FLOAT,IM_FRAGMENT);
    if(out1==NULL)
      ERROR("out of memory");

    if(argc==1)
      {
	in2=i_read_image_file(stdin,IT_FLOAT,IM_FRAGMENT);
	if(in2==NULL)
	  ERROR("can't import image file");
      }
    else if(load_file)
      {
	in2=i_load_image(argv[1],-1,IT_FLOAT,IM_FRAGMENT);
	if(in2==NULL)
	  ARG_ERROR("can't load image file %s",argv[1]);
      }

    imgInitMinMax(min,max);
    if(in2!=NULL)
      {
	/* Do an image operation */
	if(width!=in2->width || height!=in2->height)
	  ERROR("images are of different sizes");

	for(y=0;y<height;y++)
	  {
	    in1_ptr=im_float_row(in1,y);
	    in2_ptr=im_float_row(in2,y);
	    out_ptr=im_float_row(out1,y);
	    for(x=0;x<width;x++)
	      {
		val= (*in1_ptr++) OPERATOR (*in2_ptr++);
		*out_ptr++ =val;
		if(val>max) max=val;
		if(val<min) min=val;
	      }
	  }
	i_destroy_image(in2);
      }
    else
      {
	/* Do a constant operation */
	for(y=0;y<height;y++)
	  {
	    in1_ptr=im_float_row(in1,y);
	    out_ptr=im_float_row(out1,y);
	    for(x=0;x<width;x++)
	      {
		val= (*in1_ptr++) OPERATOR con;
		*out_ptr++ =val;
		if(val>max) max=val;
		if(val<min) min=val;
	      }
	  }
      }
    out1->min_value=min;
    out1->max_value=max;
    out1->valid_x=in1->valid_x;
    out1->valid_y=in1->valid_y;
    out1->valid_width=in1->valid_width;
    out1->valid_height=in1->valid_height;
    i_destroy_image(in1);
    i_write_image_file(stdout,out1,IF_BINARY);
    i_destroy_image(out1);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
