/*
 * Copyright(c) 1995,1996 by Gennady B. Sorokopud (gena@NetVision.net.il)
 *
 * This software can be freely redistributed and modified for 
 * non-commercial purposes as long as above copyright
 * message and this permission notice appear in all
 * copies of distributed source code and included as separate file
 * in binary distribution.
 *
 * Any commercial use of this software requires author's permission.
 *
 * This software is provided "as is" without expressed or implied
 * warranty of any kind.
 * Under no circumstances is the author responsible for the proper
 * functioning of this software, nor does the author assume any
 * responsibility for damages incurred with its use.
 *
 */

/* $Id: cfgfile.c,v 2.2 1997/10/15 14:02:56 gena Exp $
 */

#include <fmail.h>
#include <umail.h>

#define SECFILEMODE	00600	/* secure mode on file */
#define	CFGHASHMINSIZE	64	/* don't make hash less then this */

struct _xfdef xfdefs = { FL_SMALL_SIZE , -1 , -1 , -1 , -1 };

typedef struct __tagcfl {
char 	str[SLEN];
struct __tagcfl *next;
u_int	flags;
} __cfl;

static FILE *cfile = NULL;
static char __fname[PLEN]={"\0"};
static int changed = 0;
static struct __tagcfl **cfghasht = NULL;
static int cfghashtsize = 0;

#ifdef	CFGHASHTEST
int maxh = 0, total_acc = 0, total_scan = 0;
#endif

unsigned int
cfghash(cfgstr)
char *cfgstr;
{
unsigned int key = 0;
unsigned char c;

 while ((c = *cfgstr++) && (c != '=')) {
  key += c;
  key ^= (key << 24) | (key >> 8);
				       }

 return key % cfghashtsize;
}

void
cfgaddhash(tag)
struct __tagcfl *tag;
{
unsigned int key;

 key = cfghash(tag->str);
 tag->next = cfghasht[key];
 cfghasht[key] = tag;
}

struct __tagcfl *
cfgfindhash(cfgstr)
char *cfgstr;
{
unsigned int key;
struct __tagcfl *tag;
int len;
#ifdef	CFGHASHTEST
int i = 0;

 total_acc++;
#endif

 if (cfghashtsize == 0)
	return NULL;

 len = strlen(cfgstr);
 key = cfghash(cfgstr);
 tag = cfghasht[key];

 while (tag) 	{
  if (!strncmp(tag->str, cfgstr, len) && (tag->str[len] == '='))
	return tag;

  tag = tag->next;

#ifdef	CFGHASHTEST
  total_scan++;
  i++;
#endif
		}

#ifdef	CFGHASHTEST
 if (i > maxh)
	maxh = i;
#endif

 return NULL;
}

int
cfgdelhash(cfgstr)
char *cfgstr;
{
unsigned int key;
struct __tagcfl *tag, *tag1;

 key = cfghash(cfgstr);
 if ((tag = cfgfindhash(cfgstr)) == NULL)
	return -1;

 if (cfghasht[key] == tag) {
	cfghasht[key] = tag->next;
	free(tag);
	return 0;	   }

 tag1 = cfghasht[key];
 while (tag1->next != tag)
	tag1 = tag1->next;

 tag1->next = tag->next;
 free(tag);

 return 0;
}

void
cfgclearhash()
{
int i;
struct __tagcfl *tag, *tag1;

 for (i = 0; i < cfghashtsize; i++)	{
  tag = cfghasht[i];
  while (tag)  {
   tag1 = tag->next;
   free(tag);
   tag = tag1; }
  cfghasht[i] = NULL;
					}

 return;
}

void
cfgdestroyhash()
{
 cfgclearhash();

 if (cfghasht)
  free(cfghasht);
 cfghasht = NULL;
 cfghashtsize = 0;

 return;
}

void
cfg_lock(fn)
char *fn;
{
if (cfile != NULL) {
#ifdef HAVE_FLOCK
	flock(fileno(cfile), LOCK_UN);
#else
#ifdef HAVE_LOCKF
	lockf(fileno(cfile), F_ULOCK, 0);
#endif
#endif
	fclose(cfile);
		}

#if defined(HAVE_LOCKF) && !defined(HAVE_FLOCK)
if ((cfile=fopen(fn,"r+"))==NULL) {
#else
if ((cfile=fopen(fn,"r"))==NULL) {
#endif
	display_msg(MSG_WARN, "Can not open", "configuration file %s", fn);
	return; }

#ifdef HAVE_FLOCK
 if (flock(fileno(cfile), LOCK_EX | LOCK_NB) == -1)
#else
#ifdef HAVE_LOCKF
 if (lockf(fileno(cfile), F_TLOCK, 0) == -1)
#endif
#endif
        {
	fprintf(stderr, "Can not lock %s\nProbably XFMail is already running\n", fn);
	exit(1);
	}
}

void
cfg_unlock()
{
 if (cfile != NULL) {
#ifdef HAVE_FLOCK
	flock(fileno(cfile), LOCK_UN);
#else
#ifdef HAVE_LOCKF
	lockf(fileno(cfile), F_ULOCK, 0);
#endif
#endif
	fclose(cfile);
	}

 cfile = NULL;
}

int
save_cfg_file(file, nopwd)
char *file;
int nopwd;
{
FILE *cfd;
char buf[SLEN];
int i;
__cfl *tmpptr;

  if (!file)
	return -1;

  if ((cfd = fopen(file, "w")) == NULL) {
	display_msg(MSG_WARN, "save config", "Can not open %s", file);
	return -1;
					}

  for (i = 0; i < cfghashtsize; i++)	{
   tmpptr = cfghasht[i];
   while(tmpptr)
   {
    if (nopwd && (tmpptr->flags & CF_UNSECURE)) {
	tmpptr=tmpptr->next;
	continue;
				     		}

    sprintf(buf,"%s\n",tmpptr->str);
    if (fputs(buf, cfd) == EOF) {
	if (errno == ENOSPC)
		display_msg(MSG_WARN, "save config", "DISK FULL!");
	else
		display_msg(MSG_WARN, "save config", "Failed to write %s", file);
	return -1;
			        }

    tmpptr=tmpptr->next;
   }
					}

  fclose(cfd);
  return 0;
}

/*
 * This one flushes current config 
 */

int b_savecfg(ask)
int ask;
{
FILE *f;
char buf[SLEN], ctmp[SLEN];
int i;
__cfl *tmpptr;

if (ask && changed) 	{
	if (!display_msg(MSG_QUEST, "Configuration has been changed", "Do you want to save it?"))
		return 0;
			}

if (__fname[0] == '\0') 
	return -1;

sprintf(ctmp, "%s___temp", __fname);

if ((f=fopen(ctmp,"w"))==NULL) {
	display_msg(MSG_WARN, "Can not write to temporary config file", "%s", ctmp);
	return -1; }

for (i = 0; i < cfghashtsize; i++)	{
 tmpptr = cfghasht[i];
 while(tmpptr)
  {
    if (tmpptr->flags & DONT_STORE) {
	tmpptr=tmpptr->next;
	continue; }

    sprintf(buf,"%s\n",tmpptr->str);
    if (fputs(buf,f) == EOF) {
	if (errno == ENOSPC)
		display_msg(MSG_WARN, "save config", "DISK FULL!");
	else
		display_msg(MSG_WARN, "save config", "Failed to write %s", ctmp);
	fclose(f);
	unlink(ctmp);
	return -1;
			     }
    tmpptr=tmpptr->next;
  }
					}

if (fclose(f) == EOF) 	{
	if (errno == ENOSPC)
		display_msg(MSG_WARN, "save config", "DISK FULL!");
	else
		display_msg(MSG_WARN, "save config", "Failed to write %s", ctmp);
	unlink(ctmp);
	return -1;
			}

cfg_unlock();
#ifdef __EMX__ /* Under OS/2 the file will not be deleted during rename() */
 if (access(__fname, 0)==0) { 
 	if (unlink(__fname)!=0) {
		display_msg(MSG_WARN, "unlink", "delete %s before moving", __fname);
	}
 }
#endif
if (rename(ctmp, __fname) == -1)
	display_msg(MSG_WARN, "can not rename", "%s to %s", ctmp, __fname);
cfg_lock(__fname);
chmod(__fname,SECFILEMODE);

changed = 0;
#ifdef	CFGTEST
printf("Changed to 0 by b_savecfg\n");
#endif

return 1;
}

/*
 * This function preloads configuration file to be
 * changed in memory
 */

int
b_loadcfg(fn)
char *fn;
{
FILE *f;
char buf[SLEN + 1];
int i;
struct __tagcfl *tmpptr, *tmpptr1, *cfgl;

 cfgdestroyhash();
 cfgl = NULL;

cfg_unlock();

 if ((f = fopen(fn,"r")) == NULL)
   {
    if ((f = fopen(fn, "w")) == NULL) {
	display_msg(MSG_FATAL, "cfgload", "Can not create %s", fn);
	return -1;		  }

    goto endcfgload;
   }

while (fgets(buf,SLEN,f) != NULL)
 {
  if (buf[0] == '#')
	continue;

  if (strchr(buf, '=') == NULL)
	continue;

  strip_newline(buf);

  if (!(tmpptr=(struct __tagcfl *)malloc(sizeof(struct __tagcfl)))) {
	display_msg(MSG_FATAL, "cfgload", "malloc failed");
	return -1; 						    }

  strcpy(tmpptr->str,buf);

  tmpptr->next = cfgl;
  tmpptr->flags = 0;
  cfgl = tmpptr;

  cfghashtsize++;
 }

endcfgload:
strcpy(__fname,fn);
if (fclose(f) == EOF)	{
	display_msg(MSG_WARN, "cfgload", "Failed to load config file");
	return -1;	}

cfg_lock(__fname);

if (cfghashtsize < CFGHASHMINSIZE)
	cfghashtsize = CFGHASHMINSIZE;

cfghasht = (struct __tagcfl **)malloc(sizeof(struct __tagcfl *) * cfghashtsize);
if (cfghasht == NULL) {
	display_msg(MSG_FATAL, "cfgload", "malloc failed");
	return -1;    }

for (i = 0; i < cfghashtsize; i++)
	cfghasht[i] = NULL;

tmpptr = cfgl;
while (tmpptr) 	{
 tmpptr1 = tmpptr->next;
 cfgaddhash(tmpptr);
 tmpptr = tmpptr1;
		}

#ifdef	CFGHASHTEST
/* test hash */
for (i = 0; i < cfghashtsize; i++) {
 tmpptr = cfghasht[i];
 while (tmpptr) {
  cfgfindhash(tmpptr);
  tmpptr = tmpptr->next;
		}
				   }

printf("Hash statistics: \n");
printf(" Length: %d\n", cfghashtsize);
printf(" Average depth: %2.2f\n", (float)total_scan/(float)total_acc);
printf(" Max depth: %d\n", maxh);
/* end test */
#endif

return 0;
}

int
cfg_check_version()
{
 if (cfghasht && strcmp(VERSION, b_getcfg_str(conf_name, "xfversion", ""))) {
  if (!display_msg(MSG_QUEST|MSG_DEFNO, "Configuration file belongs", "to different version of XFMail, use it anyway?"))
	cfgclearhash();

  b_putcfg_str(conf_name, "xfversion", VERSION);
  return 1;
									    }

 return 0;
}

void
b_setcfg_flags(ln,flags)
char *ln;
int flags;
{
__cfl *tmpptr;

 if ((tmpptr = cfgfindhash(ln)) == NULL) {
  if ((tmpptr=(__cfl *)malloc(sizeof(__cfl)))==NULL)  	{
	display_msg(MSG_FATAL, "config", "malloc  failed!");
	return; 					}

  sprintf(tmpptr->str,"%s=", ln);
  tmpptr->next = NULL;
  tmpptr->flags = flags;
  if (!(flags & DONT_STORE) &&
   !(flags & CF_NOTCHANGED))	{
	changed = 1;
#ifdef	CFGTEST
	printf("changed to 1 by %s in b_setcfg_flags\n", tmpptr->str);
#endif
				}
  cfgaddhash(tmpptr);	     		}

 tmpptr->flags = flags;

 return;
}

/*
 * This function deletes string from configuration file
 */
int
b_delcfg_str(fn, ln)
char *fn;
char *ln;
{
 if (cfgfindhash(ln) == NULL)
	return 0;

 changed = 1;
#ifdef	CFGTEST
	printf("changed to 1 by b_delcfg_str\n");
#endif
 return cfgdelhash(ln);
}

/*
 * This function adds string to configuration file
 */
int
b_putcfg_str(fn,ln,b)
char *fn, *ln, *b;
{
__cfl *tmpptr;
char *p;

 if (!ln || !b)
	return -1;

 if ((strlen(ln) + strlen(b) + 2) >= SLEN) {
	display_msg(MSG_WARN, "config", "Line too long");
	return -1;			   }

 if ((tmpptr = cfgfindhash(ln)) != NULL) {
  if (!(tmpptr->flags & DONT_STORE) &&
   !(tmpptr->flags & CF_NOTCHANGED)) {
	if ((p = strchr(tmpptr->str, '=')) == NULL)
		return -1;
	p++;
	if (strcmp(p, b)) {
	 changed = 1;
#ifdef	CFGTEST
	printf("changed to 1 by %s: %s -> %s in b_putcfg_str\n", ln, p, b);
#endif
			  }
				     }

  strcpy(tmpptr->str, ln);
  strcat(tmpptr->str, "=");
  strcat(tmpptr->str, b);
  return 0;				 }
  
 if ((tmpptr = (__cfl *)malloc(sizeof(__cfl))) == NULL) {
	display_msg(MSG_FATAL, "config", "malloc failed");
	return -1;					}

 tmpptr->flags = 0;
 tmpptr->next = NULL;
 sprintf(tmpptr->str, "%s=%s", ln, b);

 cfgaddhash(tmpptr);
 changed = 1;
#ifdef	CFGTEST
	printf("changed to 1 by add %s: %s in b_putcfg_str\n", ln, b);
#endif

 return 0;
}

/*
 * Check if specific config entry exists
 */
int
cfg_exist(ln)
char *ln;
{
 return cfgfindhash(ln) ? 1 : 0;
}

/*
 * This function gets configuration text string from
 * named file.
 * 
 */

char *
b_getcfg_str(fn,ln, def)
char *fn, *ln, *def;
{
struct __tagcfl *cfg;
char *p;

 if ((cfg = cfgfindhash(ln)) != NULL)	{
	p = strchr(cfg->str, '=');
	p++;
	return p;			}

 b_putcfg_str(fn, ln, def);
 if ((cfg = cfgfindhash(ln)) == NULL)
	return NULL;

 p = strchr(cfg->str, '=');
 p++;

 return p;
}

char *
b_getcfg_str_default(char *fn, char *ln, char *def, int return_default)
{
  if (return_default)
  	return def;
  else
  	return b_getcfg_str(fn,ln,def);
}

int
b_putcfg_int(fn,ln,i)
char *fn, *ln; 
int i;
{
char buf[10];

 sprintf(buf,"%d",i);
 return b_putcfg_str(fn,ln,buf);
}

int
b_getcfg_int(fn,ln,def)
char *fn, *ln; 
int def;
{
char *buf;
char ibuf[10];

 sprintf(ibuf,"%d",def);
 if (!(buf=b_getcfg_str(fn,ln,ibuf)))
	return def;

 return atoi(buf);
}

int
b_getcfg_int_default(char *fn, char *ln, int def, int return_default)
{
  if (return_default)
  	return def;
  else
  	return b_getcfg_int(fn,ln,def);
}

void
read_xfdefaults()
{
FL_IOPT cntl;
u_long mask;
char xfdef[255], *p;
FILE *xf;

  mask = FL_PDBorderWidth;
  cntl.borderWidth = 2;

  sprintf(xfdef, "%s/.xfdefaults", configdir);
  if ((xf = fopen(xfdef, "r")) == NULL)
	goto xfdef_int;

  while (fgets(xfdef, 255, xf)) {
   if ((xfdef[0] == '#') ||
	(xfdef[0] == '!'))
	continue;

   strip_newline(xfdef);
   if ((p = strchr(xfdef, '=')) == NULL)
	continue;

   *p = '\0';
   p++;
   if (!strcmp(xfdef, "Depth")) 	{
	mask |= FL_PDDepth;
	sscanf(p, "%d", &cntl.depth);
				}	
   else
   if (!strcmp(xfdef, "VisualClass")) 	{
	mask |= FL_PDClass;
	sscanf(p, "%d", &cntl.vclass);
				}	
   else
   if (!strcmp(xfdef, "DoubleBuffer")) 	{
	mask |= FL_PDDouble;
	sscanf(p, "%d", &cntl.doubleBuffer);
				}	
   else
   if (!strcmp(xfdef, "ButtonFontSize")) 	{
	mask |= FL_PDButtonFontSize;
	sscanf(p, "%d", &cntl.buttonFontSize);
				}	
   else
   if (!strcmp(xfdef, "SliderFontSize")) 	{
	mask |= FL_PDSliderFontSize;
	sscanf(p, "%d", &cntl.sliderFontSize);
				}	
   else
   if (!strcmp(xfdef, "MenuFontSize")) 	{
	mask |= FL_PDMenuFontSize;
	sscanf(p, "%d", &cntl.menuFontSize);
				}	
   else
   if (!strcmp(xfdef, "ChoiceFontSize")) 	{
	mask |= FL_PDChoiceFontSize;
	sscanf(p, "%d", &cntl.choiceFontSize);
				}	
   else
   if (!strcmp(xfdef, "BrowserFontSize")) 	{
	mask |= FL_PDBrowserFontSize;
	sscanf(p, "%d", &cntl.browserFontSize);
				}	
   else
   if (!strcmp(xfdef, "InputFontSize")) {
	mask |= FL_PDInputFontSize;
	sscanf(p, "%d", &cntl.inputFontSize);
				}	
   else
   if (!strcmp(xfdef, "LabelFontSize")) 	{
	mask |= FL_PDLabelFontSize;
	sscanf(p, "%d", &cntl.labelFontSize);
				}	
   else
   if (!strcmp(xfdef, "PopUpFontSize")) 	{
/*
	mask |= FL_PDPupFontSize;
*/
	sscanf(p, "%d", &cntl.pupFontSize);
	xfdefs.popfsize = cntl.pupFontSize;
				}	
   else
   if (!strcmp(xfdef, "PopUpFontStyle")) 	{
	sscanf(p, "%d", &cntl.pupFontStyle);
	xfdefs.popfstyle = cntl.pupFontStyle;
				}	
   else
   if (!strcmp(xfdef, "PopUpCursor"))
	sscanf(p, "%d", &xfdefs.popcursor);
   else
   if (!strcmp(xfdef, "PopUpBgCol"))
	sscanf(p, "%d", &xfdefs.popbgcol);
   else
   if (!strcmp(xfdef, "PopUpFgCol"))
	sscanf(p, "%d", &xfdefs.popfgcol);
   else
   if (!strcmp(xfdef, "PrivateMap")) 	{
	mask |= FL_PDPrivateMap;
	sscanf(p, "%d", &cntl.privateColormap);
				}	
   else
   if (!strcmp(xfdef, "SharedMap")) 	{
	mask |= FL_PDSharedMap;
	sscanf(p, "%d", &cntl.sharedColormap);
				}	
   else
   if (!strcmp(xfdef, "StandardMap")) 	{
	mask |= FL_PDStandardMap;
	sscanf(p, "%d", &cntl.standardColormap);
				}	
   else
   if (!strcmp(xfdef, "BorderWidth")) 	{
	mask |= FL_PDBorderWidth;
	sscanf(p, "%d", &cntl.borderWidth);
				}	

				}
  fclose(xf);

xfdef_int:
  if (cfg_exist("InputFontFSize")) {
	mask |= FL_PDInputFontSize;
	cntl.inputFontSize = b_getcfg_int(conf_name, "InputFontFSize", 0);
				  }

  if (cfg_exist("LabelFontFSize")) {
	mask |= FL_PDLabelFontSize;
	cntl.labelFontSize = b_getcfg_int(conf_name, "LabelFontFSize", 0);
				  }

  if (cfg_exist("ChoiceFontFSize")) {
	mask |= FL_PDChoiceFontSize;
	cntl.choiceFontSize = b_getcfg_int(conf_name, "ChoiceFontFSize", 0);
				  }

  if (cfg_exist("MenuFontFSize")) {
	mask |= FL_PDMenuFontSize;
	cntl.menuFontSize = b_getcfg_int(conf_name, "MenuFontFSize", 0);
				  }

  if (cfg_exist("BrowserFontFSize")) {
	mask |= FL_PDBrowserFontSize;
	cntl.browserFontSize = b_getcfg_int(conf_name, "BrowserFontFSize", 0);
				  }

  if (cfg_exist("ButtonFontFSize")) {
	mask |= FL_PDButtonFontSize;
	cntl.buttonFontSize = b_getcfg_int(conf_name, "ButtonFontFSize", 0);
				  }

  if (cfg_exist("PopUpFontFSize")) {
/*
	mask |= FL_PDPupFontSize;
	cntl.pupFontSize = b_getcfg_int(conf_name, "PopUpFontFSize", 0);
*/
	xfdefs.popfsize = b_getcfg_int(conf_name, "PopUpFontFSize", 0);
				  }

  if (cfg_exist("SliderFontFSize")) {
	mask |= FL_PDSliderFontSize;
	cntl.sliderFontSize = b_getcfg_int(conf_name, "SliderFontFSize", 0);
				  }

  if (mask != 0L)
	fl_set_defaults(mask, &cntl);

  return;
}

