/*
 * Copyright(c) 1995,1996 by Gennady B. Sorokopud (gena@NetVision.net.il)
 *
 * This software can be freely redistributed and modified for 
 * non-commercial purposes as long as above copyright
 * message and this permission notice appear in all
 * copies of distributed source code and included as separate file
 * in binary distribution.
 *
 * Any commercial use of this software requires author's permission.
 *
 * This software is provided "as is" without expressed or implied
 * warranty of any kind.
 * Under no circumstances is the author responsible for the proper
 * functioning of this software, nor does the author assume any
 * responsibility for damages incurred with its use.
 *
 */

/* $Id: inc.c,v 2.0 1997/09/23 15:55:05 gena Exp $
 */

#include <fmail.h>
#include <umail.h>
#include <choose_folder.h>
#include "configform.h"

static FD_config_receive *inc_obj;
static FD_config_timers  *timers_obj;

void Inc_inp_Call(FL_OBJECT *obj, long param)
{
}

void Inc_NSound_Call(FL_OBJECT *obj, long param)
{
 fl_deactivate_object(inc_obj->Inc_Play);
 fl_deactivate_object(inc_obj->Inc_Command);
}

void Inc_Beep_Call(FL_OBJECT *obj, long param)
{
 fl_deactivate_object(inc_obj->Inc_Play);
 fl_deactivate_object(inc_obj->Inc_Command);
}

void Inc_SFile_Call(FL_OBJECT *obj, long param)
{
 fl_activate_object(inc_obj->Inc_Play);
 fl_deactivate_object(inc_obj->Inc_Command);
 fl_set_focus_object(inc_obj->config_receive, inc_obj->Inc_Play);
}

void Inc_SCommand_Call(FL_OBJECT *obj, long param)
{
 fl_deactivate_object(inc_obj->Inc_Play);
 fl_activate_object(inc_obj->Inc_Command);
 fl_set_focus_object(inc_obj->config_receive, inc_obj->Inc_Command);
}

void Inc_Count_Call(FL_OBJECT *obj, long param)
{
}

void Inc_Play_Call(FL_OBJECT *obj, long param)
{
 play_sound((char *)fl_get_input(obj), 100);
}

void Inc_Start_Call(FL_OBJECT *obj, long param)
{
}

void Inc_From_Spool_Call(FL_OBJECT *obj, long param)
{
}

void Inc_Icon_Call(FL_OBJECT *obj, long param)
{
}

void Inc_From_POP_Call(FL_OBJECT *obj, long param)
{
if (fl_get_button(inc_obj->Inc_From_POP))
	fl_show_message("POP access", "Do not forget to configure POP server", "in Config/POP menu");
}

void Inc_From_IMAP_Call(FL_OBJECT *obj, long param)
{
if (fl_get_button(inc_obj->Inc_From_IMAP))
	fl_show_message("IMAP access", "Do not forget to configure IMAP server", "in Config/IMAP menu");
}

void
inc_conf(int set_default, FD_config_receive *form) 
{
char spool[255];

 inc_obj = form;
 sprintf(spool, "%s/%s", _PATH_MAILDIR, user_n);
 fl_set_input(inc_obj->Inc_Inp, b_getcfg_str_default(conf_name, "spool", spool, set_default));

 fl_set_button(inc_obj->Inc_Start, b_getcfg_int_default(conf_name,"inconstart", 0, set_default));
 fl_set_button(inc_obj->Inc_Leave, b_getcfg_int_default(conf_name,"spoolnotrunc", 0, set_default));

 switch(b_getcfg_int_default(conf_name,"beep", 1, set_default)) {
  case 0:
	fl_set_button(inc_obj->Inc_NSound, 1);
	fl_set_button(inc_obj->Inc_Beep, 0);
	fl_set_button(inc_obj->Inc_SFile, 0);
	fl_set_button(inc_obj->Inc_SCommand, 0);
	fl_deactivate_object(inc_obj->Inc_Play);
	fl_deactivate_object(inc_obj->Inc_Command);
  break;

  case 1:
	fl_set_button(inc_obj->Inc_NSound, 0);
	fl_set_button(inc_obj->Inc_Beep, 1);
	fl_set_button(inc_obj->Inc_SFile, 0);
	fl_set_button(inc_obj->Inc_SCommand, 0);
	fl_deactivate_object(inc_obj->Inc_Play);
	fl_deactivate_object(inc_obj->Inc_Command);
  break;

  case 2:
	fl_set_button(inc_obj->Inc_NSound, 0);
	fl_set_button(inc_obj->Inc_Beep, 0);
	fl_set_button(inc_obj->Inc_SFile, 1);
	fl_set_button(inc_obj->Inc_SCommand, 0);
	fl_activate_object(inc_obj->Inc_Play);
	fl_deactivate_object(inc_obj->Inc_Command);
	fl_set_input(inc_obj->Inc_Play, b_getcfg_str_default(conf_name, "play", "", set_default));
  break;

  case 3:
	fl_set_button(inc_obj->Inc_NSound, 0);
	fl_set_button(inc_obj->Inc_Beep, 0);
	fl_set_button(inc_obj->Inc_SFile, 0);
	fl_set_button(inc_obj->Inc_SCommand, 1);
	fl_deactivate_object(inc_obj->Inc_Play);
	fl_activate_object(inc_obj->Inc_Command);
	fl_set_input(inc_obj->Inc_Command, b_getcfg_str_default(conf_name, "play", "", set_default));
  break;

  default:
	fl_set_button(inc_obj->Inc_NSound, 1);
	fl_set_button(inc_obj->Inc_Beep, 0);
	fl_set_button(inc_obj->Inc_SFile, 0);
	fl_set_button(inc_obj->Inc_SCommand, 0);
	fl_deactivate_object(inc_obj->Inc_Play);
	fl_deactivate_object(inc_obj->Inc_Command);
  break;
					  }

 fl_set_button(inc_obj->Inc_From_POP,b_getcfg_int_default(conf_name, "popretr", 0, set_default));
 fl_set_button(inc_obj->Inc_From_IMAP,b_getcfg_int_default(conf_name, "imapretr", 0, set_default));
 fl_set_button(inc_obj->Inc_From_Spool,b_getcfg_int_default(conf_name, "spoolretr", 1, set_default));

 fl_set_button(inc_obj->Misc_SAddr, b_getcfg_int_default(conf_name,"saveaddr",0, set_default));
 fl_set_button(inc_obj->Inc_Show, b_getcfg_int_default(conf_name,"incresults",1, set_default));
}

void
handle_inc_input(FD_config_receive *form)
{
char maildir[255];
struct _mail_folder *fld;

 inc_obj = form;
 b_putcfg_int(conf_name, "inconstart", fl_get_button(inc_obj->Inc_Start));
 b_putcfg_int(conf_name, "spoolnotrunc", fl_get_button(inc_obj->Inc_Leave));

 if (fl_get_button(inc_obj->Inc_NSound))
	b_putcfg_int(conf_name, "beep", 0);
 else
 if (fl_get_button(inc_obj->Inc_Beep))
	b_putcfg_int(conf_name, "beep", 1);
 else
 if (fl_get_button(inc_obj->Inc_SFile))     {
	b_putcfg_int(conf_name, "beep", 2);
	b_putcfg_str(conf_name, "play", (char *)fl_get_input(inc_obj->Inc_Play));
					    }
 else
 if (fl_get_button(inc_obj->Inc_SCommand))  {
	b_putcfg_int(conf_name, "beep", 3);
	b_putcfg_str(conf_name, "play", (char *)fl_get_input(inc_obj->Inc_Command));
					    }
 else
	b_putcfg_int(conf_name, "beep", 0);

 b_putcfg_str(conf_name, "spool", (char *)fl_get_input(inc_obj->Inc_Inp));
 if (fl_get_button(inc_obj->Inc_From_Spool)) {
 sprintf(maildir, "%s/%s", _PATH_MAILDIR, user_n);
 if (get_mbox_folder_by_path(b_getcfg_str(conf_name, "spool", maildir)) == NULL) {
 if ((fld = create_mbox_folder(NULL, b_getcfg_str(conf_name, "spool", maildir))) == NULL)
        display_msg(MSG_WARN, "Config", "Can not access %s", b_getcfg_str(conf_name, "spool", maildir));
  else  {
        fld->status |= (SYSTEM|NOINFR);
        if (fld->sname)
                free(fld->sname);
        fld->sname = strdup("spool");
        if (!fld->descr)
                fld->descr = strdup("spool mailbox");
	fld->open(fld, FOPEN_NOCACHE);
	sort_folders();
	redraw_fld_win();
        }
 }
					    }

 b_putcfg_int(conf_name, "popretr", fl_get_button(inc_obj->Inc_From_POP));
 b_putcfg_int(conf_name, "imapretr", fl_get_button(inc_obj->Inc_From_IMAP));
 b_putcfg_int(conf_name, "spoolretr", fl_get_button(inc_obj->Inc_From_Spool));

 b_putcfg_int(conf_name, "saveaddr", fl_get_button(inc_obj->Misc_SAddr));
 b_putcfg_int(conf_name, "incresults", fl_get_button(inc_obj->Inc_Show));
 return;         
}

void
timers_conf(int set_default, FD_config_timers *form)
{
 timers_obj = form;

 fl_set_counter_bounds(timers_obj->Inc_Count, 0, 120);
 fl_set_counter_precision(timers_obj->Inc_Count, 2);
 fl_set_counter_step(timers_obj->Inc_Count, 0.25, 5);
 fl_set_counter_value(timers_obj->Inc_Count, (double)((double)b_getcfg_int_default(conf_name,"inctime",180, set_default)/(double)60));

 fl_set_counter_bounds(timers_obj->Inc_Send, 0, 60);
 fl_set_counter_precision(timers_obj->Inc_Send, 1);
 fl_set_counter_step(timers_obj->Inc_Send, 0.5, 5);
 fl_set_counter_value(timers_obj->Inc_Send, (double)((double)b_getcfg_int_default(conf_name,"sendtime",0, set_default)/(double)60));

 fl_set_counter_bounds(timers_obj->Timer_Trash, 0, 48);
 fl_set_counter_precision(timers_obj->Timer_Trash, 1);
 fl_set_counter_step(timers_obj->Timer_Trash, 0.5, 5);
 fl_set_counter_value(timers_obj->Timer_Trash, (double)((double)b_getcfg_int_default(conf_name,"trashtime",0, set_default)/(double)60));

 fl_set_counter_bounds(timers_obj->Timer_Autosave, 0, 60);
 fl_set_counter_precision(timers_obj->Timer_Autosave, 1);
 fl_set_counter_step(timers_obj->Timer_Autosave, 0.5, 5);
 fl_set_counter_value(timers_obj->Timer_Autosave, (double)((double)b_getcfg_int_default(conf_name,"asavetime",180, set_default)/(double)60));

 fl_set_counter_bounds(timers_obj->Timer_IMAP, 0, 120);
 fl_set_counter_precision(timers_obj->Timer_IMAP, 2);
 fl_set_counter_step(timers_obj->Timer_IMAP, 0.25, 5);
 fl_set_counter_value(timers_obj->Timer_IMAP, (double)((double)b_getcfg_int_default(conf_name,"imaptime",600, set_default)/(double)60));

 fl_set_button(timers_obj->Inc_Icon, b_getcfg_int_default(conf_name,"incwhenicon", 1, set_default));
}

void
handle_timers_input(FD_config_timers *form)
{
int i;
 timers_obj = form;
 b_putcfg_int(conf_name, "inctime", (int)(fl_get_counter_value(timers_obj->Inc_Count) * 60));
 b_putcfg_int(conf_name, "sendtime", (int)(fl_get_counter_value(timers_obj->Inc_Send) * 60));
 b_putcfg_int(conf_name, "trashtime", (int)(fl_get_counter_value(timers_obj->Timer_Trash) * 60));
 b_putcfg_int(conf_name, "asavetime", (int)(fl_get_counter_value(timers_obj->Timer_Autosave) * 60));
 b_putcfg_int(conf_name, "imaptime", (int)(fl_get_counter_value(timers_obj->Timer_IMAP) * 60));

 fl_set_timer(inc_timer, b_getcfg_int(conf_name,"inctime",180));

 i = b_getcfg_int(conf_name,"sendtime",0);
 if (i)
	i++;
 fl_set_timer(send_timer, i);

 i = b_getcfg_int(conf_name,"trashtime",0);
 if (i)
	i += 2;
 fl_set_timer(trash_timer, i);

 if (asave_timer) {
  i = b_getcfg_int(conf_name,"asavetime",0);
  if (i)
	i += 3;
  fl_set_timer(asave_timer, i);
		  }

 b_putcfg_int(conf_name, "incwhenicon", fl_get_button(timers_obj->Inc_Icon));

 return;         
}
