/*
 * Copyright(c) 1995,1996 by Gennady B. Sorokopud (gena@NetVision.net.il)
 *
 * This software can be freely redistributed and modified for 
 * non-commercial purposes as long as above copyright
 * message and this permission notice appear in all
 * copies of distributed source code and included as separate file
 * in binary distribution.
 *
 * Any commercial use of this software requires author's permission.
 *
 * This software is provided "as is" without expressed or implied
 * warranty of any kind.
 * Under no circumstances is the author responsible for the proper
 * functioning of this software, nor does the author assume any
 * responsibility for damages incurred with its use.
 *
 */

/* $Id: misc.c,v 1.19 1995/08/17 13:35:04 gena Exp $
 */

#include <fmail.h>
#include <umail.h>
#include <choose_folder.h>
#include "configform.h"

static FD_config_reply *reply_obj;

void Reply_Call(FL_OBJECT *obj, long param)
{
}

void
reply_conf(int set_default, FD_config_reply *form) 
{
 reply_obj = form;

 fl_clear_choice(reply_obj->Reply_INType);
 fl_addto_choice(reply_obj->Reply_INType, "no auto include");
 fl_addto_choice(reply_obj->Reply_INType, "indented");
 fl_addto_choice(reply_obj->Reply_INType, "not indented");
 fl_set_choice(reply_obj->Reply_INType, b_getcfg_int_default(conf_name, "include", 2, set_default));

 fl_clear_choice(reply_obj->Reply_MIME);
 fl_addto_choice(reply_obj->Reply_MIME, "never");
 fl_addto_choice(reply_obj->Reply_MIME, "always");
 fl_addto_choice(reply_obj->Reply_MIME, "ask");
 fl_set_choice(reply_obj->Reply_MIME, b_getcfg_int_default(conf_name, "inclmime", 3, set_default));

 fl_clear_choice(reply_obj->Reply_All);
 fl_addto_choice(reply_obj->Reply_All, "never");
 fl_addto_choice(reply_obj->Reply_All, "always");
 fl_addto_choice(reply_obj->Reply_All, "ask");
 fl_set_choice(reply_obj->Reply_All, b_getcfg_int_default(conf_name, "inclrecp", 3, set_default));

 fl_set_input(reply_obj->Reply_Prefix, b_getcfg_str_default(conf_name, "prefix", ">", set_default));

 fl_set_input(reply_obj->Reply_Str, b_getcfg_str_default(conf_name, "replystr", "On %d %f wrote:%n", set_default));
 fl_set_input(reply_obj->Reply_And, b_getcfg_str_default(conf_name, "replyexand", "", set_default));
 fl_set_button(reply_obj->Reply_Exclude, b_getcfg_int_default(conf_name, "replyex", 1, set_default));
 fl_set_input(reply_obj->Forward_Str, b_getcfg_str_default(conf_name, "fwdstr", "-----FW: %i-----%n%n", set_default));
 fl_set_button(reply_obj->Reply_Charset, b_getcfg_int_default(conf_name, "replykeepchset", 0, set_default));
 fl_set_button(reply_obj->Reply_Keep, b_getcfg_int_default(conf_name, "replykeep", 0, set_default));

 fl_clear_choice(reply_obj->Forward_INType);
 fl_addto_choice(reply_obj->Forward_INType, "do not include");
 fl_addto_choice(reply_obj->Forward_INType, "short");
 fl_addto_choice(reply_obj->Forward_INType, "full");
 fl_addto_choice(reply_obj->Forward_INType, "MIME");
 fl_set_choice(reply_obj->Forward_INType, b_getcfg_int_default(conf_name, "fwdinclude", 2, set_default));
}

void
handle_reply_input(FD_config_reply *form)
{
 reply_obj = form;
 b_putcfg_str(conf_name, "prefix", (char *)fl_get_input(reply_obj->Reply_Prefix));

 b_putcfg_str(conf_name, "replystr", (char *)fl_get_input(reply_obj->Reply_Str));
 b_putcfg_str(conf_name, "fwdstr", (char *)fl_get_input(reply_obj->Forward_Str));

 b_putcfg_int(conf_name, "include", fl_get_choice(reply_obj->Reply_INType));
 b_putcfg_int(conf_name, "inclmime", fl_get_choice(reply_obj->Reply_MIME));
 b_putcfg_int(conf_name, "inclrecp", fl_get_choice(reply_obj->Reply_All));
 b_putcfg_int(conf_name, "fwdinclude",fl_get_choice(reply_obj->Forward_INType));
 b_putcfg_int(conf_name, "replyex", fl_get_button(reply_obj->Reply_Exclude));
 b_putcfg_str(conf_name, "replyexand", (char *)fl_get_input(reply_obj->Reply_And));
 b_putcfg_int(conf_name, "replykeepchset", fl_get_button(reply_obj->Reply_Charset));
 b_putcfg_int(conf_name, "replykeep", fl_get_button(reply_obj->Reply_Keep));
}

