/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.1/rpc/sources/RCS/ui_rpcsel.c,v $
  SHORTNAME      : ui_rpcsel
  SNNS VERSION   : 4.1
  
  PURPOSE        : 
  NOTES          :
  
  AUTHOR         : Sven Doering
  DATE           : 
  
  CHANGED BY     : 
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 1.5 $
  LAST CHANGE    : $Date: 1995/11/16 07:27:57 $
  
  (c) 1994 by Sven Doering and the SNNS-Group
  
******************************************************************************/

#ifdef RPCSNNS
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <sys/types.h>
#include <rpc/rpc.h>

#include <X11/Intrinsic.h>
#include <X11/Composite.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/AsciiSrc.h>

#include "ui.h"
#include "ui_mainP.h"
#include "kr_ui_rpc.h"
#include "ui_rpcsnns.h"
#include "ui_rpcP.h"
#include "ui_xWidgets.h"

#include "ui_rpcsel.ph"

/*****************************************************************************
  FUNCTION : ui_RPCmoveItemRightCallback

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/

static void
ui_RPCmoveItemRightCallback(Widget w, caddr_t client_data, caddr_t data)
{
  if (aktselitem1 >= 0 && aktselitem1 < anzitemlist1){
    itemsList[notselectedShowItems[aktselitem1]].selected = TRUE;
    anzitemlist1--;
    selectedShowItems[anzitemlist2]=notselectedShowItems[aktselitem1];
    anzitemlist2++;
    selectedShowItems[anzitemlist2]=-1;
  }
  ui_RPC_createOrderdItemsLists();
  XawListChange(RPCselItemsL1, seliteml1, 0, 0, True);
  XawListChange(RPCselItemsL2, seliteml2, 0, 0, True);
  if(anzitemlist1 >0 && aktselitem1 < anzitemlist1 )
    XawListHighlight(RPCselItemsL1,aktselitem1);
  if(anzitemlist2 >0 && aktselitem2 < anzitemlist2)
    XawListHighlight(RPCselItemsL2,aktselitem2);
}

/*****************************************************************************
  FUNCTION : ui_RPCmoveItemLeftCallback

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/

static void
ui_RPCmoveItemLeftCallback(Widget w, caddr_t client_data, caddr_t data)
{
  if (aktselitem2 >=0 && aktselitem2 < anzitemlist2){
    itemsList[selectedShowItems[aktselitem2]].selected = FALSE;
    /* Delete from list1 */
    memcpy(&selectedShowItems[aktselitem2],&selectedShowItems[aktselitem2+1],
	   (anzitemlist2-aktselitem2)*sizeof(int) );
    selectedShowItems[anzitemlist2]=-1;
    anzitemlist2--;
  }
  ui_RPC_createOrderdItemsLists();
  XawListChange(RPCselItemsL1, seliteml1, 0, 0, True);
  XawListChange(RPCselItemsL2, seliteml2, 0, 0, True);
  if(anzitemlist1 >0 && aktselitem1 < anzitemlist1)
    XawListHighlight(RPCselItemsL1,aktselitem1);
  if(anzitemlist2 >0 && aktselitem2 < anzitemlist2)
    XawListHighlight(RPCselItemsL2,aktselitem2);
}
/*****************************************************************************
  FUNCTION : ui_RPCmoveItemUpCallback

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/

static void
ui_RPCmoveItemUpCallback(Widget w, caddr_t client_data, caddr_t data)
{
  int tmppos;

  if (aktselitem2 > 0 && aktselitem2 < anzitemlist2){
    tmppos = selectedShowItems[aktselitem2];
    selectedShowItems[aktselitem2] = selectedShowItems[aktselitem2-1];
    selectedShowItems[aktselitem2-1] = tmppos;
    aktselitem2--;
  }
  ui_RPC_createOrderdItemsLists();
  XawListChange(RPCselItemsL1, seliteml1, 0, 0, True);
  XawListChange(RPCselItemsL2, seliteml2, 0, 0, True);
  if(anzitemlist1 >0 && aktselitem1 < anzitemlist1)
    XawListHighlight(RPCselItemsL1,aktselitem1);
  if(anzitemlist2 >0 && aktselitem2 < anzitemlist2)
    XawListHighlight(RPCselItemsL2,aktselitem2);
}
/*****************************************************************************
  FUNCTION : ui_RPCmoveItemDownCallback

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/

static void
ui_RPCmoveItemDownCallback(Widget w, caddr_t client_data, caddr_t data)
{
  int tmppos;

  if (aktselitem2 >=0 && aktselitem2 < anzitemlist2-1){
    tmppos = selectedShowItems[aktselitem2];
    selectedShowItems[aktselitem2] = selectedShowItems[aktselitem2+1];
    selectedShowItems[aktselitem2+1] = tmppos;
    aktselitem2++;
  }
  ui_RPC_createOrderdItemsLists();
  XawListChange(RPCselItemsL1, seliteml1, 0, 0, True);
  XawListChange(RPCselItemsL2, seliteml2, 0, 0, True);
  if(anzitemlist1 >0 && aktselitem1 < anzitemlist1)
    XawListHighlight(RPCselItemsL1,aktselitem1);
  if(anzitemlist2 >0 && aktselitem2 < anzitemlist2)
    XawListHighlight(RPCselItemsL2,aktselitem2);
}

/*****************************************************************************
  FUNCTION : ui_RPCselItemsCallback

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/

static void
ui_RPCselItemCallback(Widget w, caddr_t client_data, XawListReturnStruct * selektion)
{
  if((int)client_data==1)
    aktselitem1 = selektion->list_index;
  else
    aktselitem2 = selektion->list_index;
}
/*****************************************************************************
  FUNCTION : ui_RPCselItemCloseCallback

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/

static void
ui_RPCselItemCloseCallback(Widget w, caddr_t client_data, XawListReturnStruct * selektion)
{
  int i;
  XtDestroyWidget(ui_popRPCselItem);
  ui_RPCselectHostPanelItemsIsCreated = FALSE;
  for (i = 0 ; i < anzHostEntries ;i ++)
    ui_RPCchangeListEntry(i);
  ui_MakeHostList();
}

/*****************************************************************************
  FUNCTION : ui_RPC_createOrderdItemList

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/

static void
ui_RPC_createOrderdItemsLists(void)
{
  int i;
  
  anzitemlist1 = 0;
  seliteml1[0] = NULL;
  seliteml2[0] = NULL;
  
  for(i = 0 ; i < MAXITEMS ;i++){
    if(!itemsList[i].selected && itemsList[i].formatstr != NULL){
      seliteml1[anzitemlist1]=itemsList[i].name;
      notselectedShowItems[anzitemlist1]=i;
      anzitemlist1++;
    }
  }
  for(i = 0 ; i < anzitemlist2 ;i++){
      seliteml2[i]=itemsList[selectedShowItems[i]].name;
  }
  notselectedShowItems[anzitemlist1]=-1;
  seliteml1[anzitemlist1]=NULL;
  seliteml2[anzitemlist2]=NULL;
  
  return;
}

/*****************************************************************************
  FUNCTION : ui_RPC_createItemList

  PURPOSE  :
  RETURNS  : void
  NOTES    :

  UPDATE   :
*****************************************************************************/

void
ui_RPC_createItemsLists(void)
{
  int i;
  
  anzitemlist1 = 0;
  seliteml1[0] = NULL;
  anzitemlist2 = 0;
  seliteml2[0] = NULL;
  
  for(i = 0 ; (i < MAXITEMS) && (itemsList[i].formatstr != NULL) ;i++){
    if(itemsList[i].selected){
      seliteml2[anzitemlist2]=itemsList[i].name;
      selectedShowItems[anzitemlist2]=i;
      anzitemlist2++;
    }else{
      seliteml1[anzitemlist1]=itemsList[i].name;
      notselectedShowItems[anzitemlist1]=i;
      anzitemlist1++;
    }
  }
  notselectedShowItems[anzitemlist1]=-1;
  selectedShowItems[anzitemlist2]=-1;
  seliteml1[anzitemlist1]=NULL;
  seliteml2[anzitemlist2]=NULL;
  return;
}
/*****************************************************************************
  FUNCTION : ui_displaySelectHostPanelItems

  PURPOSE  : popup the SelectHostPanelItems
  RETURNS  : void
  NOTES    :

  UPDATE   : 16.02.94
******************************************************************************/
void
ui_displaySelectHostPanelItems(Widget w, Widget button, caddr_t call_data)
{
  Arg             args[20];
  Position        x, y;
  Dimension       width, height;
  Cardinal        n;
  Widget          form,tbutton,label,viewport1,viewport2;
  static bool     firsttime = TRUE;
  
  if (ui_RPCselectHostPanelItemsIsCreated)
    return;
  ui_RPCselectHostPanelItemsIsCreated = TRUE;
  
  
  /* init datas */
  aktselitem1=0;
  aktselitem2=0;
  if(firsttime){
    selectedShowItems[0]=-1;
    notselectedShowItems[0]=-1;
    ui_RPC_createItemsLists();
    firsttime = FALSE;
  }else{
    ui_RPC_createOrderdItemsLists();
  }
  /* Upper left corner will be in the center of the calling button */
  
  n = 0;
  XtSetArg(args[0], XtNwidth, &width);n++;
  XtSetArg(args[1], XtNheight, &height);n++;
  XtGetValues(button, args, n);
  
  XtTranslateCoords(button, (Position) 0, (Position) (height), &x, &y);
  
  n = 0;
  XtSetArg(args[n], XtNx, x); n++;
  XtSetArg(args[n], XtNy, y); n++;
  
  /* Now create Popup */
  
  ui_popRPCselItem = 
    XtCreatePopupShell("RPC SELECT ITEMSLIST", transientShellWidgetClass, 
		       ui_toplevel, args, n);
  
  n = 0;
  XtSetArg(args[n], XtNresizable, TRUE);n++;
  form = XtCreateManagedWidget("RPCselectform",formWidgetClass,
			       ui_popRPCselItem,args, n);
  
  
  
  label = ui_xCreateLabelItem("Select Info to show in the RPC PANEL",form,300,NULL,NULL);
  
  label = ui_xCreateLabelItem("INFO                          SELECTED", form, 370 , NULL, label);
  n = 0;
  XtSetArg(args[n], XtNwidth, 150);n++;
  XtSetArg(args[n], XtNheight, 16 * 9);n++;
  XtSetArg(args[n], XtNresizable, FALSE);n++;
  XtSetArg(args[n], XtNleft, XtChainLeft);n++;
  XtSetArg(args[n], XtNallowHoriz, FALSE);n++;
  XtSetArg(args[n], XtNallowVert, TRUE);n++;
  XtSetArg(args[n], XtNuseBottom, TRUE);n++;
  XtSetArg(args[n], XtNforceBars, TRUE);n++;
  XtSetArg(args[n], XtNfromVert, label);n++;
  XtSetArg(args[n], XtNright, XtChainRight);n++;
  XtSetArg(args[n], XtNtop, XtChainTop);n++;
  XtSetArg(args[n], XtNbottom, XtChainBottom);n++;
  
  viewport1 = XtCreateManagedWidget("Viewport", viewportWidgetClass,
				    form, args, n);
  n = 0;
  XtSetArg(args[n], XtNresizable, TRUE);n++;
  XtSetArg(args[n], XtNforceColumns, TRUE);n++;
  XtSetArg(args[n], XtNdefaultColumns, 1);n++;
  XtSetArg(args[n], XtNverticalList, FALSE);n++;
    
  RPCselItemsL1 = XtCreateManagedWidget("ListWin1",listWidgetClass,
					viewport1,args,n);
  XtAddCallback(RPCselItemsL1, XtNcallback, 
		(XtCallbackProc) ui_RPCselItemCallback,(caddr_t) 1);
  XawListChange(RPCselItemsL1, seliteml1, 0, 0, True);
    
  tbutton = ui_xCreateButtonItem("right2",form, viewport1,NULL);
  XtAddCallback(tbutton, XtNcallback, 
		(XtCallbackProc) ui_RPCmoveItemRightCallback, (caddr_t)NULL);
  n = 0;
  XtSetArg(args[n], XtNvertDistance, 90);n++;
  XtSetValues(tbutton,args,n);
    
  tbutton = ui_xCreateButtonItem("left2",form, viewport1,tbutton);
  XtAddCallback(tbutton, XtNcallback, 
		(XtCallbackProc) ui_RPCmoveItemLeftCallback, (caddr_t) NULL);
  n = 0;
  XtSetArg(args[n], XtNwidth, 150);n++;
  XtSetArg(args[n], XtNheight, 16 * 9);n++;
  XtSetArg(args[n], XtNresizable, FALSE);n++;
  XtSetArg(args[n], XtNfromVert, label);n++;
  XtSetArg(args[n], XtNleft, XtChainLeft);n++;
  XtSetArg(args[n], XtNallowHoriz, FALSE);n++;
  XtSetArg(args[n], XtNallowVert, TRUE);n++;
  XtSetArg(args[n], XtNuseBottom, TRUE);n++;
  XtSetArg(args[n], XtNforceBars, TRUE);n++;
  XtSetArg(args[n], XtNfromHoriz, tbutton);n++;
  XtSetArg(args[n], XtNright, XtChainRight);n++;
  XtSetArg(args[n], XtNtop, XtChainTop);n++;
  XtSetArg(args[n], XtNbottom, XtChainBottom);n++;
    
  viewport2 = XtCreateManagedWidget("Viewport2", viewportWidgetClass,
				    form, args, n);
    
  n = 0;
  XtSetArg(args[n], XtNresizable, TRUE);n++;
  XtSetArg(args[n], XtNforceColumns, TRUE);n++;
  XtSetArg(args[n], XtNdefaultColumns, 1);n++;
  XtSetArg(args[n], XtNverticalList, FALSE);n++;
    
  RPCselItemsL2 = XtCreateManagedWidget("ListWin2",listWidgetClass,
					viewport2,args,n);
  XtAddCallback(RPCselItemsL2, XtNcallback, 
		(XtCallbackProc) ui_RPCselItemCallback,(caddr_t) 2);
  XawListChange(RPCselItemsL2, seliteml2, 0, 0, True);
    
  tbutton = ui_xCreateButtonItem("done",form, NULL, viewport1);
  XtAddCallback(tbutton, XtNcallback, 
		(XtCallbackProc) ui_RPCselItemCloseCallback, (caddr_t) NULL);
  tbutton = ui_xCreateButtonItem("up in list", form, tbutton, viewport1);
  XtAddCallback(tbutton, XtNcallback, 
		(XtCallbackProc) ui_RPCmoveItemUpCallback, (caddr_t) NULL);
  n = 0;
  XtSetArg(args[n], XtNhorizDistance, 175);n++;
  XtSetValues(tbutton,args,n);

  tbutton = ui_xCreateButtonItem("down in list",form, tbutton, viewport1);
  XtAddCallback(tbutton, XtNcallback, 
		(XtCallbackProc) ui_RPCmoveItemDownCallback,(caddr_t) NULL);

  ui_checkWindowPosition(ui_popRPCselItem);
  XtPopup(ui_popRPCselItem, XtGrabNone);
  ui_xDontResizeWidget(ui_popRPCselItem); 
     
}


#endif

/* End of File */

