//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

#ifndef BASICTERMINAL_HXX
#define BASICTERMINAL_HXX

class TIA;

#include "machine.hxx"

#define TERMINAL_NUMBER_OF_EVENTS 28

/**
  Abstract base class that defines the standard API for the 
  terminal displays.

  @author  Bradford W. Mott
  @version $Id: BasTerm.hxx,v 1.2 1997/05/17 19:00:02 bwmott Exp $
*/
class BasicTerminal
{
  public:
    /// Event enumeration
    enum Event 
    {
      LeftJoystickUp, LeftJoystickDown, LeftJoystickLeft, LeftJoystickRight,
      RightJoystickUp, RightJoystickDown, RightJoystickLeft, RightJoystickRight,
      LeftJoystickFire, RightJoystickFire,
      LeftDifficultyA, LeftDifficultyB,
      RightDifficultyA, RightDifficultyB,
      PaddleZeroPosition, PaddleZeroFire,
      PaddleOnePosition, PaddleOneFire,
      PaddleTwoPosition, PaddleTwoFire,
      PaddleThreePosition, PaddleThreeFire,
      Color, BlackAndWhite, Select, Reset,
      Pause, Quit
    };

  public:
    /// Constructor
    BasicTerminal();
 
    /// Destructor
    virtual ~BasicTerminal();

  public: 
    /// Update the screen with the TIA frame
    virtual void update(TIA& tia) = 0;

    /// Answer the state of the given event
    virtual uLong eventState(Event event) = 0;
};
#endif

