//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

#ifndef CARTRIDGEAR_HXX
#define CARTRIDGEAR_HXX

class CartridgeAR;

#include "machine.hxx"
#include "Cart.hxx"

/**
  This is the cartridge class for Arcadia (aka Starpath) Supercharger 
  games.  Christopher Salomon provided most of the details and code 
  used for this class.

  The Supercharger has four 2K banks.  There are three banks of RAM 
  and one bank of ROM.  All 6K of the RAM can be read and written.

  @author  Bradford W. Mott
  @version $Id: CartAR.hxx,v 1.1 1997/05/17 19:04:12 bwmott Exp $
*/
class CartridgeAR : public Cartridge
{
  public:
    /// Constructor
    CartridgeAR(System& system, uByte* image, uLong size);
 
    /// Destructor
    virtual ~CartridgeAR();

    /// Answer the byte at the given address
    virtual uByte peek(uWord addr);

    /// Reset to power on state
    virtual void reset();

  private:
    // Handle a change to the bank configuration
    void bankConfiguration(uByte configuration);

    // Handle setting the current image from the load images
    void setupCurrentImage(uByte load);

    // Sets up a "dummy" bootstrap ROM in the ROM bank of the cartridge
    void setupROM();
     
  private:
    // Addressing offset in ROM image
    uWord myImageOffset[2];

    // Current 8k ROM Image of the cartridge
    uByte myImage[8192];

    // 256 byte header of the cartridge
    uByte myHeader[256];

    // All of the load images of the cartridge (needed for multiloads)
    uByte *myLoadImages;

    // Indicates how many 8K loads images there are
    uByte myNumberOfLoadImages;

    // Indicates if the RAM is write enabled
    bool myWriteEnabled;

    // Indicates if the ROM's power is on or off
    bool myPower;

    // Indicates when the power was last turned on
    uLong myPowerRomCycle;
};
#endif

