//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

#ifndef CARTRIDGEF8_HXX
#define CARTRIDGEF8_HXX

class CartridgeF8;

#include "machine.hxx"
#include "Cart.hxx"

/**
  The 8K cartridge class used by Atari (and most others).  There
  are 2 4K banks.

  @author  Bradford W. Mott
  @version $Id: CartF8.hxx,v 1.2 1997/05/17 19:00:04 bwmott Exp $
*/
class CartridgeF8 : public Cartridge
{
  public:
    /// Constructor
    CartridgeF8(System& system, uByte* image);
 
    /// Destructor
    virtual ~CartridgeF8();

    /// Answer the byte at the given address
    virtual uByte peek(uWord addr);

    /// Store value in the given address
    virtual void poke(uWord addr, uByte value);

    /// Reset to power on state
    virtual void reset();
 
  private:
    // Addressing offset in ROM image
    uWord myImageOffset;

    // 8k ROM Image of the cartridge
    uByte myImage[8192];
};
#endif

