//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

#ifndef PADDLE_HXX
#define PADDLE_HXX

#include "machine.hxx"
#include "Control.hxx"

/**
  The 2600's paddle controller

  @author  Bradford W. Mott
  @version $Id: Paddle.hxx,v 1.2 1997/05/17 19:00:06 bwmott Exp $
*/
class Paddle : public Controller
{
  public:
    /// Enumeration of the physical ports a paddle can be plugged in
    enum PhysicalPort { None, Zero, One, Two, Three };

  public:
    /// Constructor
    Paddle(const System& system, PhysicalPort PaddleZeroPort,
        PhysicalPort PaddleOnePort);
 
    /// Destructor
    virtual ~Paddle();

  public: 
    /// Invoked before each frame is generated
    virtual void update();

  public:
    /// Read the TIA information from the controller
    virtual uByte readTIA() const;

    /// Configure the TIA portion of the controller
    virtual void configureTIA(TIACommand command);

  private:
    PhysicalPort myPaddleZeroPort;
    PhysicalPort myPaddleOnePort;
    bool myDumping;
    uLong myBitZeroTimer;
    uLong myBitOneTimer;
};
#endif

