//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

/**
  Program to compute the Cartridge ID for a ROM image.

  @author  Bradford W. Mott
  @version $Id: id.cxx,v 1.1 1997/05/17 19:08:10 bwmott Exp $
*/

#include <stdio.h>
#include <fstream.h>

main(int argc, char* argv[])
{
  ifstream in;
  in.open(argv[1], ios::in | ios::nocreate);

  if(in.fail())
  {
    cerr << "Couldn't open " << argv[1] << endl;
    exit(1);
  } 

  // Read ROM from the input stream and see how big it is
  unsigned char rom[32768];
  in.read(rom, 32768);

  // Calculate Cartridge ID
  unsigned long cartId = 0;
  for(int i = 1024; i < 2048; i++)
  {
    cartId += (((unsigned long)rom[i]) << ((i & 0x0003) * 8));
  }

  printf("%08x\n", cartId);
}

