/********************************************************************************
 * Copyright (c) Erik Kunze 1995, 1996, 1997
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#ifndef _XZX_LOADSAVE_H
#define _XZX_LOADSAVE_H
/* $Id: loadsave.h,v 3.5 1997/09/16 19:43:43 erik Rel $ */
#include <stdio.h>
#include "z80.h"


#define LOAD_ADDR		0x0556
#define SAVE_ADDR		0x04C2
#define LOAD_ADDR_3		0x0556
#define SAVE_ADDR_3		0x04C6
#define LOAD_BPT_BYTE	0x14
#define SAVE_BPT_BYTE	0x21
#define LOAD_BPT		0xfc
#define SAVE_BPT		0xfd

#define TO_READ			0x01
#define TO_WRITE		0x02
#define TO_TAP			0x04
#define TO_VOC			0x08

#define TS_TRAPLOAD		0x0001
#define TS_TRAPSAVE		0x0002
#define TS_ERRIN		0x0004
#define TS_ERROUT		0x0008
#define TS_PLAY			0x0010
#define TS_TAPIN		0x0100
#define TS_VOCIN		0x0200
#define TS_TZXIN		0x0400
#define TS_TAPOUT		0x1000

extern void SetLoadSaveTraps(void);
extern void Loader(void);
extern void Saver(void);
extern int InsertTape(char *, int);
extern char *GetTapeName(int);
extern void StartTapePlayer(void);
extern void StopTapePlayer(void);
extern unsigned short TapeState;
extern FILE *TapeIn;
extern uns8 (*GetNextTapeBit)(void);
extern void (*BrowseTape)(void);
#endif

