/********************************************************************************
 * Copyright (c) Des Herriott 1993, 1994
 *               Erik Kunze   1995, 1996, 1997
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Des Herriott
 *         Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#ifndef _XZX_MEM_H
#define _XZX_MEM_H
/* $Id: mem.h,v 3.8 1997/09/13 16:01:43 erik Rel $ */
#include "z80.h"
#ifdef XZX_MF128
#include "resource.h"
#endif
#include "io.h"
#ifdef EMULATE_ULA_DELAY
#include "emul.h"
#endif
#include "screen.h"

#if !defined(__GNUC__)
#define inline
#endif

#define XZX_PAGESIZE 16384
enum {
	ROM0, ROM1,
#ifdef XZX_PLUS3
	ROM2, ROM3,
#endif
#ifdef XZX_IF1
	IF1ROM,
#endif
#ifdef XZX_MF128
	MF128ROM,
#endif
	RAM0, RAM1, RAM2, RAM3, RAM4, RAM5, RAM6, RAM7,
	NPAGES
};

#define VPAGE(addr)		((addr) >> 14)
#define RPAGE(addr)		(RealPageNumbers[VPAGE(addr)])
#define MEM(addr)		(TheMemory[VPAGE(addr)][(addr) & 0x3fff])
#define READ_ONLY(addr)	(RPAGE(addr) < RAM0)
#ifdef XZX_PLUS3
#define GET_BASIC_ROM(machine) \
						(machine == 48 ? ROM0 : (machine == 128 ? ROM1 : ROM3))
#else
#define GET_BASIC_ROM(machine) \
						(machine == 48 ? ROM0 : ROM1)
#endif

extern void MemoryInit(void);
extern void InitPages(void);
extern void PageIn(int, int);
extern int ReadROMs(void);
extern int SelectModel(int, int);
extern uns8 *TheMemory[4];
extern int RealPageNumbers[4];
extern uns8 *RealMemory[NPAGES];

static inline uns8
RD_BYTE(uns16 addr)
{
	return MEM(addr);
}

static inline uns16
RD_WORD(uns16 addr)
{
	return ((MEM(addr)) + (MEM((uns16)(addr + 1)) << 8));
}

static inline void
WR_BYTE(uns16 addr, uns8 val)
{
	if (READ_ONLY(addr))
	{
#ifdef XZX_MF128

		if (RPAGE(addr) != MF128ROM || addr < 8192)
#endif
		{
			return;
		}
	}
	MEM(addr) = val;
	if (RPAGE(addr) == ScreenSelect)
	{
		if ((addr &= 0x3fff) < (uns16)PIXEL_LENGTH)
		{
			ScreenWrite(addr, val);
		}
		else if (addr < (uns16)(PIXEL_LENGTH + ATTR_LENGTH))
		{
			AttrWrite(addr, val);
		}
#ifdef EMULATE_ULA_DELAY
		if (Vline >= TOP_BORDER
			&& Vline < (TOP_BORDER + SCR_LINES)
			&& Tstates < 128)
		{
			Tstates += 4;
		}
#endif
	}
}

static inline void
WR_WORD(uns16 addr, uns16 val)
{
	WR_BYTE(addr, LOWBYTE(val));
	WR_BYTE((uns16)(addr + 1), HIGHBYTE(val));
}
#endif

