/********************************************************************************
 * Copyright (c) Des Herriott 1993, 1994
 *               Erik Kunze   1995, 1996, 1997
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Des Herriott
 *         Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#ifndef lint
static char z80_edops_c[] = "$Id: z80_edops.c,v 3.7 1997/10/31 20:54:15 erik Rel $";
#endif


case 0x40:
	Tstates += 12;
	IN(BC, B);
	break;

case 0x41:
	Tstates += 12;
	OutByte(BC, B);
	break;

case 0x42:
	Tstates += 15;
	SBC_HL(BC);
	break;

case 0x43:
	Tstates += 20;
	WR_WORD(RD_WORD(PC), BC);
	PC += 2;
	break;

case 0x44:
case 0x4c:
case 0x54:
case 0x5c:
case 0x64:
case 0x6c:
case 0x74:
case 0x7c:
	Tstates += 8;
	work8 = A;
	A = 0;
	SUB(work8);
	break;

case 0x45:
case 0x55:
case 0x5d:
case 0x65:
case 0x6d:
case 0x75:
case 0x7d:
	Tstates += 14;
	POP(PC);
	IFF1 = IFF2;
	break;


case 0x46:
case 0x4e:
case 0x66:
case 0x6e:
	Tstates += 8;
	IM = 0;
	break;

case 0x47:
	Tstates += 9;
	I = A;
	break;

case 0x48:
	Tstates += 12;
	IN(BC, C);
	break;

case 0x49:
	Tstates += 12;
	OutByte(BC, C);
	break;

case 0x4A:
	Tstates += 15;
	ADC_HL(BC);
	break;

case 0x4B:
	Tstates += 20;
	BC = RD_WORD(RD_WORD(PC));
	PC += 2;
	break;

case 0x4D:
	Tstates += 14;
	POP(PC);

	break;

case 0x4F:
	Tstates += 9;
	R = A;
	break;

case 0x50:
	Tstates += 12;
	IN(BC, D);
	break;

case 0x51:
	Tstates += 12;
	OutByte(BC, D);
	break;

case 0x52:
	Tstates += 15;
	SBC_HL(DE);
	break;

case 0x53:
	Tstates += 20;
	WR_WORD(RD_WORD(PC), DE);
	PC += 2;
	break;

case 0x56:
case 0x76:
	Tstates += 8;
	IM = 1;
	break;

case 0x57:
	Tstates += 9;
	A = I;
	F = (F & C_FLAG) | SZ53(A) | (IFF2 ? P_FLAG : 0);
	break;

case 0x58:
	Tstates += 12;
	IN(BC, E);
	break;

case 0x59:
	Tstates += 12;
	OutByte(BC, E);
	break;

case 0x5A:
	Tstates += 15;
	ADC_HL(DE);
	break;

case 0x5B:
	Tstates += 20;
	DE = RD_WORD(RD_WORD(PC));
	PC += 2;
	break;

case 0x5E:
case 0x7e:
	Tstates += 8;
	IM = 2;
	break;

case 0x5F:
	Tstates += 9;
	A = R;
	F = (F & C_FLAG) | SZ53(A) | (IFF2 ? P_FLAG : 0);
	break;

case 0x60:
	Tstates += 12;
	IN(BC, H);
	break;

case 0x61:
	Tstates += 12;
	OutByte(BC, H);
	break;

case 0x62:
	Tstates += 15;
	SBC_HL(HL);
	break;

case 0x63:
	Tstates += 20;
	WR_WORD(RD_WORD(PC), HL);
	PC += 2;
	break;

case 0x67:
	Tstates += 18;
	work8 = RD_BYTE(HL);
	WR_BYTE(HL, (work8 >> 4) | (A << 4));
	A = (A & 0xf0) | (work8 & 0x0f);
	F = (F & C_FLAG) | SZ53P(A);
	break;

case 0x68:
	Tstates += 12;
	IN(BC, L);
	break;

case 0x69:
	Tstates += 12;
	OutByte(BC, L);
	break;

case 0x6A:
	Tstates += 15;
	ADC_HL(HL);
	break;

case 0x6B:
	Tstates += 20;
	HL = RD_WORD(RD_WORD(PC));
	PC += 2;
	break;

case 0x6F:
	Tstates += 18;
	work8 = RD_BYTE(HL);
	WR_BYTE(HL, (work8 << 4) | (A & 0x0f));
	A = (A & 0xf0) | (work8 >> 4);
	F = (F & C_FLAG) | SZ53P(A);
	break;


case 0x70:
	Tstates += 12;
	IN(BC, work8);
	break;

case 0x71:
	Tstates += 12;
	OutByte(BC, 0);
	break;

case 0x72:
	Tstates += 15;
	SBC_HL(SP);
	break;

case 0x73:
	Tstates += 20;
	WR_WORD(RD_WORD(PC), SP);
	PC += 2;
	break;

case 0x77:
case 0x7f:
	Tstates += 8;
	break;

case 0x78:
	Tstates += 12;
	IN(BC, A);
	break;

case 0x79:
	Tstates += 12;
	OutByte(BC, A);
	break;

case 0x7A:
	Tstates += 15;
	ADC_HL(SP);
	break;

case 0x7B:
	Tstates += 20;
	SP = RD_WORD(RD_WORD(PC));
	PC += 2;
	break;

case 0xA0:
	Tstates += 16;
	WR_BYTE(DE, RD_BYTE(HL));
	DE++; HL++; BC--;
	F = (F & ~(H_FLAG | V_FLAG | N_FLAG)) | (BC ? V_FLAG : 0);
	break;

case 0xA1:
	Tstates += 16;
	work8 = RD_BYTE(HL);
	_CMP_(work8);
	HL++; BC--;
	F |= BC ? V_FLAG : 0;
	break;

case 0xA2:
	Tstates += 16;
	IN(BC, work8);
	WR_BYTE(HL, work8);
	B--; HL++;
	F = (F & ~Z_FLAG) | (B ? N_FLAG : Z_FLAG | N_FLAG);
	break;

case 0xA3:
	Tstates += 16;
	B--;
	OutByte(BC, RD_BYTE(HL));
	HL++;
	F = (F & ~Z_FLAG) | (B ? N_FLAG : Z_FLAG | N_FLAG);
	break;

case 0xA8:
	Tstates += 16;
	WR_BYTE(DE, RD_BYTE(HL));
	DE--; HL--; BC--;
	F = (F & ~(H_FLAG | V_FLAG | N_FLAG)) | (BC ? V_FLAG : 0);
	break;

case 0xA9:
	Tstates += 16;
	work8 = RD_BYTE(HL);
	_CMP_(work8);
	HL--; BC--;
	F |= BC ? V_FLAG : 0;
	break;

case 0xAA:
	Tstates += 16;
	IN(BC, work8);
	WR_BYTE(HL, work8);
	B--; HL--;
	F = (F & ~Z_FLAG) | (B ? N_FLAG : Z_FLAG | N_FLAG);
	break;

case 0xAB:
	Tstates += 16;
	B--;
	OutByte(BC, RD_BYTE(HL));
	HL--;
	F = (F & ~Z_FLAG) | (B ? N_FLAG : Z_FLAG | N_FLAG);
	break;

case 0xB0:
	Tstates += 16;
	WR_BYTE(DE, RD_BYTE(HL));
	HL++; DE++; BC--;
	F = (F & ~(H_FLAG | V_FLAG | N_FLAG)) | (BC ? V_FLAG : 0);
	if (BC)
	{
		Tstates += 5;
		PC -= 2;
	}
	break;

case 0xB1:
	Tstates += 16;
	work8 = RD_BYTE(HL);
	_CMP_(work8);
	HL++; BC--;
	F |= BC ? V_FLAG : 0;
	if ((F & (Z_FLAG | V_FLAG)) == V_FLAG)
	{
		Tstates += 5;
		PC -= 2;
	}
	break;

case 0xB2:
	Tstates += 16;
	IN(BC, work8);
	WR_BYTE(HL, work8);
	B--; HL++;
	F = (F & ~Z_FLAG) | (B ? N_FLAG : Z_FLAG | N_FLAG);
	if (B)
	{
		Tstates += 5;
		PC -= 2;
	}
	break;

case 0xB3:
	Tstates += 16;
	B--;
	OutByte(BC, RD_BYTE(HL));
	HL++;
	F = (F & ~Z_FLAG) | (B ? 0 : Z_FLAG) | N_FLAG;
	if (B)
	{
		Tstates += 5;
		PC -= 2;
	}
	break;

case 0xB8:
	Tstates += 16;
	WR_BYTE(DE, RD_BYTE(HL));
	HL--; DE--; BC--;
	F = (F & ~(H_FLAG | V_FLAG | N_FLAG)) | (BC ? V_FLAG : 0);
	if (BC)
	{
		Tstates += 5;
		PC -= 2;
	}
	break;

case 0xB9:
	Tstates += 16;
	work8 = RD_BYTE(HL);
	_CMP_(work8);
	HL--; BC--;
	F |= BC ? V_FLAG : 0;
	if ((F & (Z_FLAG | V_FLAG)) == V_FLAG)
	{
		Tstates += 5;
		PC -= 2;
	}
	break;

case 0xBA:
	Tstates += 16;
	IN(BC, work8);
	WR_BYTE(HL, work8);
	B--; HL--;
	F = (F & ~Z_FLAG) | (B ? N_FLAG : Z_FLAG | N_FLAG);
	if (B)
	{
		Tstates += 5;
		PC -= 2;
	}
	break;

case 0xBB:
	Tstates += 16;
	B--;
	OutByte(BC, RD_BYTE(HL));
	HL--;
	F = (F & ~Z_FLAG) | (B ? N_FLAG : Z_FLAG | N_FLAG);
	if (B)
	{
		Tstates += 5;
		PC -= 2;
	}
	break;


case 0x00:
	Tstates += 8;
	Debugger(DBG_BREAKPOINT);
	break;
#ifdef XBELL_AUDIO

case BELL_BPT:
	Tstates += 8;
	if (GETCFG(volume))
	{
		int f, t;
		f = 1750000 / ((HL + 30) << 2);
		t = (1000 * DE) / f;
		RingBell(f, (int)t);
	}
	break;
#endif

case 0xFB:
	Tstates += 8;
	LevelLoaderTrap();
	break;
case LOAD_BPT:
	Tstates += 8;
	Loader();
	break;
case SAVE_BPT:
	Tstates += 8;
	Saver();
	break;
#ifdef XZX_IF1

case RS232_IP_BPT:
	Tstates += 8;
	RS232IpTrap();
	break;
case RS232_OP_BPT:
	Tstates += 8;
	RS232OpTrap();
	break;
#endif

default:
	Tstates += 8;
#ifdef DEBUG
	if (GETCFG(debug) & D_ILLOPS)
	{
		Msg(M_DEBUG, "unimplemented instruction %02x %02x at %04x",
			RD_BYTE(PC - 2), RD_BYTE(PC - 1), PC -2);
	}
#endif
	break;

