;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                       ;;
;;;                Centre for Speech Technology Research                  ;;
;;;                     University of Edinburgh, UK                       ;;
;;;                       Copyright (c) 1996,1997                         ;;
;;;                        All Rights Reserved.                           ;;
;;;                                                                       ;;
;;;  Permission to use, copy, modify, distribute this software and its    ;;
;;;  documentation for research, educational and individual use only, is  ;;
;;;  hereby granted without fee, subject to the following conditions:     ;;
;;;   1. The code must retain the above copyright notice, this list of    ;;
;;;      conditions and the following disclaimer.                         ;;
;;;   2. Any modifications must be clearly marked as such.                ;;
;;;   3. Original authors' names are not deleted.                         ;;
;;;  This software may not be used for commercial purposes without        ;;
;;;  specific prior written permission from the authors.                  ;;
;;;                                                                       ;;
;;;  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        ;;
;;;  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      ;;
;;;  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   ;;
;;;  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     ;;
;;;  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    ;;
;;;  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   ;;
;;;  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          ;;
;;;  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       ;;
;;;  THIS SOFTWARE.                                                       ;;
;;;                                                                       ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  Predicting pause insertion

(define (Pauses utt)
  "(Pauses UTT)
Predict pause insertion."
  (mapcar
   (lambda (w)
     (let ((pbreak (utt.streamitem.feat utt w "pbreak"))
	   (emph (utt.streamitem.feat utt w "Token.EMPH")))
       (cond
	((or (string-equal "B" pbreak)
	     (string-equal "BB" pbreak))
	 (insert_pause utt w))
	((not (string-equal 
	       (utt.streamitem.feat utt w "Token.Phrase.addr")
	       (utt.streamitem.feat utt w "n.Token.Phrase.addr")))
	 (if (string-matches (utt.streamitem.feat utt w "Token.Phrase.name")
			     "BB?")
	     (begin
	       (w.set_feature w "pbreak" 
			      (utt.streamitem.feat utt w "Token.Phrase.name"))
	       (insert_pause utt w))))
	((string-equal emph "1")
	 (insert_pause utt w))
	((null (streamitem.next w))
	 (insert_pause utt w)))))
   (utt.stream utt 'Word))
  ;; The embarassing bit.  Remove any words labelled as punc or fpunc
  (mapcar
   (lambda (w)
     (let ((pos (utt.streamitem.feat utt w "pos")))
       (if (or (string-equal "punc" pos)
	       (string-equal "fpunc" pos))
	   (let ((pbreak (utt.streamitem.feat utt w "pbreak")))
	     (if (and (string-matches pbreak "BB?")
		      (streamitem.prev w))
		 (streamitem.set_feat (streamitem.prev w) "pbreak" pbreak))
	     (utt.streamitem.delete utt w)))))
   (utt.stream utt 'Word))
  utt)

(define (insert_pause utt word)
"(insert_pause UTT WORDITEM)
Insert a silence segment after the last segment in WORDITEM in UTT."
  (let ((lastseg (find_last_seg utt word))
	(silence (car (car (cdr (assoc 'silences (PhoneSet.description)))))))
    (if lastseg
	(begin
	  (utt.streamitem.insert utt 'Segment lastseg)
	  (streamitem.set_name (streamitem.next lastseg) silence)))))

(define (find_last_seg utt word)
;;; Find the segment that is immediately at this end of this word
;;; If this word is punctuation it might not have any segments
;;; so we have to check back until we find a word with a segment in it
  (cond
   ((null word)
    nil)  ;; there are no segs (don't think this can happen)
   ((null (utt.streamitem.rel utt word 'Syllable))
    (find_last_seg utt (streamitem.prev word)))
   (t
    (car (last (utt.streamitem.rel 
		utt
		(car (last (utt.streamitem.rel utt word 'Syllable)))
		'Segment))))))

(provide 'pauses)
