 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /************************************************************************/
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)            */
 /*                   Date: Mon Mar 10 1997				 */
 /************************************************************************/
 /*                                                                      */
 /* Implementation of Units as abstract objects. This provides the       */
 /* infrastructure for the specific Unit types.                          */
 /*                                                                      */
 /************************************************************************/

#include "UnitDatabase.h"
#include "Unit.h"

EST_String SubtypedObject<Unit>::type_name(void) const {return "Unit";}

#if defined(INCLUDE_LISP)
int SubtypedObject<Unit>::s_lisp_type = tc_festival_unit;
#endif

Unit::Unit(void)
{
p_database = NULL; p_underlying=NULL;
}

Unit::~Unit(void)
{
  cwarn << "destroy Unit\n";
}

void Unit::associate_database(UnitDatabase *db)
{
  p_database = db;
}

int Unit::set_property(EST_String property, ValueType value)
{
  return SchemeObject::set_property(property, value);
}

int Unit::length(void)
{
  return -1;
}

EST_TVector<int> *Unit::segment_ends(void)
{
  return NULL;
}

Unit *Unit::derived_unit(void)
{
  Unit *d = create(subtype_name());

  d->p_underlying = this;

  d->p_name = name();
  d->p_properties = properties();
  d->p_database = database();

  return d;
}
  
#if defined(INCLUDE_LISP)

void Unit::lisp_print(LISP ptr, FILE *f)
{
  Unit *unit = (Unit *)PTRVAL(ptr);
  fput_st(f,"#<UNIT ");
  fput_st(f,unit->subtype_name());
  if (unit->database())
    {
      fput_st(f," ");
      fput_st(f, unit->database()->name());
    }
  fput_st(f," ");
  fput_st(f, unit->name());
  fput_st(f,">");
}

void Unit::lisp_print_string(LISP ptr, char *s)
{
  Unit *unit = (Unit *)PTRVAL(ptr);
  sprintf(s, "#<UNIT %s %s %s>", 
	  (const char *)unit->subtype_name(),
	  unit->database()?(const char *)unit->database()->name():"",
	  (const char *)unit->name()
	  );
}

void Unit::lisp_declare(void)
{
  long gc_kind;
  set_gc_hooks(tc_festival_unit,
	       1,
	       NULL,
	       SchemeObject::lisp_gc_mark,
	       NULL,
	       SchemeObject::lisp_gc_free,
	       SchemeObject::lisp_gc_clear_mark,
	       &gc_kind);
  set_print_hooks(tc_festival_unit,
		  Unit::lisp_print,
		  Unit::lisp_print_string
		  );

  init_subr_2("make_unit", Unit::lisp_make,
 "(make_unit TYPE NAME)\n\
  Make an empty unit of the given type and name.");

  
}
#endif

#if defined(INSTANTIATE_TEMPLATES)
#include "SubtypedObject.cc"
template class SubtypedObject<Unit>;
#endif
