 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /************************************************************************/
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)            */
 /*                   Date: Mon Mar 10 1997                              */
 /************************************************************************/
 /*                                                                      */
 /* Common interface to Unit indexes.                                    */
 /*                                                                      */
 /************************************************************************/

#include "UnitIndex.h"

EST_String  SubtypedObject<UnitIndex>::type_name(void) const {return "UnitIndex";}

#if defined(INCLUDE_LISP)
int  SubtypedObject<UnitIndex>::s_lisp_type = tc_festival_unitindex;
#endif

UnitIndex::UnitIndex(void)
{
  p_database=NULL;
}

UnitIndex::~UnitIndex(void)
{ }

EST_read_status UnitIndex::fill_from(FILE *stream, int binary) 
{(void)stream; (void)binary; return misc_read_error;}
EST_write_status UnitIndex::write_to(FILE *stream, int binary) 
{(void)stream; (void)binary; return misc_write_error;}

void UnitIndex::associate_database(UnitDatabase *db)
{
  p_database = db;
}

void UnitIndex::index(void)
{
}

int UnitIndex::set_property(EST_String property, ValueType value)
{
  return SchemeObject::set_property(property, value);
}

#if defined(INCLUDE_LISP)

void UnitIndex::lisp_print(LISP ptr, FILE *f)
{
  UnitIndex *unitindex = (UnitIndex *)PTRVAL(ptr);
  fput_st(f,"#<UNITINDEX ");
  fput_st(f, unitindex->subtype_name());
  if (unitindex->database())
    {
      fput_st(f," of '");
      fput_st(f, unitindex->database()->name());
      fput_st(f,"'");
    }
  fput_st(f,">");
}

void UnitIndex::lisp_print_string(LISP ptr, char *s)
{
  UnitIndex *unitindex = (UnitIndex *)PTRVAL(ptr);
  sprintf(s, "#<UNITINDEX %s of '%s'>",
	  (const char *)unitindex->subtype_name(),
	  unitindex->database()?(const char *)unitindex->database()->name():""
	  );
}

void UnitIndex::lisp_declare(void)
{
  long gc_kind;
  set_gc_hooks(tc_festival_unitindex,
	       1,
	       NULL,
	       SchemeObject::lisp_gc_mark,
	       NULL,
	       SchemeObject::lisp_gc_free,
	       SchemeObject::lisp_gc_clear_mark,
	       &gc_kind);
  set_print_hooks(tc_festival_unitindex,
		  UnitIndex::lisp_print,
		  UnitIndex::lisp_print_string
		  );

  init_subr_2("make_unitindex", UnitIndex::lisp_make,
 "(make_unitindex TYPE PROPERTIES)\n\
  Make an empty unitindex of the given type and properties.");
}
#endif

#if defined(INSTANTIATE_TEMPLATES)
#include "SubtypedObject.cc"
template class SubtypedObject<UnitIndex>;
#include "../base_class/EST_TVector.cc"
template class EST_TVector<UnitName>;
#include "../base_class/EST_TList.cc"
template class EST_TList<UnitName>;
template class EST_TItem<UnitName>;
#endif
