/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                       Copyright (c) 1996,1997                         */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                     Author :  Alan W Black                            */
/*                     Date   :  April 1996                              */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/*                   Festival Private functions                          */
/*                                                                       */
/*=======================================================================*/
#ifndef __FESTIVALP_H__
#define __FESTIVALP_H__

/* Set up LISP access functions for various subsystems */
void utterance_lisp_declare(void);
void festival_utt_wave_funcs(void);
void festival_phoneset_funcs(void);
void festival_feature_funcs(void);
void festival_tcl_init(void);

extern int audsp_mode;
extern ostream *cslog; 

LISP l_audio_mode(LISP mode);
void audsp_play_wave(EST_Wave *w);

LISP lisp_parse_url(LISP url);

LISP lisp_load_ngram(LISP name, LISP filename);
LISP lisp_build_ngram(LISP name, LISP filename, LISP params);
LISP lisp_test_ngram(LISP name, LISP filename, LISP params);
LISP lisp_save_ngram(LISP name, LISP filename, LISP type);
LISP lisp_smooth_ngram(LISP name, LISP count);

#endif /* __FESTIVALP_H__ */
