/* Scheme In One Defun, but in C this time.
 
 *                    COPYRIGHT (c) 1988-1994 BY                            *
 *        PARADIGM ASSOCIATES INCORPORATED, CAMBRIDGE, MASSACHUSETTS.       *
 *        See the source file SLIB.C for more information.                  *

*/

/*

gjc@paradigm.com or gjc@mitech.com or gjc@world.std.com

Paradigm Associates Inc          Phone: 617-492-6079
29 Putnam Ave, Suite 6
Cambridge, MA 02138

  */

/***************************************************************/
/* This has been modified to act as an interface to siod as an */
/* embedded Lisp module.                                       */
/* Also a (large) number of other functions have been added    */
/*                                                             */
/*    Alan W Black (awb@cstr.ed.ac.uk) 8th April 1996          */
/***************************************************************/
#include <stdio.h>
#include "EST_unix.h"
#include <stdlib.h>
#include <string.h>
#include "EST_String.h"
#include "EST_THash.h"
#include "EST_io_aux.h"
#include "EST_StringTrie.h"
#include "EST_cutils.h"
#include "EST_strcasecmp.h"
#include "siod.h"
#include "siodp.h"
#include "siodline.h"

static void siod_string_print(LISP exp, ostrstream &sd);
static int siod_server_socket = -1;

extern "C" char * repl_prompt;

#if defined(INSTANTIATE_TEMPLATES)
#include "../base_class/EST_THash.cc"
template class EST_TStringHash<EST_Regex *>;
template class EST_THash<EST_String,EST_Regex *>;
template class EST_Hash_Pair<EST_String,EST_Regex *>;
#endif
EST_Regex *EST_THash<EST_String,EST_Regex *>::Dummy_Value = 0;

static EST_TStringHash<EST_Regex *> regexes(100);

int siod_init(int heap_size)
{
    /* Initialize siod */

    init_storage(heap_size);
    init_subrs();
    init_trace();

    return 0;
}

int siod_repl(int interactive)
{
    int retval;
    LISP histsize;

    repl_prompt = festival_primary_prompt;
    /* Set history size (ignored if no readline included */
    histsize = siod_get_lval("readline_histsize",NULL);
    if (histsize != NIL)
	readline_histsize = get_c_long(histsize);

    siod_interactive = interactive;
    siod_rl_init();
    retval = repl_driver(1,0,NULL);
    if (interactive)
	cout << endl;

    return retval;
}

LISP siod_send_lisp_to_client(LISP x)
{
    // Send x to the client
    if (siod_server_socket == -1)
    {
	err("festival: not in server mode",x);
    }

    EST_String tmpfile = make_tmp_filename();
    FILE *fd;
    char *m = siod_sprint(x);

    if ((fd=fopen(tmpfile,"wb")) == NULL)
    {
	cerr << "festival: can't open temporary file \"" << 
	    tmpfile << "\" for client lisp return" << endl;
    }
    else
    {
	fwrite(m,sizeof(char),strlen(m),fd);
	fwrite("\n",1,1,fd);
	fclose(fd);
	write(siod_server_socket,"LP\n",3);
	socket_send_file(siod_server_socket,tmpfile);
	unlink(tmpfile);
    }
    wfree(m);

    return x;
}
    
static void acknowledge_sock_print(LISP x)
{   // simple return "OK" -- used in server socket mode

    siod_send_lisp_to_client(x);

    write(siod_server_socket,"OK\n",3);
}

static void ignore_puts(char *x)
{   
    (void)x;
}

long repl_from_socket(int fd)
{
    /* Read from given fd as stdin */
    struct repl_hooks hd;

    dup2(fd,0);                     // make socket into stdin
    // dup2(fd,1);                     // make socket into stdout
    hd.repl_puts = ignore_puts;
    hd.repl_print = acknowledge_sock_print;
    hd.repl_eval = NULL;
    hd.repl_read = NULL;
    siod_interactive = FALSE;
    siod_server_socket = fd;

    return repl_driver(1,0,&hd);
}

char *siod_docstring(char *symbol)
{
    // For siodline 
    LISP doc;

    doc = siod_doc(cons(intern(rintern(symbol)),NIL),NIL);

    return get_c_string(doc);
}

char *siod_manual_sym(char *symbol)
{
    // For siodline 
    LISP info;

    info = leval(cons(rintern("manual-sym"),
		      cons(siod_quote(rintern(symbol)),NIL)),NIL);

    return get_c_string(info);
}

void siod_saydocstring(char *symbol)
{
    // This isn't guaranteed to work but might be ok sometimes

    leval(cons(rintern("tts_text"),
	       cons(cons(rintern("doc"),cons(rintern(symbol),NIL)),
		    cons(NIL,NIL))),NIL);

}

LISP siod_get_lval(const char *name,const char *message)
{
    // returns value of variable name.  If not set gives an error 
    LISP iii, rval;
    int set;

    iii = rintern(name);

    // value or NIL if unset
    rval = symbol_value_p(iii, current_env, &set);

    if (!set && (message != NULL))
	err(message,iii);

    return rval;
}

LISP siod_set_lval(const char *name,LISP val)
{
    // set variable name to val
    LISP iii, rval;
    
    iii = rintern(name);

    rval = setvar(iii,val,current_env);

    return rval;
}

LISP siod_assoc_str(const char *key,LISP alist)
{
    // assoc without going through LISP atoms 
    // made get_c_string inline for optimization
    LISP l,lc,lcc;

    for (l=alist; CONSP(l); l=CDR(l))
    {
	lc = CAR(l);
	if (CONSP(lc))
	{
	    lcc = CAR(lc);
	    if (NULLP(lcc)) continue;
	    else if TYPEP(lcc,tc_symbol)
	    {
		if (strcmp(key,PNAME(lcc))==0)
		    return lc;
	    }
	    else if TYPEP(lcc,tc_flonum)
	    {
		if (FLONMPNAME(lcc) == NULL)
		{
		    char b[TKBUFFERN];
		    sprintf(b,"%g",FLONM(lcc));
		    FLONMPNAME(lcc) = (char *)must_malloc(strlen(b)+1);
		    sprintf(FLONMPNAME(lcc),"%s",b);
		}
		if (strcmp(key,FLONMPNAME(lcc))==0)
		    return lc;
	    }
	    else if TYPEP(lcc,tc_string)
	    {
		if (strcmp(key,lcc->storage_as.string.data)==0)
		    return lc;
	    }
	    else
		continue;
	}
    }
    return NIL;
}

LISP siod_member_str(const char *key,LISP list)
{
    // member without going through LISP atoms 
    LISP l;

    for (l=list; CONSP(l); l=CDR(l))
	if (strcmp(key,get_c_string(CAR(l))) == 0)
	    return l;

    return NIL;
}

LISP siod_regex_member_str(const EST_String &key,LISP list)
{
    // Check the regexs in LIST against key
    LISP l;

    for (l=list; CONSP(l); l=CDR(l))
	if (key.matches(make_regex(get_c_string(CAR(l)))))
	    return l;

    return NIL;
}

LISP siod_member_int(const int key,LISP list)
{
    // member without going through LISP atoms 
    LISP l;

    for (l=list; CONSP(l); l=CDR(l))
	if (key == get_c_long(CAR(l)))
	    return l;

    return NIL;
}
	 
int siod_llength(LISP list)
{
    // length of string;
    int len;
    LISP l;

    for (len=0,l=list; CONSP(l); l=CDR(l),len++);
	
    return len;

}

LISP siod_nth(int n,LISP list)
{
    // nth member -- first member is 0;
    int i;
    LISP l;

    for (i=0,l=list; CONSP(l); l=CDR(l),i++)
	if (i == n)
	    return car(l);
	
    return NIL;

}

int siod_atomic_list(LISP list)
{
    // TRUE is list only contains atoms
    LISP p;

    for (p=list; p != NIL; p=cdr(p))
	if (CONSP(car(p)))
	    return FALSE;

    return TRUE;
}

int siod_eof(LISP item)
{
    // TRUE if item is what siod denotes as eof
    if (CONSP(item) &&
	(cdr(item) == NIL) &&
	(SYMBOLP(car(item))) &&
	(strcmp("eof",get_c_string(car(item))) == 0))
	return TRUE;
    else
	return FALSE;
}

LISP siod_quote(LISP l)
{
    // Add quote round a Lisp expression
    return cons(rintern("quote"),cons(l,NIL));
}

LISP siod_last(LISP list)
{
    LISP l;

    if ((list == NIL) || (NCONSP(list)))
	return NIL;
    else
    {
	for (l=list; cdr(l) != NIL; l=cdr(l));
	return car(l);
    }
}

int get_param_int(const char *name, LISP params, int defval)
{
    // Look up name in params and return value if present or 
    // defval if not present 
    LISP pair;

    pair = siod_assoc_str(name,params);

    if (pair == NIL)
	return defval;
    else  if FLONUMP(car(cdr(pair)))
	return (int)FLONM(car(cdr(pair)));
    else
    {
	cerr << "wta for get param " << name << endl;
	err("",NIL);
	return -1;
    }

}

float get_param_float(const char *name, LISP params, float defval)
{
    // Look up name in params and return value if present or 
    // defval if not present 
    LISP pair;

    pair = siod_assoc_str(name,params);

    if (pair == NIL)
	return defval;
    else  if (FLONUMP(car(cdr(pair))))
	return (float)FLONM(car(cdr(pair)));
    else
    {
	cerr << "wta for get param " << name << endl;
	err("",NIL);
	return -1;
    }

}

char *get_param_str(const char *name, LISP params, const char *defval)
{
    // Look up name in params and return value if present or 
    // defval if not present -- gives a *copy* of the string
    LISP pair;

    pair = siod_assoc_str(name,params);

    if (pair == NIL)
	return wstrdup(defval);
    else
	return wstrdup(get_c_string(car(cdr(pair))));
}

LISP get_param_lisp(const char *name, LISP params, LISP defval)
{
    // Look up name in params and return value if present or 
    // defval if not present 
    LISP pair;

    pair = siod_assoc_str(name,params);

    if (pair == NIL)
	return defval;
    else
	return car(cdr(pair));
}

LISP make_param_str(const char *name,const char *val)
{
    return cons(rintern(name),cons(rintern(val),NIL));
}

LISP make_param_int(const char *name, int val)
{
    return cons(rintern(name),cons(flocons(val),NIL));
}

LISP make_param_float(const char *name, float val)
{
    return cons(rintern(name),cons(flocons(val),NIL));
}

LISP make_param_lisp(const char *name,LISP val)
{
    return cons(rintern(name),cons(val,NIL));
}

EST_Regex &make_regex(const char *r)
{
    // Return pointer to existing regex if its already been created
    // otherwise create a new one for this r.
    EST_Regex *rx;
    EST_String sr = r;
    int found;

    if ((rx = regexes.val(sr,found)) == 0)
    {
	EST_Regex *nr = new EST_Regex(r);
	regexes.add_item(sr,nr);
	rx = nr;
    }

    return *rx;
}

LISP l_matches(LISP atom, LISP regex)
{
    // t if printname of atom matches regex, nil otherwise
    EST_String pname = get_c_string(atom);

    if (pname.matches(make_regex(get_c_string(regex))) == TRUE)
	return truth;
    else
	return NIL;
}

LISP l_strequal(LISP atom1, LISP atom2)
{
    
    if (streq(get_c_string(atom1),get_c_string(atom2)))
	return truth;
    else
	return NIL;
}

LISP l_substring(LISP string, LISP l_start, LISP l_length)
{
    // As string might actually be a buffer containing nulls we
    // do this a little carefully.
    if (NTYPEP(string,tc_string))
	err("not a string",string);
	
    char *data = string->storage_as.string.data;
    int dim = string->storage_as.string.dim;

    int start = ( get_c_long(l_start) < dim ? get_c_long(l_start) : dim );
    int length = ( (get_c_long(l_length) + start) < dim ? 
		  get_c_long(l_length) : dim);
    char *nbuffer = walloc(char, length+1);
    memmove(nbuffer,data+start,length);
    nbuffer[length+1] = '\0';

    LISP ncell = string_cell(nbuffer, length);

    wfree(nbuffer);

    return ncell;
}

LISP l_sbefore(LISP atom, LISP before)
{
    // Wraparound for EST_String.before function 
    EST_String pname = get_c_string(atom);
    EST_String b = get_c_string(before);
    EST_String n = pname.before(b);
    
    return strintern(n);
}

LISP l_safter(LISP atom, LISP after)
{
    // Wraparound for EST_String.after function 
    EST_String pname = get_c_string(atom);
    EST_String a = get_c_string(after);
    EST_String n = pname.after(a);

    return strintern(n);
}

LISP apply_hooks(LISP hooks,LISP arg)
{
    //  Apply each function in hooks to arg returning value from 
    // final application (or arg itself)
    LISP h,r=arg;

    if (hooks == NIL)
	r = arg;
    else if (!CONSP(hooks))  // singleton
	r = leval(cons(hooks,cons(arg,NIL)),NIL);
    else
	for (h=hooks; h != NIL; h=cdr(h))
	    r = leval(cons(car(h),cons(arg,NIL)),NIL);
    return r;
}

LISP stringexplode(const char *str)
{
    // Explode character string into list of symbols one for each char
    LISP l=NIL;
    unsigned int i;
    char id[2];
    id[1] = '\0';

    for (i=0; i < strlen(str); i++)
    {
	id[0] = str[i];
	l = cons(rintern(id),l);
    }

    return reverse(l);
}

/* Readline completion functions */
    
char *siod_variable_generator(char *text,int state)
{
    static LISP l;
    char *name;

    if (state == 0)		/* first time */
	l = oblistvar;

    /* Return the next name which partially matches from the command list. */
    for(;CONSP(l);l=CDR(l))
    {
	if (VCELL(car(l)) == NIL) continue;
	switch(TYPE(VCELL(CAR(l))))
	{
	  case tc_subr_0:
	  case tc_subr_1:
	  case tc_subr_2:
	  case tc_subr_3:
	  case tc_lsubr:
	  case tc_fsubr:
	  case tc_msubr:
	  case tc_closure:
	    continue;
	  default:
            /* only return names of nonfunctions (sometimes too restrictive) */
	    name = PNAME(CAR(l));
	    if (strncmp(name, text, strlen(text)) == 0)
	    {
		l=CDR(l); /* move for next time */
		return wstrdup(name);
	    }
	}
    }

    return NULL;
}

char *siod_command_generator (char *text,int state)
{
    static LISP l;
    char *name;

    if (state == 0)		/* first time */
	l = oblistvar;

    /* Return the next name which partially matches from the command list. */
    for(;CONSP(l);l=CDR(l))
    {
	if (VCELL(car(l)) == NIL) continue;
	switch(TYPE(VCELL(CAR(l))))
	{
	  case tc_subr_0:
	  case tc_subr_1:
	  case tc_subr_2:
	  case tc_subr_3:
	  case tc_lsubr:
	  case tc_fsubr:
	  case tc_msubr:
	  case tc_closure:
            /* only return names of functions */
	    name = PNAME(CAR(l));
	    if (strncmp(name, text, strlen(text)) == 0)
	    {
		l=CDR(l); /* move for next time */
		return wstrdup(name);
	    }
	  default: continue;
	}
    }

    return NULL;
}

LISP siod_all_function_docstrings(void)
{
    // Returns all an assoc list of ALL functions that have any form 
    // of documentation strings, internal functions or user defined.
    LISP docs = siod_docstrings;
    
    // But we need user defined function with docstrings too.
    // The docustring must start with a ( to be included
    LISP l = oblistvar;
    LISP code,val;

    // Search the oblist for functions
    for(;CONSP(l);l=CDR(l))
    {
	if (VCELL(car(l)) == NIL) continue;
	switch(TYPE(VCELL(CAR(l))))
	{
	  case tc_closure:
	    val = VCELL(CAR(l));
	    code = val->storage_as.closure.code;
	    if ((CONSP(code)) &&
		(CONSP(cdr(code))) &&
		(CONSP(cdr(cdr(code)))) &&
		(TYPE(car(cdr(cdr(code)))) == tc_string))
		docs = cons(cons(car(l),car(cdr(cdr(code)))),docs);
	  default:
	    continue;
	}
    }

    return docs;
}

void pprint(LISP exp)
{
    // Pretty print this expression to stdout
    
    pprintf(stdout,exp,0,72,-1,-1);
    fprintf(stdout,"\n");
}

LISP siod_pprintf(LISP exp, LISP file)
{
    //  Pretty printer

    if (file == NIL)
	pprint(exp);
    else
    {
	pprintf(get_c_file(file,stdout),exp,0,72,-1,-1);	
	fprintf(get_c_file(file,stdout),"\n");
    }
    return NIL;
}

void pprintf(FILE *fd,LISP exp,int indent,int width,int depth,int length)
{
    // A pretty printer for expressions
    // indent is the number of spaces to indent by
    // width is the maximum column we're allow to print to
    // depth is the we should print before ignoring it
    // length is the number of items in a list we should print
    int i,ll;
    LISP l;

    for (i=0; i<indent; i++)
	fprintf(fd," ");
    if (exp == NIL)
	fprintf(fd,"nil");
    else if (!consp(exp))
	fprintf(fd,"%s",siod_sprint(exp));
    else 
    {
	char *p = siod_sprint(exp);
	if ((signed)strlen(p) < width-indent)
	    fprintf(fd,"%s",p);
	else
	{
	    fprintf(fd,"(");
	    if (depth == 0)
		fprintf(fd,"...");
	    else
	    {
		pprintf(fd,car(exp),0,width,depth-1,length);
		for (ll=length,l=cdr(exp); l != NIL; l=cdr(l),ll--)
		{
		    fprintf(fd,"\n");
		    if (ll == 0)
		    {
			pprintf(fd,rintern("..."),indent+1,width,depth-1,length);
			break;
		    }
		    else if (!consp(l))  // a dotted pair
		    {
			fprintf(fd," . %s",siod_sprint(l));
			break;
		    }
		    else
			pprintf(fd,car(l),indent+1,width,depth-1,length);
		}
	    }
	    fprintf(fd,")");
	}
	wfree(p);
    }    
}

/*  Something I really need, printing to a string.                       */
/*  This returns a new string representing the printform of the given    */
/*  LISP object. Unlike lprint etc which simply pushes the result of to  */
/*  a file.                                                              */
char *siod_sprint(LISP exp)
{
    ostrstream sd;
    char *s;

    siod_string_print(exp,sd);

    sd << '\0';
    s = wstrdup(sd.str());

    return s;
}

static void siod_string_print(LISP exp, ostrstream &sd)
{
    LISP tmp;
    int i;

    switch TYPE(exp)
    {
      case tc_nil:
	sd << "nil";
	break;
      case tc_cons:
	sd << "(";
	siod_string_print(car(exp),sd);
	for(tmp=cdr(exp);CONSP(tmp);tmp=cdr(tmp))
	{
	    sd << " ";
	    siod_string_print(car(tmp),sd);
	}
	if NNULLP(tmp) 
	{
	    sd << " . ";
	    siod_string_print(tmp,sd);
	}
	sd << ")";
	break;
      case tc_flonum:
	if (FLONMPNAME(exp) == NULL)
	{
	    sprintf(tkbuffer,"%g",FLONM(exp));
	    FLONMPNAME(exp) = (char *)must_malloc(strlen(tkbuffer)+1);
	    sprintf(FLONMPNAME(exp),"%s",tkbuffer);
	}
	sprintf(tkbuffer,"%s",FLONMPNAME(exp));
	sd << tkbuffer;
	break;
      case tc_string:
	sd << "\"";
	for (i=0; exp->storage_as.string.data[i] != '\0'; i++)
	{
	    if (exp->storage_as.string.data[i] == '"')
		sd << '\\';
	    if (exp->storage_as.string.data[i] == '\\')
		sd << '\\';
	    sd << exp->storage_as.string.data[i];
	}
	sd << "\"";
	break;
      case tc_symbol:
	sd << PNAME(exp);
	break;
      case tc_utt:
	sprintf(tkbuffer,"#<UTT %p>",UTTVAL(exp));
	sd << tkbuffer;
	break;
      case tc_streamitem:
	sprintf(tkbuffer,"#<STREAMITEM %p>",STREAMITEMVAL(exp));
	sd << tkbuffer;
	break;
      case tc_ptr:
	sprintf(tkbuffer,"#<PTR %p>",PTRVAL(exp));
	sd << tkbuffer;
	break;
      case tc_subr_0:
      case tc_subr_1:
      case tc_subr_2:
      case tc_subr_3:
      case tc_lsubr:
      case tc_fsubr:
      case tc_msubr:
	sprintf(tkbuffer,"#<SUBR(%d) ",TYPE(exp));
	sd << tkbuffer;
	sd << (*exp).storage_as.subr.name;
	sd << ">";
	break;
      case tc_c_file:
	sprintf(tkbuffer,"#<FILE %p ",exp->storage_as.c_file.f);
	sd << tkbuffer;
	if (exp->storage_as.c_file.name)
	    sd << exp->storage_as.c_file.name;
	sd << ">";
        break;
      case tc_closure:
	sd << "#<CLOSURE ";
	siod_string_print(car((*exp).storage_as.closure.code),sd);
	sd << " ";
	siod_string_print(cdr((*exp).storage_as.closure.code),sd);
	sd << ">";
	break;
      default:
	struct user_type_hooks *p;
	p = get_user_type_hooks(TYPE(exp));
	if (p->print_string)
	  (*p->print_string)(exp, tkbuffer);
	else
	  sprintf(tkbuffer,"#<UNKNOWN %d %p>",TYPE(exp),exp);
	sd << tkbuffer;
    }
    return;
}

int sort_compare_docstrings(const void *x, const void *y)
{
    LISP a=*(LISP *)x;
    LISP b=*(LISP *)y;

    return EST_strcasecmp(get_c_string(car(a)),get_c_string(car(b)));
}

static void siod_print_docstring(char *symname, char *docstring, FILE *fp)
{
    // Print to fp a texinfo list item for this description
    // Take the first line of the docstring as the label, and also remove
    // any indentation in the remainder of the lines
    int i,state;
    (void)symname;
    EST_String ds = docstring;
    const char *dsc;

    if (ds.contains(make_regex("\\[see .*\\]$")))
    {   // Contains a cross reference so replace it with texi xref command
	EST_String rest, ref;
	rest = ds.before(make_regex("\\[see [^\n]*\\]$"));
	ref = ds.after(rest);
	ref = ref.after("[see ");
	ref = ref.before("]");
	ds = rest + EST_String("[\\@pxref\\{") + ref + EST_String("\\}]");
    }

    dsc = ds;

    fprintf(fp,"@item ");
    for (state=0,i=0; dsc[i] != '\0'; i++)
    {
	if (((dsc[i] == '@') ||
	     (dsc[i] == '{') ||
	     (dsc[i] == '}')) &&
	    ((i == 0) ||
	     (dsc[i-1] != '\\')))
	    putc('@',fp);
	if ((dsc[i] == '\\') &&
	    ((dsc[i+1] == '@') ||
	     (dsc[i+1] == '{') ||
	     (dsc[i+1] == '}')))
	    state = state;
	else if (state == 0)
	{
	    putc(dsc[i],fp);
	    if (dsc[i] == '\n')
		state = 1;
	}
	else if (state == 1)
	    if (dsc[i] != ' ')
	    {
		putc(dsc[i],fp);
		state = 0;
	    }
    }
    fprintf(fp,"\n");
}

LISP siod_sort_and_dump_docstrings(LISP type,LISP filefp)
{
    // sort docstrings then dump them to filefp as a texinfo list
    LISP *array,l,docstrings;
    int num_strings;
    int i;

    if (streq(get_c_string(type),"function"))
	docstrings = siod_all_function_docstrings();
    else if (streq(get_c_string(type),"features"))
	docstrings = symbol_value(rintern("ff_docstrings"),NIL);
    else
	docstrings = symbol_value(rintern("var-docstrings"),NIL);
	
    num_strings = siod_llength(docstrings);
    array = walloc(LISP,num_strings);
    for (l=docstrings,i=0; i < num_strings; i++,l=cdr(l))
	array[i] = car(l);
    qsort(array,num_strings,sizeof(LISP),sort_compare_docstrings);

    for (i=0; i < num_strings; i++)
	siod_print_docstring(get_c_string(car(array[i])),
			     get_c_string(cdr(array[i])),
			     get_c_file(filefp,stdout));

    wfree(array);

    return NIL;

}
