 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /*************************************************************************/
 /*                                                                       */
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)             */
 /*                   Date: Mon Mar 17 1997                               */
 /* -------------------------------------------------------------------   */
 /* Scheme visible objects which can have subtypes.                       */
 /*                                                                       */
 /*************************************************************************/


#if !defined(__SUBTYPEDOBJECT_H__)
#define __SUBTYPEDOBJECT_H__

#include "SchemeObject.h"

template<class BaseClass> 
class SubtypedObject : public SchemeObject {

public:
  typedef struct subtype {
    char *name;
    bool (*recognise)(FILE *stream);
    BaseClass *(*create)();
  } Subtype;

protected:
  static const Subtype *subtypes;

public:

  virtual EST_String subtype_name(void) const {return "ABSTRACT";};

  virtual EST_String type_name(void) const;

  static BaseClass *create(EST_String type);

  static int legal_type(EST_String name); // is the name a subtype of this type;
  static BaseClass *open(EST_String filename); // access an existing database

  // The following routines should be defined by specific object types.
#if 0
  static bool recognise(FILE *stream);
  static BaseClass *create(void);
#endif

#if defined(INCLUDE_LISP)
protected:
  static int s_lisp_type;
public:
  static LISP lisp_make(LISP type, LISP properties);
  static LISP lisp_open(LISP filename);

  static void lisp_print(LISP, FILE *);
  static void lisp_print_string(LISP, char *);
#endif
};
#endif
