 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /*************************************************************************/
 /*                                                                       */
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)             */
 /*                   Date: Fri Aug  1 1997                               */
 /* --------------------------------------------------------------------  */
 /* Things useful in imposition routines for FreesUnits.                  */
 /*                                                                       */
 /*************************************************************************/

#include "frames_imposition_support.h"

void create_modunits_stream(FramesUnit::Chunk *chunks,
			    EST_Stream *unit_stream,
			    EST_Stream *modunit_stream
			    )
{
  FramesUnit::Chunk *ch;

  // Create new modified unit stream
  EST_Stream_Item *unit_item=unit_stream->head();
  for(; unit_item; unit_item=next(unit_item))
    {
      
      FramesUnit *unit = (FramesUnit *)unit_item->contents();
      FramesUnit *modunit = (FramesUnit *)unit->derived_unit();
      modunit->gc_ref();

      EST_Stream_Item *item = modunit_stream->append(modunit, modunit->name(), Unit::decrease_reference_count);

      item->set_feature("type", modunit->subtype_name());
      link(*unit_item, *item);
    }

  // replace the units in the chunks with the new ones
  EST_Stream_Item *modunit_item=modunit_stream->head();
  unit_item=unit_stream->head();
  for(ch=chunks; ch->n != 0; ch++)
    for(int i=0; i < ch->n ; i++)
      {
	if (ch->bit[i].unit == unit_item->contents())
	  ch->bit[i].unit = (FramesUnit *)modunit_item->contents();
	else
	  {
	    unit_item= next(unit_item);
	    modunit_item= next(modunit_item);

	    if (ch->bit[i].unit == unit_item->contents())
	      ch->bit[i].unit = (FramesUnit *)modunit_item->contents(); 
	    else
	      err("Can't find unit", ch->bit[i].unit->name());
	  }
      }
}  
