 /*************************************************************************/
 /*                                                                       */
 /*                Centre for Speech Technology Research                  */
 /*                     University of Edinburgh, UK                       */
 /*                       Copyright (c) 1996,1997                         */
 /*                        All Rights Reserved.                           */
 /*  Permission to use, copy, modify, distribute this software and its    */
 /*  documentation for research, educational and individual use only, is  */
 /*  hereby granted without fee, subject to the following conditions:     */
 /*   1. The code must retain the above copyright notice, this list of    */
 /*      conditions and the following disclaimer.                         */
 /*   2. Any modifications must be clearly marked as such.                */
 /*   3. Original authors' names are not deleted.                         */
 /*  This software may not be used for commercial purposes without        */
 /*  specific prior written permission from the authors.                  */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
 /*  THIS SOFTWARE.                                                       */
 /*                                                                       */
 /*************************************************************************/
 /*                                                                       */
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)             */
 /*                   Date: Wed Mar 19 1997                               */
 /* --------------------------------------------------------------------- */
 /* A Unit type for units which have content which consists of frames     */
 /* each representing a pitch period containing LPCs, residual,           */
 /* original signal or whatever.                                          */
 /*                                                                       */
 /*************************************************************************/


#ifndef __FRAMESUNIT_H__
#define __FRAMESUNIT_H__

#include "Unit.h"

#define MAX_UNITS_IN_CHUNK (3)

class FramesUnit : public Unit {
public:

  // A structure used to hold the (pieces of) units which make up
  // a given chunk of utterance (a Segment, but could be any span).

  class Chunk  {
  public:
    struct bit
    {
      FramesUnit *unit;
      int start_frame;
      int end_frame;
    } bit[MAX_UNITS_IN_CHUNK];
    int n;
  };

private:
  EST_Wave *p_signal;
  EST_Wave *p_residual;
  EST_Track *p_lpc;
  EST_Track *p_pitchmarks;

  // How the unit divides into Segments
  EST_TVector<int> *p_segment_ends;

  // MOdification information (prosody etc)
  EST_Track *p_modifications[MAX_UNITS_IN_CHUNK];
  int p_n_mods;

public:
  FramesUnit(void);
  virtual ~FramesUnit(void);

  static bool recognise(FILE *stream) { (void)stream; return FALSE;};
  static Unit *create(void);

  virtual ValueType property(EST_String name) const;
  virtual EST_String subtype_name(void) const {return "Frames";};

  int add_modifications(EST_Track *mods);

  virtual int length(void);			// in arbitrary units;
  virtual EST_TVector<int> *segment_ends(void);

  EST_Wave *signal(void);
  EST_Wave *residual(void);
  EST_Track *lpc(void);
  EST_Track *pitchmarks(void);

  EST_Track *modifications(int i) const;
  int n_modifications(void) const;

  int sample_rate(void);

  // Utility function which produces a description of how units and joins
  // map to Segments. This just wraps up the loops needed to walk over the
  // utterance structure since these are quite, er, eldritch.

  // Returns a static buffer, the end of the list of chunks can
  // be recognised by looking for `n' being 0.

  static Chunk *chunk_utterance(EST_Utterance *utterance,
				      const EST_String unit_stream_name,
				      const EST_String join_stream_name);

  static Chunk *chunk_utterance(EST_Utterance *utterance,
				      EST_Stream *unit_stream,
				      EST_Stream *join_stream);

  static void dump_chunks(ostream &stream, const Chunk *);

};

#endif
