# Construct IDE interface

proc utilmenu {name} {
  global params

# Add dummy for correct deleting
  $name add separator
  $name delete 1 last
  if {$params(Util) != {}} {
    $name add separator
    set i 1
    foreach l $params(Util) {
      $name add command -label "$i [lindex $l 0]" -underline 0 \
        -command "Util [expr $i -1]"
      incr i
    }
  }
}

proc SetPos {} {
  global params

#  update idletasks
#  set x [expr [winfo rootx .]+[winfo width .]+10]
  set x [expr [winfo rootx .]+10]
  set y [winfo rooty .]
  set params(dlg_geom) +$x+$y
  set params(x0) $x
  set params(y0) $y
  set params(default_geom) +$params(x0)+0
  debug $params(dlg_geom)
}

proc ButtonHint {w s} {
  set x [winfo rootx $w]
  set y [expr [winfo rooty $w]+[winfo height $w]]
  catch {destroy .hint}
  menu .hint -tearoff 0 -bg yellow -bd 1 -relief flat
  .hint add command -label $s
  .hint post $x $y
}

proc DelButtonHint {} {
  catch {destroy .hint}
}

proc WaitHint {w s} {
  set x [expr round([winfo rootx $w]+[winfo width $w]*0.4)]
  set y [expr round([winfo rooty $w]+[winfo height $w]*0.4)]
  menu .wait -tearoff 0 -bg red -font 10x20 -fg white -bd 2 -relief raised
  .wait add command -label $s
  .wait post $x $y
}

proc DelWaitHint {} {
  catch {destroy .wait}
}

proc showbuttons {} {
  global gparams

  if {$gparams(showicons)} {
    catch {
      grid .h -row 0 -column 0 -sticky ew
    }
  } else {
    catch {
      grid forget .h
    }
  }
}

proc showprimary {} {
  global gparams

  if {$gparams(showprimary)} {
    catch {
      grid .p -row 1 -column 0 -sticky ew
    }
  } else {
    catch {
      grid forget .p
    }
  }
}

proc showterm {} {
  global gparams

  if {$gparams(showout)} {
    catch {
      grid .term -row 2 -column 0 -sticky ew
    }
  } else {
    catch {
      grid forget .term
    }
  }
}
# Toplevel window
# +----------------------------------------+
# | Menubar .m                             |
# +----------------------------------------+
# | |Hotkey|Select| .h                     |
# | |   Info      |                        |
# +----------------------------------------+
# | Primary File .p                        |
# +----------------------------------------+
# | Terminal .t (80x25)                    |
# |                                        |
# |                                        |
# |                                        |
# +----------------------------------------+
#

proc ide {} {
  global params gparams

  update idletasks
  if [info exists gparams(pos)] {
    set pos $gparams(pos)
  } else {
    set pos +10+25
  }
  catch {wm geometry . $pos} 
  wm title . TeXShell
  wm iconbitmap . @$params(icon_dir)/tex.ico

  # Regions
  frame .p -bd 1 -relief groove
  frame .h -bd 1 -relief groove
  text .term -width 80 -height 25 -font fixed
  grid .term -row 2 -column 0 -sticky nsew

  # Menubar
  menu .menubar -bd 1
  . config -menu .menubar
  foreach m {File Action Util Options} {
    set $m [menu .menubar.m$m -tearoff 0]
    .menubar add cascade -label $m -underline 0 -menu .menubar.m$m
  }
  set Help [menu .menubar.help -tearoff 0]
  .menubar add cascade -label Help -underline 0 -menu .menubar.help

  $File add command -label "Primary File..." -underline 0 \
    -accelerator {Shift-F3} -command Primary
  $File add command -label "Edit Primary" -underline 1 \
    -accelerator {Alt-0} -command EditPrim
  $File add command -label "Edit..." -underline 0 -accelerator {F3} \
    -command Edit
  $File add command -label "Structure..." -underline 0 -accelerator \
    F4 -command Project
  $File add separator
  $File add command -label Exit -underline 1 -accelerator {Alt-X} \
    -command {Exit}

  $Action add command -label "Graphics" -accelerator F5 -command Graphic
  $Action add command -label "Compose" -accelerator F6 -command Compose
  $Action add command -label "References" -accelerator F7 -command Reference
  $Action add command -label "View" -accelerator F8 -command View
  $Action add command -label "Print" -accelerator F9 -command Print
  $Action add command -label "User" -accelerator F11 -command User

  $Util add command -label "Kill Process" -underline 0 -command Kill  
  utilmenu $Util
  
  $Options add checkbutton -label "Show Toolbar" \
    -variable gparams(showicons) -command showbuttons -underline 5
  $Options add checkbutton -label "Show Primary" \
    -variable gparams(showprimary) -command showprimary -underline 5
  $Options add checkbutton -label "Show Output" -underline 0 \
    -variable gparams(showout) -command showterm
  $Options add separator
  $Options add command -label "Global Settings..." \
    -underline 0 -command Options
  $Options add command -label "Editor Settings..." \
    -underline 0 -command EditOpt
  $Options add separator
  $Options add command -label "Editor..." -accelerator {^F3} \
    -underline 0 -command {selectparams Edit}
  $Options add command -label "Graphics..." -accelerator {^F5} \
    -underline 0 -command {selectparams Graphic}
  $Options add command -label "Compose..." -accelerator {^F6} \
    -underline 0 -command {selectparams Compose}
  $Options add command -label "References..." -accelerator {^F7} \
    -underline 0 -command {selectparams Reference}
  $Options add command -label "View..." -accelerator {^F8} \
    -underline 0 -command {selectparams View}
  $Options add command -label "Print..." -accelerator {^F9} \
    -underline 0 -command {selectparams Print}
  $Options add command -label "Utils..." -accelerator {^F11} \
    -underline 0 -command {selectparams Util}

  $Help add command -label "TeXShell..." -accelerator F1 -command {Help .}

  # Command Buttons
  
  frame .h.fedit -bd 1 -relief groove
  button .h.bedit -bitmap @$params(icon_dir)/edit2.ico -command Edit -bd 1
  button .h.sedit -bitmap @$params(icon_dir)/down2.ico -bd 1 \
    -command {SelectAction .h.bedit Edit}
  label .h.ledit -textvariable params(Edit_name) -font fixed -anchor w -width 7
  pack .h.ledit -in .h.fedit -side bottom
  pack .h.bedit .h.sedit -in .h.fedit -side left

  frame .h.fgraph -bd 1 -relief groove
  button .h.bgraph -bitmap @$params(icon_dir)/graphic2.ico -command Graphic \
    -bd 1
  button .h.sgraph -bitmap @$params(icon_dir)/down2.ico -bd 1 \
    -command {SelectAction .h.bgraph Graphic}
  label .h.lgraph -textvariable params(Graphic_name) -font fixed -anchor w \
    -width 7
  pack .h.lgraph -in .h.fgraph -side bottom
  pack .h.bgraph .h.sgraph -in .h.fgraph -side left

  frame .h.fcompose -bd 1 -relief groove
  button .h.bcompose -bitmap @$params(icon_dir)/tex2.ico -command Compose -bd 1
  button .h.scompose -bitmap @$params(icon_dir)/down2.ico -bd 1 \
    -command {SelectAction .h.bcompose Compose}
  label .h.lcompose -textvariable params(Compose_name) -font fixed -anchor w \
    -width 7
  pack .h.lcompose -in .h.fcompose -side bottom
  pack .h.bcompose .h.scompose -in .h.fcompose -side left

  frame .h.fref -bd 1 -relief groove
  button .h.bref -bitmap @$params(icon_dir)/ref2.ico -command Reference -bd 1
  button .h.sref -bitmap @$params(icon_dir)/down2.ico -bd 1 \
    -command {SelectAction .h.bref Reference}
  label .h.lref -textvariable params(Reference_name) -font fixed -anchor w \
    -width 7
  pack .h.lref -in .h.fref -side bottom
  pack .h.bref .h.sref -in .h.fref -side left

  frame .h.fview -bd 1 -relief groove
  button .h.bview -bitmap @$params(icon_dir)/xdvi2.ico -command View -bd 1
  button .h.sview -bitmap @$params(icon_dir)/down2.ico -bd 1 \
    -command {SelectAction .h.bview View}
  label .h.lview -textvariable params(View_name) -font fixed -anchor w \
    -width 7
  pack .h.lview -in .h.fview -side bottom
  pack .h.bview .h.sview -in .h.fview -side left

  frame .h.fprint -bd 1 -relief groove
  button .h.bprint -bitmap @$params(icon_dir)/printer2.ico -command Print -bd 1
  button .h.sprint -bitmap @$params(icon_dir)/down2.ico -bd 1 \
    -command {SelectAction .h.bprint Print}
  label .h.lprint -textvariable params(Print_name) -font fixed -anchor w \
    -width 7
  pack .h.lprint -in .h.fprint -side bottom
  pack .h.bprint .h.sprint -in .h.fprint -side left

  frame .h.futil -bd 1 -relief groove
  button .h.butil -bitmap @$params(icon_dir)/cat2.ico -command Util -bd 1
  button .h.sutil -bitmap @$params(icon_dir)/down2.ico -bd 1 \
    -command {SelectAction .h.butil Util}
  label .h.lutil -textvariable params(Util_name) -font fixed -anchor w \
    -width 7
  pack .h.lutil -in .h.futil -side bottom
  pack .h.butil .h.sutil -in .h.futil -side left

  frame .h.fhelp -bd 1 -relief groove
  button .h.bhelp -bitmap @$params(icon_dir)/help2.ico -command {Help .} -bd 1
  label .h.lhelp -text "" -font fixed -anchor w \
    -width 3
  pack .h.lhelp -in .h.fhelp -side bottom
  pack .h.bhelp -in .h.fhelp -side left

  button .h.fexit -bitmap @$params(icon_dir)/door2.ico -command Exit -bd 1
  pack .h.fedit .h.sedit .h.fgraph .h.sgraph \
    .h.fcompose .h.scompose .h.fref .h.sref .h.fview .h.sview \
    .h.fprint .h.sprint .h.futil .h.sutil .h.fhelp -side left
  pack .h.fexit -side right -anchor n
  showbuttons
  showprimary

 # Primary file
  button .p.bprimary -bitmap @$params(icon_dir)/primary.ico -command Primary \
    -bd 1
#  button .p.bprimary -text "Primary File:" -command Primary
  label .p.d -textvariable params(Short_dir) -font fixed -bd 2 -relief sunken
  label .p.ls -text " / "
  label .p.f -textvariable params(Primary_file) -font fixed -bd 2 \
    -relief sunken
  button .p.bstruct -bitmap @$params(icon_dir)/struct.ico -command Project \
    -bd 1
  pack .p.bprimary .p.bstruct .p.d .p.ls .p.f -side left -pady 1

  # Bindings
  bind .p.bprimary <Enter> {ButtonHint %W "Primary File"}
  bind .p.bprimary <Leave> {DelButtonHint}
  bind .p.bstruct <Enter> {ButtonHint %W Structure}
  bind .p.bstruct <Leave> {DelButtonHint}
  bind .h.bedit <Enter> {ButtonHint %W Edit}
  bind .h.bedit <Leave> {DelButtonHint}
  bind .h.bgraph <Enter> {ButtonHint %W Graphics}
  bind .h.bgraph <Leave> {DelButtonHint}
  bind .h.bcompose <Enter> {ButtonHint %W Compose}
  bind .h.bcompose <Leave> {DelButtonHint}
  bind .h.bref <Enter> {ButtonHint %W References}
  bind .h.bref <Leave> {DelButtonHint}
  bind .h.bview <Enter> {ButtonHint %W View}
  bind .h.bview <Leave> {DelButtonHint}
  bind .h.bprint <Enter> {ButtonHint %W Print}
  bind .h.bprint <Leave> {DelButtonHint}
  bind .h.butil <Enter> {ButtonHint %W Utils}
  bind .h.butil <Leave> {DelButtonHint}
  bind .h.bhelp <Enter> {ButtonHint %W Help}
  bind .h.bhelp <Leave> {DelButtonHint}
  bind .h.fexit <Enter> {ButtonHint %W Exit}
  bind .h.fexit <Leave> {DelButtonHint}
  bind .h.bedit		<Button-3> "selectparams Edit"
  bind .h.bcompose	<Button-3> "selectparams Compose"
  bind .h.bref		<Button-3> "selectparams Reference"
  bind .h.bview		<Button-3> "selectparams View"
  bind .h.bprint	<Button-3> "selectparams Print"
  bind .h.bgraph	<Button-3> "selectparams Graphic"
  bind .h.butil		<Button-3> "selectparams Util"
  GlobalBind
  bind .term <Button-1> "xfocus ."
  update

# Output window
  CreateTerm

#  toplevel .t
#  wm group . .t
#  set x [expr [winfo rootx .]+[winfo width .]+10]
#  wm geometry .t +${x}+5
#  wm title .t "Log Window"
#  wm minsize .t 0 0
#  wm withdraw .t
#  frame .t.ftext
#  pack .t.ftext -fill both -expand true
#  pack .t.ftext
#
#  text .t.text -width 80 -height 24 -yscrollcommand {.t.sb set} \
#    -relief sunken -wrap word -font fixed -fg #6f6f6f
#  scrollbar .t.sb -command {.t.text yview}
#  pack .t.sb -side right -fill y -anchor e -in .t.ftext
#  pack .t.text -side left -expand true -fill both -in .t.ftext
#  bind .t.text <Any-Key> { }
#  GlobalBind .t.text

  # Save dialog geometry
##  update
  # Save default window geometry
  SetPos
  debug $params(dlg_geom)
  showterm
  xfocus .
#  focus default .
}

proc GlobalBind {} {

  bind all <F1> {Help %W}
  bind . <Alt-Any-x> {Exit}
  bind . <F3> {Edit}
  bind . <Alt-Any-0> {EditPrim}
  bind . <F13>      {Primary}
  bind . <Shift-F3> {Primary}
  bind . <Alt-F3> { }
  bind . <F4> {Project}
  bind . <F5> {Graphic}
  bind . <F6> {Compose}
  bind . <F7> {Reference}
  bind . <F8> {View}
  bind . <F9> {Print}
  bind . <F11> {Util}
  bind . <Control-F3> "selectparams Edit"
  bind . <Control-F5> "selectparams Graphic"
  bind . <Control-F6> "selectparams Compose"
  bind . <Control-F7> "selectparams Reference"
  bind . <Control-F8> "selectparams View"
  bind . <Control-F9> "selectparams Print"
  bind . <Control-F11> "selectparams Util"
  bind . <Alt-Any-F5>  "xfocus ."

  for {set i 1} {$i < 10} {incr i} {
    bind . <Alt-Any-Key-$i> "Edit $i"
  }
#  bind Text <Any-Key> { }
#  bind Text <Return> { }
#  bind Text <Delete> { }
#  bind Text <BackSpace> { }
}
