# ts_prj.tcl
proc prjreadpatterns {} {
  global env params

  set fd [open "$env(HOME)/.ts/includes.cfg" r]
  set params(prjinclpatterns) {}
  while {![eof $fd]} {
    gets $fd s
    set sc [string range $s 0 0]
    set pt [string range $s 2 end]
    if {$s != ""} {lappend params(prjinclpatterns) [list $sc $pt]}
  }
  close $fd
}

proc prjscanfile {f} {
  global params

  set fd [open $f r]
  set prjfiles {}
  while {![eof $fd]} {
    gets $fd s
    if {$s == ""} continue
    foreach p $params(prjinclpatterns) {
      foreach {sc pt} $p {break}
      while {[regexp "${pt}(.*)" $s dummy cmd file s]} {
        lappend prjfiles [list $cmd $file $sc]
      }
    }
  }
  close $fd
  return $prjfiles
}

proc prjscan {file {dep 0} {sc 1}} {
  incr dep
  set exist 1
  if {![file isfile $file]} {
    if {[file isfile "$file.tex"]} {
      set file "$file.tex"
    } elseif {[file isfile "$file.sty"]} {
      set file "$file.sty"
    } else {
      set exist 0
    }
  }
  if {!$exist || $dep > 10} {
    return [list $file 0 {}]
  }
  if {!$sc} {
    return [list $file 1 {}]
  }
  set prjlist [prjscanfile $file]
  debug $prjlist
  set filelist {}
  foreach p $prjlist {
    set f [lindex $p 1]
    set sc [lindex $p 2]
    lappend filelist [prjscan $f $dep $sc]
  }
  return [list $file 1 $filelist]
}

proc prjdrawentry {w d l lold bool text} {
  set x0 [expr $d*10-10]
  set x [expr $d*10]
  set y0 [expr $lold*15+14]
  set y [expr $l*15+10]
  set scrreg [$w cget -scrollregion]
  foreach {xx yy width height} $scrreg { break }
  if {$height < $y+10} {
    $w config -scrollregion [list 0 0 $width [expr $y+10]]
  }
  if $bool {
    set col green
  } else {
    set col red
  }
  $w create oval [expr $x-4] [expr $y-4] [expr $x+4] [expr $y+4] \
    -fill $col -outline black
  $w create text [expr $x+10] $y -text $text -anchor w
  if {$l > 0} {
    $w create line $x0 $y0 $x0 $y [expr $x-4] $y
  }
}

proc prjsel {w i} {
  global params

  if {$i >= [llength $params(prj_filelist)]} {
    set i [expr [llength $params(prj_filelist)] - 1]
  } elseif {$i < 0} {
    set i 0
  }
  set y0 [expr $i*15+1]
  set y [expr $i*15+15]
  set params(prj_selidx) $i
  $w coords selframe 0 $y0 200 $y
  foreach {xa ya xb yb} [$w cget -scrollregion] {break}
  set d0 [expr (1.0*$y0)/$yb]
  set d1 [expr (1.0*$y)/$yb]
  foreach {da db} [$w yview] {break}
  if {$d1 > $db} {
    $w yview moveto [expr $da+$d1-$db]
  } elseif {$d0 < $da} {
    $w yview moveto $d0
  }
}

# prjlist: file exist prjlists
proc prjdraw {w prjlist {line 0} {dep 0} {oldline 0}} {
  global params
  
  incr dep
  set file [lindex $prjlist 0]
  set exist [lindex $prjlist 1]
  set filelist [lindex $prjlist 2]
  prjdrawentry $w $dep $line $oldline $exist $file
  lappend params(prj_filelist) [list $file $exist]
  set oldline $line
  foreach fl $filelist {
    debug $fl
    incr line
    set line [prjdraw $w $fl $line $dep $oldline]
  }
  return $line
}

proc prjclose {} {
  focus .
  destroy .prj
  return
}

proc prjrescan {} {
  global params

  set prjlist [prjscan $params(Primary_file)]
  .prj.c delete all
  set params(prj_filelist) {}
  prjdraw .prj.c $prjlist
  .prj.c create rectangle 1 1 200 15 -tag selframe
  update idletasks
  prjsel .prj.c 0
}

proc prjedit {} {
  global params

  foreach {file exist} [lindex $params(prj_filelist) $params(prj_selidx)] {
    break
  }
  if {!$exist} {
    Warning $params(dlg_geom) "File doesn't exist.\nCreate it with Edit."
    return
  }
  EditFile $file
}
  

proc Project {} {
  global params prj

  if {$params(Primary_file) == ""} {
    if {![Primary]} return
    if  {$params(Primary_file) == ""} {
      Warning $params(dlg_geom) "No primary file is specified"
      return
    }
  }
  # Build project window
  if {[winfo exists .prj]} {
    prjrescan
    xfocus .prj.c
    return
  }
   
  set x [winfo rootx .term]
  set y [winfo rooty .term]
  toplevel .prj
  wm geometry .prj +$x+$y
  wm title .prj "Project"
  canvas .prj.c -width 200 -height 200 -scrollregion {0 0 200 200} \
    -yscrollcommand ".prj.sb set" -relief sunken
  scrollbar .prj.sb -command ".prj.c yview"
  grid .prj.c -row 0 -column 0 -columnspan 4 -sticky nsew
  grid .prj.sb -row 0 -column 4 -sticky ns
  grid columnconfigure .prj 2 -weight 1
  grid rowconfigure .prj 0 -weight 1
  frame .prj.fedit -bd 1 -relief sunken
  button .prj.bedit -text "Edit" -command prjedit
  pack .prj.bedit -in .prj.fedit -padx 5 -pady 3
  button .prj.rescan -text "Rescan" -underline 0 -command prjrescan
  button .prj.cancel -text "Cancel" -command prjclose
  grid .prj.fedit -row 1 -column 0 -padx 5 -pady 3
  grid .prj.rescan -row 1 -column 1 -padx 5 -pady 3
  grid .prj.cancel -row 1 -column 2 -padx 5 -pady 3
  bindtags .prj.c {.prj.c all .}
  bind .prj.c <Down> {prjsel .prj.c [expr $params(prj_selidx)+1]}
  bind .prj.c <Up>   {prjsel .prj.c [expr $params(prj_selidx)-1]}
  bind .prj.c <1>  {prjsel .prj.c [expr int([%W canvasy %y])/15]}
  bind .prj.c <Double-1> {prjedit}
  bind .prj.c <Return> {prjedit}
  bind .prj.c <Escape> {prjclose}
  bind .prj.c <Alt-R> {prjrescan}
  prjrescan
  xfocus .prj.c
}
