#    Copyright (C) 1991, 1995, 1996 Aladdin Enterprises.  All rights reserved.
# 
# This file is part of Aladdin Ghostscript.
# 
# Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
# or distributor accepts any responsibility for the consequences of using it,
# or for whether it serves any particular purpose or works at all, unless he
# or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
# License (the "License") for full details.
# 
# Every copy of Aladdin Ghostscript must include a copy of the License,
# normally in a plain ASCII text file named PUBLIC.  The License grants you
# the right to copy, modify and redistribute Aladdin Ghostscript, but only
# under certain conditions described in the License.  Among other things, the
# License requires that the copyright notice and this notice be preserved on
# all copies.

# tccommon.mak
# Section of MS-DOS makefile common to Turbo C and Turbo/Borland C++,
# MS-DOS and MS Windows.

# This file is used by tc.mak, bc.mak, bcwin.mak, and bcwin32.mak.
# Those files supply the following parameters:
#   Configuration, public:
#	GS_DOCDIR, GS_LIB_DEFAULT, GS_INIT, FEATURE_DEVS, DEVICE_DEVS*,
#	COMPILE_INITS, CONFIG
#   Configuration, internal, generic:
#	PLATFORM, MAKEFILE, AK, CC*, DEBUG, NOPRIVATE, CP_, RM_, RMN_,
#   Configuration, internal, specific to DOS/Windows:
#	TDEBUG, USE_ASM, ASM,
#	COMPDIR, COMP, COMPAUX, WINCOMP, (BGIDIR, BGIDIRSTR), INCDIR, LIBDIR,
#	CPU_TYPE, FPU_TYPE
#	F286, GENOPT, CAOPT

# Make sure we get the right default target for make.

dosdefault: default

# Define a rule for invoking just the preprocessor.

.c.i:
	$(COMPDIR)\cpp -I$(INCDIR) $(CAOPT) $(CCFLAGS) -P- $<

# Note that built-in libpng and zlib aren't available.

SHARE_LIBPNG=0
SHARE_ZLIB=0

# Define the syntax for command, object, and executable files.

CMD=.bat
O=-o
OBJ=obj
XE=.exe
XEAUX=.exe

# Define the current directory prefix and shell invocations.

D=\\

EXP=
SH=
SHP=

# Define generic commands.

CP_=copy /B
RM_=erase
RMN_=call rm.bat

# Define the arguments for genconf.

# We can't use $(ld_tr) because Borland make expands macro usages in
# macro definitions at definition time, not at use time.
CONFILES=-p %s+ -o ld$(CONFIG).tr -l lib.tr

# Define the memory model for Turbo C.  Don't change it!

MM=l

# Define the generic compilation flags.

!if $(CPU_TYPE) >= 400
ASMCPU=/DFOR80386 /DFOR80486
PLATOPT=$(F286) -DFOR80386 -DFOR80486
!elif $(CPU_TYPE) >= 300
ASMCPU=/DFOR80386
PLATOPT=$(F286) -DFOR80386
!elif $(CPU_TYPE) >= 200
ASMCPU=
PLATOPT=$(F286)
!elif $(CPU_TYPE) >= 100
ASMCPU=
PLATOPT=-1
!else
ASMCPU=
PLATOPT=
!endif

!if $(CPU_TYPE) >= 486 || $(FPU_TYPE) >= 287
ASMFPU=/DFORFPU
FPFLAGS=-f287
FPLIB=fp87
!elif $(FPU_TYPE) > 0
ASMFPU=/DFORFPU
FPFLAGS=-f87
FPLIB=fp87
!else
!if $(FPU_TYPE) < 0
ASMFPU=/DNOFPU
!else
ASMFPU=
!endif
FPFLAGS=
FPLIB=emu
!endif

!if $(TDEBUG)
ASMDEBUG=/DDEBUG
!else
ASMDEBUG=
!endif

!if $(USE_ASM)
INTASM=iutilasm.$(OBJ)
PCFBASM=gdevegaa.$(OBJ)
!else
INTASM=
PCFBASM=
!endif

# Define the generic compilation rules.

ASMFLAGS=$(ASMCPU) $(ASMFPU) $(ASMDEBUG)

.asm.obj:
	$(ASM) $(ASMFLAGS) $<;

# ---------------------- MS-DOS I/O debugging option ---------------------- #

dosio_=zdosio.$(OBJ)
dosio.dev: $(dosio_)
	$(SETMOD) dosio $(dosio_)
	$(ADDMOD) dosio -oper zdosio

zdosio.$(OBJ): zdosio.c $(OP) $(store_h)

# ----------------------------- Assembly code ----------------------------- #

iutilasm.$(OBJ): iutilasm.asm
