/*
 * fchooser.c : Xarchie interface to the FileChooser
 *
 * George Ferguson, ferguson@cs.rochester.edu, 23 Apr 1993.
 */

#if NeedFunctionPrototypes
struct _FileChooserInfo;
#endif

typedef void (*FileChooserOkProc)(
#if NeedFunctionPrototypes
    struct _FileChooserInfo *fcinfo,
    char *filename,
    XtPointer client_data
#endif
);

typedef void (*FileChooserCancelProc)(
#if NeedFunctionPrototypes
    struct _FileChooserInfo *fcinfo,
    XtPointer client_data
#endif
);

typedef struct _FileChooserInfo {
    Widget shell;
#ifdef FILECHOOSER
    Widget fcw;
#endif
    Widget text;
    Widget okButton,cancelButton;
    FileChooserOkProc okCallback;
    FileChooserCancelProc cancelCallback;
    XtPointer client_data;
} FileChooserInfo;

extern FileChooserInfo *
createFileChooser(
#if NeedFunctionPrototypes
    Widget shell,
    Widget parent,
    char *basename,
    FileChooserOkProc okCallback,
    FileChooserCancelProc cancelCallback,
    XtPointer client_data
#endif
);
