
import java.sql.*;


/**
 * Test all the SQLServer datatypes in Statement and PreparedStatement
 *
 */
public class t0018
{
   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException
   {
      System.out.println("Test getAsciiStream with all 6 supported types");

      // open the database
      Class.forName("com.internetcds.jdbc.tds.Driver");

      boolean     passed   = true;
      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();
      ResultSet   rs;

      String bigtext1 = 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "abcdefghijklmnop" + 
         "";
      String bigimage1 = "0x" +
         "0123456789abcdef" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "fedcba9876543210" +
         "";

      try
      {
         stmt.executeUpdate("drop table t0018");
      }
      catch (SQLWarning e)
      {
         if (! (e.getMessage().startsWith("Cannot drop the table 't0018', because it does")))
         {
            throw e;
         }
      }

      String sql =
         "create table t0018 (                                  " +
         " mybinary                   binary(5) not null,       " +
         " myvarbinary                varbinary(4) not null,    " +
         " mychar                     char(10) not null,        " +
         " myvarchar                  varchar(8) not null,      " +
         " mytext                     text not null,            " +
         " myimage                    image not null,           " +
         " mynullbinary               binary(3) null,           " +
         " mynullvarbinary            varbinary(6) null,        " +
         " mynullchar                 char(10) null,            " +
         " mynullvarchar              varchar(40) null,         " +
         " mynulltext                 text null,                " +
         " mynullimage                image null)               ";

      count = stmt.executeUpdate(sql);


      // Insert a row without nulls via a Statement
      sql =
         "insert into t0018(       " +
         " mybinary,               " + 
         " myvarbinary,            " + 
         " mychar,                 " + 
         " myvarchar,              " + 
         " mytext,                 " + 
         " myimage,                " + 
         " mynullbinary,           " + 
         " mynullvarbinary,        " + 
         " mynullchar,             " + 
         " mynullvarchar,          " + 
         " mynulltext,             " + 
         " mynullimage             " +
         ")                        " +
         "values(                  " +
         " 0xffeeddccbb,           " +  // mybinary          
         " 0x78,                   " +  // myvarbinary       
         " 'Z',                    " +  // mychar            
         " '',                     " +  // myvarchar         
         " '" + bigtext1 + "',     " +  // mytext            
         " " + bigimage1 + ",      " +  // myimage           
         " null,                   " +  // mynullbinary      
         " null,                   " +  // mynullvarbinary   
         " null,                   " +  // mynullchar        
         " null,                   " +  // mynullvarchar     
         " null,                   " +  // mynulltext        
         " null                    " +  // mynullimage       
         ")";
        

       count = stmt.executeUpdate(sql);
       
       sql = "select * from t0018";
       rs = stmt.executeQuery(sql);
       System.out.println("Executed query");
       if (!rs.next())
       {
          passed = false;
       }
       else
       {
          System.out.println("Getting the results");
          System.out.println("mybinary is " + rs.getObject("mybinary"));
          System.out.println("myvarbinary is " + rs.getObject("myvarbinary"));
          System.out.println("mychar is " + rs.getObject("mychar"));
          System.out.println("myvarchar is " + rs.getObject("myvarchar"));
          System.out.println("mytext is " + rs.getObject("mytext"));
          System.out.println("myimage is " + rs.getObject("myimage"));
          System.out.println("mynullbinary is " + rs.getObject("mynullbinary"));
          System.out.println("mynullvarbinary is " + rs.getObject("mynullvarbinary"));
          System.out.println("mynullchar is " + rs.getObject("mynullchar"));
          System.out.println("mynullvarchar is " + rs.getObject("mynullvarchar"));
          System.out.println("mynulltext is " + rs.getObject("mynulltext"));
          System.out.println("mynullimage is " + rs.getObject("mynullimage"));
       }
       
       
     System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0018.\n");
      System.exit(passed ? 0 : 1);
   }
}

