import java.net.URL;
import java.util.*;
import java.sql.*;
// import com.internetcds.jdbc.tds.*;
import java.lang.Thread;
import java.math.BigDecimal;


public class t0019
{
   public static void main(String args[])
      throws java.sql.SQLException, java.lang.ClassNotFoundException,
      java.lang.IllegalAccessException, java.lang.InstantiationException,
      java.lang.InterruptedException
   {
      System.out.println("Test money handling.");

      java.sql.Connection conn = Common.getConnection();
      java.sql.Statement  stmt   = null;
      BigDecimal          tmp1   = null;
      BigDecimal          tmp2   = null;
      boolean             passed = false;
      int                 i;
      BigDecimal          money[] = {
         new BigDecimal("922337203685477.5807"),
         new BigDecimal("-922337203685477.5807"),
         new BigDecimal("1.00"),
         new BigDecimal("0.00"),
         new BigDecimal("-1.00")
      };
      BigDecimal          smallmoney[] = {
         new BigDecimal("214748.3647"),
         new BigDecimal("-214748.3648"),
         new BigDecimal("1.00"),
         new BigDecimal("0.00"),
         new BigDecimal("-1.00")
      };

      if (smallmoney.length != money.length)
      {
         throw new SQLException("Must have same number of elements in " + 
                                "money and smallmoney");
      }

      stmt = conn.createStatement();


      try
      {
         stmt.executeUpdate("drop table t0019");
      }
      catch (SQLWarning e)
      {
         String okayError = "Cannot drop the table";

         if (! (e.getMessage().startsWith(okayError)))
         {
            throw e;
         }
      }

      stmt.executeUpdate("create table t0019 (                     " +
                         "  i               integer primary key,   " + 
                         "  mymoney         money not null,        " +
                         "  mysmallmoney    smallmoney not null)   " +
                         "");
      
      for(i=0; i<money.length; i++)
      {
         stmt.executeUpdate("insert into t0019 values (" +
                            i + ", " + money[i] + ",   " +
                            smallmoney[i] + ")         ");
      }
      

      ResultSet rs = stmt.executeQuery("select * from t0019 order by i");
       
      for(i=0, passed=true; passed && rs.next(); i++)
      {
         BigDecimal  m; 
         BigDecimal  sm;
        
         m = (BigDecimal)rs.getObject("mymoney");
         sm = (BigDecimal)rs.getObject("mysmallmoney");
         
         money[i].setScale(2, BigDecimal.ROUND_DOWN);
         smallmoney[i].setScale(2, BigDecimal.ROUND_DOWN);

         passed = passed && m.equals(money[i].setScale(2, BigDecimal.ROUND_DOWN));
         passed = passed && sm.equals(smallmoney[i].setScale(2, BigDecimal.ROUND_DOWN));

         System.out.println(m + ", " + sm);
         if (!passed)
         {
            System.out.println("Expected- " + money[i] + ", " + smallmoney[i]);
         }            
      }

     System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0019.\n");
      System.exit(passed ? 0 : 1);
   }
}

