
import java.sql.*;




/**
 * Test stored procedure calls
 */
public class t0029
{
   static public void main(String args[])
      throws SQLException, java.lang.ClassNotFoundException, java.lang.Exception
   {
      System.out.println("Test stored procedure calls.");

      boolean   passed = true;


      // open the database
      Class.forName("com.internetcds.jdbc.tds.Driver");

      int         i;
      int         j;
      int         count    = 0;
      Connection  cx       = Common.getConnection();
      Statement   stmt     = cx.createStatement();
      ResultSet   rs       = null;
      
      boolean isResultSet;
      int updateCount;

      int resultSetCount=0;
      int rowCount=0;
      int numberOfUpdates=0;


      System.out.println("before execute DROP PROCEDURE");

      try
      {
         isResultSet =stmt.execute("DROP PROCEDURE t0029_p1");
         updateCount = stmt.getUpdateCount();
         do {
            System.out.println("DROP PROCEDURE isResultSet: " + isResultSet);
            System.out.println("DROP PROCEDURE updateCount: " + updateCount);
            isResultSet = stmt.getMoreResults();
            updateCount = stmt.getUpdateCount();
         } while (((updateCount!=-1) && !isResultSet) || isResultSet);
      }
      catch(SQLWarning e)
      {
         if (! (e.getMessage().startsWith("Cannot drop ")))
         {
            System.out.println("|" + e.getMessage() + "|");
            throw e;
         }
      }

      try
      {
         isResultSet =stmt.execute("DROP PROCEDURE t0029_p2");
         updateCount = stmt.getUpdateCount();
         do {
            System.out.println("DROP PROCEDURE isResultSet: " + isResultSet);
            System.out.println("DROP PROCEDURE updateCount: " + updateCount);
            isResultSet = stmt.getMoreResults();
            updateCount = stmt.getUpdateCount();
         } while (((updateCount!=-1) && !isResultSet) || isResultSet);
      }
      catch(SQLWarning e)
      {
         if (! (e.getMessage().startsWith("Cannot drop ")))
         {
            System.out.println("|" + e.getMessage() + "|");
            throw e;
         }
      }
      
      
      try
      {
         isResultSet =stmt.execute("DROP TABLE t0029_t1");
         updateCount = stmt.getUpdateCount();
         do {
            System.out.println("DROP TABLE isResultSet: " + isResultSet);
            System.out.println("DROP TABLE updateCount: " + updateCount);
            isResultSet = stmt.getMoreResults();
            updateCount = stmt.getUpdateCount();
         } while (((updateCount!=-1) && !isResultSet) || isResultSet);
      }
      catch(SQLWarning e)
      {
         if (! (e.getMessage().startsWith("Cannot drop ")))
         {
            System.out.println("|" + e.getMessage() + "|");
            throw e;
         }
      }

      isResultSet =
	stmt.execute(
		     " create table t0029_t1                       " +
		     "  (t1 datetime not null,                     " +
		     "   t2 datetime null,                         " +
		     "   t3 smalldatetime not null,                " +
		     "   t4 smalldatetime null,                    " +
		     "   t5 text null)                             ");
      updateCount = stmt.getUpdateCount();
      do {
	System.out.println("CREATE TABLE isResultSet: " + isResultSet);
	System.out.println("CREATE TABLE updateCount: " + updateCount);
	isResultSet = stmt.getMoreResults();
	updateCount = stmt.getUpdateCount();
      } while (((updateCount!=-1) && !isResultSet) || isResultSet);


      isResultSet = 
	stmt.execute(
		     "CREATE PROCEDURE t0029_p1                    " +
		     "AS                                           " +
		     "                                             " +
		     " insert into t0029_t1 values                " +
		     " ('1999-01-07', '1998-09-09 15:35:05',       " +
		     " getdate(), '1998-09-09 15:35:00', null)     " +
		     "                                             " +
		     " update t0029_t1 set t1='1999-01-01'         " +
		     "                                             " +
		     " insert into t0029_t1 values                 " +
		     " ('1999-01-08', '1998-09-09 15:35:05',       " +
		     " getdate(), '1998-09-09 15:35:00','456')     " +
		     "                                             " +
		     " update t0029_t1 set t2='1999-01-02'         " +
		     "                                             " +
		     " declare @ptr varbinary(16)                  " +
		     " select @ptr=textptr(t5) from t0029_t1       " +
		     "   where t1='1999-01-08'                     " +
		     " writetext t0029_t1.t5 @ptr with log '123'   " +
		     "                                             " +
		     "                                             ");

      updateCount = stmt.getUpdateCount();
      do {
	System.out.println("CREATE PROCEDURE isResultSet: " + isResultSet);
	System.out.println("CREATE PROCEDURE updateCount: " + updateCount);
	isResultSet = stmt.getMoreResults();
	updateCount = stmt.getUpdateCount();
      } while (((updateCount!=-1) && !isResultSet) || isResultSet);


      isResultSet = 
	stmt.execute(
		     "CREATE PROCEDURE t0029_p2                    " +
		     "AS                                           " +
		     " EXEC t0029_p1                               " +
		     " SELECT * FROM t0029_t1                      " +
		     "                                             " +
		     "                                             " +
		     "                                             ");

      updateCount = stmt.getUpdateCount();
      do {
	System.out.println("CREATE PROCEDURE isResultSet: " + isResultSet);
	System.out.println("CREATE PROCEDURE updateCount: " + updateCount);
	isResultSet = stmt.getMoreResults();
	updateCount = stmt.getUpdateCount();
      } while (((updateCount!=-1) && !isResultSet) || isResultSet);


      isResultSet = stmt.execute( "EXEC  t0029_p2  ");

      System.out.println("execute(EXEC t0029_p2) returned: " + isResultSet);

      updateCount=stmt.getUpdateCount();

      while (isResultSet || (updateCount!=-1)) {
	if (isResultSet) {
	  resultSetCount++;
	  rs = stmt.getResultSet();

	  ResultSetMetaData rsMeta =  rs.getMetaData();
	  int columnCount = rsMeta.getColumnCount();
	  System.out.println("columnCount: " +
			     Integer.toString(columnCount));
	  for(int n=1; n<= columnCount; n++) {
	    System.out.println(Integer.toString(n) + ": " +
			       rsMeta.getColumnName(n));
	  }

	  while(rs.next()) {
	    rowCount++;
	    for(int n=1; n<= columnCount; n++) {
	      System.out.println(Integer.toString(n) + ": " + 
				 rs.getString(n));
	    }
	  }
	  
	}
	else {
	  numberOfUpdates++;
	  System.out.println("UpdateCount: " +
			     Integer.toString(updateCount));
	}
	isResultSet=stmt.getMoreResults();
	updateCount = stmt.getUpdateCount();
      }

      System.out.println("resultSetCount: " + resultSetCount);
      System.out.println("Total rowCount: " + rowCount);
      System.out.println("Number of updates: " + numberOfUpdates);


      passed = passed && 
	(resultSetCount==1) &&
	(rowCount==2) &&
	(numberOfUpdates==1);
      if (!passed)
      {
         throw new SQLException("failed.");
      }

      cx.close();

     System.out.println("\n" + (passed ? "Passed" : "Failed") 
                         + " t0029.\n");
      System.exit(passed ? 0 : 1);
   }
}


