/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.spec;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ClassUnloadRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.WatchpointRequest;
import java.util.Iterator;
import java.util.List;
import jde.debugger.Application;
import jde.debugger.Debug;
import jde.debugger.JDEException;
import jde.debugger.Protocol;
import jde.debugger.spec.ReferenceTypeSpec;

public abstract class EventRequestSpec
implements Protocol {
    public static final Object expressionKey = "expr";
    public static final Object threadKey = "thread";
    public static final Object specPropertyKey = "spec";
    private final Long myID;
    private String expr = null;
    private Object thread = null;
    private int suspendPolicy = 2;
    private List classFilters = null;
    private List classExFilters = null;
    boolean isResolved = false;
    final Application app;
    ReferenceTypeSpec refSpec;
    EventRequest request = null;

    public void setExpression(String expr) {
        this.expr = expr;
        if (this.request != null) {
            this.request.putProperty(expressionKey, expr);
        }
    }

    public void setThread(Object thread) {
        this.thread = thread;
        if (this.request != null) {
            this.request.putProperty(threadKey, thread);
        }
    }

    public void setSuspendPolicy(int policy) {
        this.suspendPolicy = policy;
        if (this.request != null) {
            this.request.setSuspendPolicy(policy);
        }
    }

    public void setClassFilters(List filters) {
        this.classFilters = filters;
        if (this.request != null) {
            this.installClassFilters(this.request);
        }
    }

    private void installClassFilters(EventRequest request) {
        if (this.classFilters == null) {
            return;
        }
        Iterator iter = this.classFilters.iterator();
        while (iter.hasNext()) {
            String f = iter.next().toString();
            if (request instanceof ClassPrepareRequest) {
                ((ClassPrepareRequest)request).addClassFilter(f);
                continue;
            }
            if (request instanceof ClassUnloadRequest) {
                ((ClassUnloadRequest)request).addClassFilter(f);
                continue;
            }
            if (request instanceof ExceptionRequest) {
                ((ExceptionRequest)request).addClassFilter(f);
                continue;
            }
            if (!(request instanceof WatchpointRequest)) continue;
            ((WatchpointRequest)request).addClassFilter(f);
        }
    }

    public void setClassExFilters(List filters) {
        this.classExFilters = filters;
        if (this.request != null) {
            this.installClassExFilters(this.request);
        }
    }

    private void installClassExFilters(EventRequest request) {
        if (this.classExFilters == null) {
            return;
        }
        Iterator iter = this.classExFilters.iterator();
        while (iter.hasNext()) {
            String f = iter.next().toString();
            if (request instanceof ClassPrepareRequest) {
                ((ClassPrepareRequest)request).addClassExclusionFilter(f);
                continue;
            }
            if (request instanceof ClassUnloadRequest) {
                ((ClassUnloadRequest)request).addClassExclusionFilter(f);
                continue;
            }
            if (request instanceof ExceptionRequest) {
                ((ExceptionRequest)request).addClassExclusionFilter(f);
                continue;
            }
            if (!(request instanceof WatchpointRequest)) continue;
            ((WatchpointRequest)request).addClassExclusionFilter(f);
        }
    }

    public Long getID() {
        return this.myID;
    }

    void setRequest(EventRequest request) {
        this.request = request;
        request.putProperty(specPropertyKey, this);
        request.putProperty(threadKey, this.thread);
        request.putProperty(expressionKey, this.expr);
        request.setSuspendPolicy(this.suspendPolicy);
        this.installClassFilters(request);
        this.installClassExFilters(request);
        request.enable();
        this.app.informJDEInstallSuccessful(this);
    }

    public EventRequest getEventRequest() {
        return this.request;
    }

    abstract boolean resolve(ReferenceType var1) throws JDEException;

    public void attemptResolve(ReferenceType refType) {
        if (!this.isResolved() && this.refSpec.matches(refType)) {
            try {
                if (this.resolve(refType)) {
                    this.setIsResolved();
                }
            }
            catch (JDEException ex) {
                this.app.removeSpecAndInformJDE(this, ex.getMessage());
            }
            catch (Exception ex) {
                Debug.printIf(ex);
                this.app.removeSpecAndInformJDE(this, "Error resolving spec: " + ex.toString());
            }
        }
    }

    void attemptImmediateResolve(VirtualMachine vm) {
        Iterator<ReferenceType> iter = vm.allClasses().iterator();
        while (iter.hasNext()) {
            ReferenceType refType = iter.next();
            if (!this.refSpec.matches(refType)) continue;
            try {
                if (!this.resolve(refType)) continue;
                this.setIsResolved();
            }
            catch (JDEException ex) {
                this.app.removeSpecAndInformJDE(this, ex.getMessage());
            }
            catch (Exception ex) {
                this.app.removeSpecAndInformJDE(this, "Error resolving spec");
            }
        }
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    public void setIsResolved() {
        this.isResolved = true;
    }

    boolean isJavaIdentifier(String s) {
        if (s.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < s.length()) {
            if (!Character.isJavaIdentifierPart(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public EventRequestSpec(Application app, ReferenceTypeSpec refSpec) {
        this.app = app;
        this.refSpec = refSpec;
        this.myID = app.getNewID();
    }
}

