#include "forms.h"
#include <stdio.h>
#include <ctype.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <stdlib.h>
#include "xmysqladmin.h"
#include "xmysqladmin2.h"
#include "mysql.h"

#define NO_SELECT_HOST 0
#define SELECTED_HOST  1
#define NO_SELECT_USER 2
#define SELECTED_USER  3
#define NO_SELECT_DBF  4
#define SELECTED_DBF   5
#define SELECTED_SUBFORM 6


extern struct setup Setup;
extern struct statxmysqladmin Stat;
FD_inputdb *f_inputdb;
extern struct inputGrant *InputGrant, *InpHost, *InpDb, *InpUser;
struct inputGrant *InputTemp;
extern FD_grant *f_grant;
void main_inputdb(int type);
void inputdb_setfields(void);
void inputdb_getfields(void);
extern void grant_activate(int status);
extern void grant_getDb(FL_OBJECT *browser, char *hostName, char *userName);

void inputdb_input(FL_OBJECT *obj, long data)
{
  ;
}
void inputdb_save(FL_OBJECT *obj, long data)
{
  int closeForm = 1;
  
  inputdb_getfields();

  /* creation de la fiche du host */

  if(InputGrant->host[0] && InputGrant->user[0] && InputGrant->db[0])
  {
    MYSQL connection;
    if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
    {
      MYSQL_RES *result;
      char *query;
      
      query = (char *) malloc(2048);
      if(!query) return;
      
      mysql_select_db(&connection, "mysql");
      if(!InputGrant->stat)
	{
	  sprintf(query,
	          "insert into db (host,db,user,select_priv,insert_priv,update_priv,delete_priv,create_priv,drop_priv) values ('%s','%s','%s','%s','%s','%s','%s','%s','%s')",
                  InputGrant->host,InputGrant->db,InputGrant->user,
		  InputGrant->select,InputGrant->insert,
		  InputGrant->update,InputGrant->delete,
		  InputGrant->create,InputGrant->drop);
	}
      else
	{
	  sprintf(query,
	          "update db set db='%s',select_priv='%s',insert_priv='%s',update_priv='%s',delete_priv='%s',create_priv='%s',drop_priv='%s' where host='%s' and user='%s' and db='%s'",
                  InputGrant->db,InputGrant->select,
		  InputGrant->insert,InputGrant->update,
		  InputGrant->delete,InputGrant->create,
		  InputGrant->drop,
		  InputTemp->host,InputTemp->user,InputTemp->db);
	}
      if (!mysql_query(&connection, query))
	{
	  result = mysql_store_result(&connection);
	  if(result != NULL) mysql_free_result(result);
	}
      else
	{
	  fl_show_messages(mysql_error(&connection));
	  closeForm = 0;
	}
	free(query);
	mysql_close(&connection);
    }
  }

  if(closeForm)
    {
      free(InputTemp);
      fl_hide_form(f_inputdb->inputdb);
      fl_free_form(f_inputdb->inputdb);
      free(f_inputdb);
      Stat.flagInputDb=0;
      grant_activate(NO_SELECT_DBF);
      grant_getDb(f_grant->dbf, InputGrant->host, InputGrant->user);
      memset(InpDb, '\0', sizeof(struct inputGrant));
    }
}

void inputdb_setfields()
{
  fl_set_input(f_inputdb->hostName       , InputGrant->host);
  fl_set_input(f_inputdb->databaseName   , InputGrant->db);
  fl_set_input(f_inputdb->userName       , InputGrant->user);
  
  if(InputGrant->select[0] == 'Y')
    fl_set_button(f_inputdb->bSelect, 1);
  else
    fl_set_button(f_inputdb->bSelect, 0);

  if(InputGrant->insert[0] == 'Y')
    fl_set_button(f_inputdb->bInsert, 1);
  else
    fl_set_button(f_inputdb->bInsert, 0);
  
  if(InputGrant->update[0] == 'Y')
    fl_set_button(f_inputdb->bUpdate, 1);
  else
    fl_set_button(f_inputdb->bUpdate, 0);
  
  if(InputGrant->delete[0] == 'Y')
    fl_set_button(f_inputdb->bDelete, 1);
  else
    fl_set_button(f_inputdb->bDelete, 0);
  
  if(InputGrant->create[0] == 'Y')
    fl_set_button(f_inputdb->bCreate, 1);
  else
    fl_set_button(f_inputdb->bCreate, 0);
  
  if(InputGrant->drop[0] == 'Y')
    fl_set_button(f_inputdb->bDrop, 1);
  else
    fl_set_button(f_inputdb->bDrop, 0);
  

}

void inputdb_getfields()
{
  char yes[2];
  char no[2];
  
  strcpy(yes, "Y");  strcpy(no, "N");
		     
  strcpy(InputGrant->host, fl_get_input(f_inputdb->hostName));
  strcpy(InputGrant->db,   fl_get_input(f_inputdb->databaseName));
  strcpy(InputGrant->user, fl_get_input(f_inputdb->userName));
  
  if(fl_get_button(f_inputdb->bSelect))
    strcpy(InputGrant->select, yes);
  else
    strcpy(InputGrant->select, no);

  if(fl_get_button(f_inputdb->bInsert))
    strcpy(InputGrant->insert, yes);
  else
    strcpy(InputGrant->insert, no);

  if(fl_get_button(f_inputdb->bUpdate))
    strcpy(InputGrant->update, yes);
  else
    strcpy(InputGrant->update, no);

  if(fl_get_button(f_inputdb->bDelete))
    strcpy(InputGrant->delete, yes);
  else
    strcpy(InputGrant->delete, no);

  if(fl_get_button(f_inputdb->bCreate))
    strcpy(InputGrant->create, yes);
  else
    strcpy(InputGrant->create, no);

  if(fl_get_button(f_inputdb->bDrop))
    strcpy(InputGrant->drop, yes);
  else
    strcpy(InputGrant->drop, no);

}


void main_inputdb(int type)
{
  if(Stat.flagInputDb) return;
  Stat.flagInputDb=1;

  InputTemp = (struct inputGrant *) calloc(1, sizeof(struct inputGrant));
  memcpy(InputTemp, InputGrant, sizeof(struct inputGrant));
  f_inputdb = create_form_inputdb();

  fl_set_input_maxchars(f_inputdb->hostName        , 60);
  fl_set_input_maxchars(f_inputdb->databaseName    , 32);
  fl_set_input_maxchars(f_inputdb->userName        , 16);

  fl_deactivate_object(f_inputdb->userName);
  fl_set_object_lcol(f_inputdb->userName, FL_INACTIVE);
  fl_set_input_color(f_inputdb->userName, FL_INACTIVE, FL_INACTIVE);
  fl_deactivate_object(f_inputdb->hostName);
  fl_set_object_lcol(f_inputdb->hostName, FL_INACTIVE);
  fl_set_input_color(f_inputdb->hostName, FL_INACTIVE, FL_INACTIVE);

  InputGrant->stat = type;
    
  inputdb_setfields();
  if(!type)
    fl_show_form(f_inputdb->inputdb, FL_PLACE_MOUSE, FL_TRANSIENT, "XmysqlAdmin new db access");
  else
    fl_show_form(f_inputdb->inputdb, FL_PLACE_MOUSE, FL_TRANSIENT, "XmysqlAdmin modify db access");
}

void inputdb_close(FL_OBJECT *obj, long data)
{
  free(InputTemp);
  fl_hide_form(f_inputdb->inputdb);
  fl_free_form(f_inputdb->inputdb);
  free(f_inputdb);
  Stat.flagInputDb=0;
  grant_activate(Stat.statusGrant);  
}

void inputdb_revert(FL_OBJECT *obj, long data)
{
  fl_freeze_form(f_inputdb->inputdb);
  inputdb_setfields();
  fl_unfreeze_form(f_inputdb->inputdb);
}

