#include "forms.h"
#include <stdio.h>
#include <ctype.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <stdlib.h>
#include "xmysqladmin.h"
#include "xmysqladmin2.h"
#include "mysql.h"

extern struct setup Setup;
extern struct statxmysqladmin Stat;
FD_isamchk *f_isam;
int isam_shutdown;
char g_isam_dbfname[33];

void isamchk_getDatabases(FL_OBJECT *browser);
void isam_makecmd(void);

void isam_makecmd()
{
  char *cmd;
  int i,tot;
  
  fl_deactivate_object(f_isam->execute);

  cmd = (char *) malloc(2048);
  if(cmd == NULL) return;

  
  /* scanne les commandes pour voir si shutdown necessaire */
  isam_shutdown = fl_isselected_browser_line(f_isam->parameters, 3)
                + fl_isselected_browser_line(f_isam->parameters, 6)
                + fl_isselected_browser_line(f_isam->parameters, 7)
                + fl_isselected_browser_line(f_isam->parameters, 8);
  
  strcpy(cmd, "isamchk ");
  if(fl_isselected_browser_line(f_isam->parameters, 1))
    strcat(cmd, "-a ");
  if(fl_isselected_browser_line(f_isam->parameters, 2))
    strcat(cmd, "-d ");
  if(fl_isselected_browser_line(f_isam->parameters, 3))
    strcat(cmd, "-e ");
  if(fl_isselected_browser_line(f_isam->parameters, 4))
    strcat(cmd, "-f ");
  if(fl_isselected_browser_line(f_isam->parameters, 5))
    strcat(cmd, "-i ");
  if(fl_isselected_browser_line(f_isam->parameters, 6))
    strcat(cmd, "-q ");
  if(fl_isselected_browser_line(f_isam->parameters, 7))
    strcat(cmd, "-r ");
  if(fl_isselected_browser_line(f_isam->parameters, 8))
    strcat(cmd, "-ro ");
  if(fl_isselected_browser_line(f_isam->parameters, 9))
    strcat(cmd, "-v ");
  if(fl_isselected_browser_line(f_isam->parameters, 10))
    strcat(cmd, "-w ");
  
  
  tot = fl_get_browser_maxline(f_isam->table);
  if(tot > 0)
    {
      int min = 0;
      for(i = 1; i <= tot; i++)
	{
	  if(fl_isselected_browser_line(f_isam->table, i))
	    {
	      min++;
              strcat(cmd, Setup.datapath);
	      strcat(cmd, g_isam_dbfname);
	      strcat(cmd, "/");
	      strcat(cmd, fl_get_browser_line(f_isam->table, i));
	      strcat(cmd, " ");
	    }
	}
      if(min > 0)
	{
	  fl_set_object_lcol(f_isam->execute, FL_BLACK);
	  fl_activate_object(f_isam->execute);
	}
    }
  
  fl_set_input(f_isam->input, cmd);
  
  free(cmd);
}
void isamchk_getDatabases(FL_OBJECT *browser)
{
  if(fl_get_browser_maxline(browser))
    fl_clear_browser(browser);

  {
    MYSQL connection;
    if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
    {
      MYSQL_RES *result;
      MYSQL_ROW row;
      int i;
      
      if ((result=mysql_list_dbs(&connection, "%")))
      {
        while ((row=mysql_fetch_row(result)))
	{
          for(i = 0; i < mysql_num_fields(result); i++)
	  {  
            fl_addto_browser_chars(browser, row[i]);
	    if(i < mysql_num_fields(result) - 1)
	      fl_addto_browser_chars(browser, "\t"); 
	  }
	  fl_addto_browser_chars(browser, "\n"); 
        }
	mysql_free_result(result);
      }
      mysql_close(&connection);
    }
  }
}

void main_isamchk(FL_OBJECT *obj, long data)
{
  if(Stat.flagIsam) return;
  Stat.flagIsam=1;
  
  f_isam = create_form_isamchk();
  fl_show_form(f_isam->isamchk, FL_PLACE_MOUSE, FL_TRANSIENT, "XmysqlAdmin isamchk");
  fl_freeze_form(f_isam->isamchk);

  fl_add_browser_line(f_isam->parameters, "Analyse");
  fl_add_browser_line(f_isam->parameters, "Description");
  fl_add_browser_line(f_isam->parameters, "Extended check (close server)");
  fl_add_browser_line(f_isam->parameters, "Force tempfile");
  fl_add_browser_line(f_isam->parameters, "Information in extra");
  fl_add_browser_line(f_isam->parameters, "Quick check");
  fl_add_browser_line(f_isam->parameters, "Recover (close server)");
  fl_add_browser_line(f_isam->parameters, "Recover old mode (close server)");
  fl_add_browser_line(f_isam->parameters, "Verbose output");
  fl_add_browser_line(f_isam->parameters, "Wait if locked");
  
  fl_deactivate_object(f_isam->table);
  fl_deactivate_object(f_isam->parameters);
  fl_deactivate_object(f_isam->input);
  fl_deactivate_object(f_isam->execute);
  fl_set_object_lcol(f_isam->execute, FL_INACTIVE);
  isamchk_getDatabases(f_isam->banque);  
  fl_unfreeze_form(f_isam->isamchk);
}

void isam_close(FL_OBJECT *obj, long data)
{
  fl_hide_form(f_isam->isamchk);
  fl_free_form(f_isam->isamchk);
  free(f_isam);
  Stat.flagIsam=0;
}


void isam_banque(FL_OBJECT *obj, long data)
{
  int ligne;
  
  ligne = fl_get_browser(obj);

  if(ligne > 0)
    {
      MYSQL connection;

      if(fl_get_browser_maxline(f_isam->table))
	fl_clear_browser(f_isam->table);
      
      if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
	{
	  MYSQL_RES *result;
	  MYSQL_ROW row;
	  int i;

	  strcpy(g_isam_dbfname, fl_get_browser_line(obj, ligne));
	  mysql_select_db(&connection, g_isam_dbfname);
      
	  fl_freeze_form(f_isam->isamchk);

	  if ((result=mysql_list_tables(&connection, "%")))
	    {
	      while ((row=mysql_fetch_row(result)))
		{
		  for(i = 0; i < mysql_num_fields(result); i++)
		    {  
		      fl_addto_browser_chars(f_isam->table, row[i]);
		      if(i < mysql_num_fields(result) - 1)
			fl_addto_browser_chars(f_isam->table, "\t"); 
		    }
		  fl_addto_browser_chars(f_isam->table, "\n"); 
		}
	      mysql_free_result(result);
	    }
	  mysql_close(&connection);
	}
      else
	{
	  fl_deactivate_object(f_isam->table);
	  fl_deactivate_object(f_isam->parameters);
	  fl_deactivate_object(f_isam->execute);
          fl_set_object_lcol(f_isam->execute, FL_INACTIVE);
	}

      fl_activate_object(f_isam->table);
      fl_activate_object(f_isam->parameters);
      fl_unfreeze_form(f_isam->isamchk);
    
    }		  
}			  
			  
void isam_table(FL_OBJECT *obj, long data)
{
  isam_makecmd();
}
void isam_param(FL_OBJECT *obj, long data)
{
  isam_makecmd();
}
void isam_input(FL_OBJECT *obj, long data)
{
  ;
}
void isam_execute(FL_OBJECT *obj, long data)
{
  if(isam_shutdown)
    {
      if(!fl_show_question("Server will be shutdown\nDo you want to continue?", 0))
	return;
      main_startServer(obj, data);
    }
  fl_show_command_log(FL_TRANSIENT);
  fl_exe_command(fl_get_input(f_isam->input), 1);
  if(isam_shutdown)
    {
      main_stopServer(obj, data);
    }
}

void main_startServer(FL_OBJECT *obj, long data)
{
  if(!fl_show_question("Server will be start\nDo you want to continue?", 0))
    return;
  fl_show_command_log(FL_TRANSIENT);
  fl_exe_command("mysql.server start", 1);
}
void main_stopServer(FL_OBJECT *obj, long data)
{
  if(!fl_show_question("Server will be stop\nDo you want to continue?", 0))
    return;
  fl_show_command_log(FL_TRANSIENT);
  fl_exe_command("mysql.server stop", 1);
}

