#include "forms.h"
#include <stdio.h>
#include <ctype.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <stdlib.h>
#include "xmysqladmin.h"
#include "xmysqladmin2.h"
#include "mysql.h"

#define LISTMODE 1
#define KILLMODE 2

extern struct setup Setup;
extern struct statxmysqladmin Stat;
FD_threads *f_threads;

void getThreads(FL_OBJECT *browser);
void getThreads(FL_OBJECT *browser)
{
  if(fl_get_browser_maxline(browser))
    fl_clear_browser(browser);

  {
    MYSQL connection;
    if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
    {
      MYSQL_RES *result;
      MYSQL_ROW row;
      int i;
      
      if ((result=mysql_list_processes(&connection)))
      {
        while ((row=mysql_fetch_row(result)))
	{
          for(i = 0; i < mysql_num_fields(result); i++)
	  {  
            fl_addto_browser_chars(browser, row[i]);
	    if(i < mysql_num_fields(result) - 1)
	      fl_addto_browser_chars(browser, "\t"); 
	  }
	  fl_addto_browser_chars(browser, "\n"); 
        }
	mysql_free_result(result);
      }
      mysql_close(&connection);
    }
  }
}

void setThreadsModeAff(void);
void setThreadsModeAff()
{
  switch(Stat.threadsmode)
  {
  case LISTMODE:
    fl_hide_object(f_threads->threads_killbrowser);
    fl_deactivate_object(f_threads->threads_killbrowser);
    fl_activate_object(f_threads->threads_listbrowser);
    fl_show_object(f_threads->threads_listbrowser);
    fl_activate_object(f_threads->threads_killmode);
    fl_show_object(f_threads->threads_killmode);
    fl_deactivate_object(f_threads->threads_listmode);
    fl_hide_object(f_threads->threads_listmode);
    fl_hide_object(f_threads->threads_killselected);
    fl_deactivate_object(f_threads->threads_killselected);
    fl_activate_object(f_threads->threads_timer);
    fl_show_object(f_threads->threads_timer);
    if(Setup.threadsRefreshTime > 0)
      fl_set_timer(f_threads->threads_timer, Setup.threadsRefreshTime);
    break;
  case KILLMODE:
    fl_show_object(f_threads->threads_killbrowser);
    fl_activate_object(f_threads->threads_killbrowser);
    fl_deactivate_object(f_threads->threads_listbrowser);
    fl_hide_object(f_threads->threads_listbrowser);
    fl_deactivate_object(f_threads->threads_killmode);
    fl_hide_object(f_threads->threads_killmode);
    fl_activate_object(f_threads->threads_listmode);
    fl_show_object(f_threads->threads_listmode);
    fl_show_object(f_threads->threads_killselected);
    fl_activate_object(f_threads->threads_killselected);
    fl_deactivate_object(f_threads->threads_timer);
    fl_hide_object(f_threads->threads_timer);
    break;
    
  }    
}
void main_threads(FL_OBJECT *obj, long data)
{
  if(Stat.flagThreads) return;
  Stat.flagThreads=1;
  Stat.threadsmode = LISTMODE;
  
  f_threads = create_form_threads();
  fl_show_form(f_threads->threads, FL_PLACE_FREE, FL_FULLBORDER, "XmysqlAdmin process list");
  fl_freeze_form(f_threads->threads);
  
  setThreadsModeAff();
  getThreads(f_threads->threads_listbrowser); 
  fl_unfreeze_form(f_threads->threads);
}

void threads_close(FL_OBJECT *obj, long data)
{
  fl_hide_form(f_threads->threads);
  fl_free_form(f_threads->threads);
  free(f_threads);
  Stat.flagThreads=0;
}
void threads_refresh(FL_OBJECT *obj, long data)
{
  FL_OBJECT *bobj;
  
  if(Stat.threadsmode == LISTMODE)
    bobj = f_threads->threads_listbrowser;
  else
    bobj = f_threads->threads_killbrowser;
  
  fl_freeze_form(f_threads->threads);
  getThreads(bobj);  
  fl_unfreeze_form(f_threads->threads);
}

void threads_timer(FL_OBJECT *obj, long data)
{
  if(Stat.threadsmode == LISTMODE)
    threads_refresh(obj, data);
  if(Setup.threadsRefreshTime > 0)
    fl_set_timer(f_threads->threads_timer, Setup.threadsRefreshTime);
}

void threads_killbrowser(FL_OBJECT *obj, long data)
{
;
}
void threads_listbrowser(FL_OBJECT *obj, long data)
{;}

void threads_killmode(FL_OBJECT *obj, long data)
{
  FL_OBJECT *bobj;
  
  bobj = f_threads->threads_killbrowser;
  Stat.threadsmode = KILLMODE;

  fl_freeze_form(f_threads->threads);
  setThreadsModeAff();
  getThreads(bobj);  
  fl_unfreeze_form(f_threads->threads);
}
void threads_listmode(FL_OBJECT *obj, long data)
{
  FL_OBJECT *bobj;
  
  bobj = f_threads->threads_listbrowser;
  Stat.threadsmode = LISTMODE;

  fl_freeze_form(f_threads->threads);
  setThreadsModeAff();
  getThreads(bobj);  
  fl_unfreeze_form(f_threads->threads);
}
void threads_killselected(FL_OBJECT *obj, long data)
{
  int tlignes;
  int i;
  long task;
  char strTask[11], *ptr2;
  const char *ligne, *ptr;
  MYSQL connection;
  
  if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
  {
    tlignes = fl_get_browser_maxline(f_threads->threads_killbrowser);

    for(i = 0; i < tlignes; i++)
    {
      if(fl_isselected_browser_line(f_threads->threads_killbrowser, i))
      {
        ligne = fl_get_browser_line(f_threads->threads_killbrowser, i);

	/* find task number */
	ptr = ligne; ptr2 = strTask;
	while(*ptr != 9)
	{
	  *ptr2 =  *ptr;
	  ptr2++; ptr++;
	}
	*ptr2 = '\0';
	task = atol(strTask);
	
	/* kill task */
	mysql_kill(&connection, (unsigned long) task);
      }
    }
    
    mysql_close(&connection);
  }

  fl_freeze_form(f_threads->threads);
  getThreads(f_threads->threads_killbrowser);  
  fl_unfreeze_form(f_threads->threads);
}
