/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.dom;

import org.openxml.dom.CollectionIndex;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;

public class CollectionImpl
implements HTMLCollection {
    private Element _topLevel;
    private String _lookForTag;

    public CollectionImpl(Element element) {
        if (element == null) {
            throw new NullPointerException("Argument 'topLevel' is null.");
        }
        this._topLevel = element;
    }

    public CollectionImpl(Element element, String string) {
        if (element == null) {
            throw new NullPointerException("Argument 'topLevel' is null.");
        }
        if (string == null || string.length() == 0) {
            throw new NullPointerException("Argument 'lookFor' is null or an empty string.");
        }
        this._topLevel = element;
        this._lookForTag = string;
    }

    protected boolean collectionMatch(Element element, String string) {
        boolean bl;
        Element element2 = element;
        synchronized (element2) {
            bl = element.getTagName().equals(this._lookForTag);
            if (bl && string != null) {
                bl = string.equals(element.getAttribute("id"));
            }
        }
        return bl;
    }

    public final int getLength() {
        return this.getLength(this.getTopLevel());
    }

    private int getLength(Element element) {
        int n;
        Element element2 = element;
        synchronized (element2) {
            n = 0;
            Node node = element.getFirstChild();
            while (node != null) {
                if (node instanceof Element) {
                    if (this.collectionMatch((Element)node, null)) {
                        ++n;
                    }
                    if (this.recurse()) {
                        n += this.getLength((Element)node);
                    }
                }
                node = node.getNextSibling();
            }
        }
        return n;
    }

    private Element getTopLevel() {
        return this._topLevel;
    }

    public final Node item(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Argument 'index' is negative.");
        }
        return this.item(this.getTopLevel(), new CollectionIndex(n));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Node item(Element element, CollectionIndex collectionIndex) {
        Element element2 = element;
        synchronized (element2) {
            Node node = element.getFirstChild();
            while (node != null) {
                if (node instanceof Element) {
                    Node node2;
                    if (this.collectionMatch((Element)node, null)) {
                        if (collectionIndex.isZero()) {
                            return node;
                        }
                        collectionIndex.decrement();
                    }
                    if (this.recurse() && (node2 = this.item((Element)node, collectionIndex)) != null) {
                        return node2;
                    }
                }
                node = node.getNextSibling();
            }
            return null;
        }
    }

    public final Node namedItem(String string) {
        if (string == null) {
            throw new NullPointerException("Argument 'name' is null.");
        }
        return this.namedItem(this.getTopLevel(), string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Node namedItem(Element element, String string) {
        Element element2 = element;
        synchronized (element2) {
            Node node = element.getFirstChild();
            while (node != null) {
                if (node instanceof Element) {
                    Node node2;
                    if (this.collectionMatch((Element)node, string)) {
                        return node;
                    }
                    if (this.recurse() && (node2 = this.namedItem((Element)node, string)) != null) {
                        return node2;
                    }
                }
                node = node.getNextSibling();
            }
            return node;
        }
    }

    protected boolean recurse() {
        return true;
    }
}

