/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.dom.html;

import org.openxml.dom.CollectionImpl;
import org.openxml.dom.html.HTMLFormControl;
import org.w3c.dom.Element;
import org.w3c.dom.html.HTMLAnchorElement;
import org.w3c.dom.html.HTMLAppletElement;
import org.w3c.dom.html.HTMLAreaElement;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLFormElement;
import org.w3c.dom.html.HTMLImageElement;
import org.w3c.dom.html.HTMLObjectElement;
import org.w3c.dom.html.HTMLOptionElement;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableRowElement;
import org.w3c.dom.html.HTMLTableSectionElement;

final class HTMLCollectionImpl
extends CollectionImpl
implements HTMLCollection {
    static final short ANCHOR = 1;
    static final short FORM = 2;
    static final short IMAGE = 3;
    static final short APPLET = 4;
    static final short LINK = 5;
    static final short OPTION = 6;
    static final short ROW = 7;
    static final short ELEMENT = 8;
    static final short AREA = -1;
    static final short TBODY = -2;
    static final short CELL = -3;
    private short _lookingFor;

    HTMLCollectionImpl(HTMLElement hTMLElement, short s) {
        super(hTMLElement);
        this._lookingFor = s;
    }

    protected boolean collectionMatch(Element element, String string) {
        boolean bl;
        Element element2 = element;
        synchronized (element2) {
            bl = false;
            switch (this._lookingFor) {
                case 1: {
                    bl = element instanceof HTMLAnchorElement && element.getAttribute("name") != null;
                    break;
                }
                case 2: {
                    bl = element instanceof HTMLFormElement;
                    break;
                }
                case 3: {
                    bl = element instanceof HTMLImageElement;
                    break;
                }
                case 4: {
                    bl = element instanceof HTMLAppletElement || element instanceof HTMLObjectElement && ("application/java".equals(element.getAttribute("codetype")) || element.getAttribute("classid") != null && element.getAttribute("classid").startsWith("java:"));
                    break;
                }
                case 8: {
                    bl = element instanceof HTMLFormControl;
                    break;
                }
                case 5: {
                    bl = (element instanceof HTMLAnchorElement || element instanceof HTMLAreaElement) && element.getAttribute("href") != null;
                    break;
                }
                case -1: {
                    bl = element instanceof HTMLAreaElement;
                    break;
                }
                case 6: {
                    bl = element instanceof HTMLOptionElement;
                    break;
                }
                case 7: {
                    bl = element instanceof HTMLTableRowElement;
                    break;
                }
                case -2: {
                    bl = element instanceof HTMLTableSectionElement && element.getTagName().equals("tbody");
                    break;
                }
                case -3: {
                    bl = element instanceof HTMLTableCellElement;
                    break;
                }
            }
            if (bl && string != null) {
                if (element instanceof HTMLAnchorElement && string.equals(element.getAttribute("name"))) {
                    boolean bl2 = true;
                    Object var6_6 = null;
                    return bl2;
                }
                bl = string.equals(element.getAttribute("id"));
            }
        }
        return bl;
    }

    protected boolean recurse() {
        return this._lookingFor > 0;
    }
}

