/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.parser;

import java.io.IOException;
import java.io.Reader;
import org.openxml.DOMFactory;
import org.openxml.DTDDocument;
import org.openxml.dom.DocumentImpl;
import org.openxml.dom.EntityImpl;
import org.openxml.parser.BaseParser;
import org.openxml.parser.ContentParser;
import org.openxml.parser.DTDParser;
import org.openxml.parser.ParseException;
import org.openxml.source.Holder;
import org.openxml.source.Source;
import org.openxml.util.FastString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLParser
extends ContentParser {
    private FastString _nodeText;
    private String _orphanClosingTag;
    static /* synthetic */ Class class$org$w3c$dom$Document;

    public XMLParser(Reader reader, String string) {
        this(reader, string, 11, 0);
    }

    public XMLParser(Reader reader, String string, short s, short s2) {
        super(reader, string, s, s2);
    }

    public XMLParser(BaseParser baseParser, Reader reader, String string) {
        super(reader, string, baseParser.getMode(), (short)0);
        this._document = baseParser._document;
        if (baseParser instanceof ContentParser) {
            this._docType = ((ContentParser)baseParser)._docType;
        }
        this.setErrorSink(baseParser);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected final boolean closingTag(String string, boolean bl) throws ParseException {
        if (!(this._currentNode instanceof Element)) {
            return false;
        }
        if (((Element)this._currentNode).getTagName().equals(string)) {
            return false;
        }
        this._orphanClosingTag = string;
        if (!bl) {
            this.error((short)1, "Closing tag '" + string + "' does not match with opening tag'" + ((Element)this._currentNode).getTagName() + "'.");
        }
        return true;
    }

    private void loseWhitespace(Element element) {
        String string;
        Node node = element.getFirstChild();
        if (node != null && node instanceof Text) {
            string = ((Text)node).getData();
            if (string.length() == 1 && string.charAt(0) == ' ') {
                element.removeChild(node);
            } else if (string.length() > 0 && string.charAt(0) == ' ') {
                ((Text)node).deleteData(0, 1);
            }
        }
        if ((node = element.getLastChild()) != null && node instanceof Text) {
            string = ((Text)node).getData();
            if (string.length() == 1 && string.charAt(0) == ' ') {
                element.removeChild(node);
            } else if (string.length() > 0 && string.charAt(string.length() - 1) == ' ') {
                ((Text)node).deleteData(string.length() - 1, 1);
            }
        }
    }

    protected final void parseDTDSubset(boolean bl) throws ParseException, IOException {
        String string = null;
        String string2 = null;
        this._docType = null;
        while (this.isSpace(this.readChar())) {
        }
        this.pushBack();
        if (this.readTokenName()) {
            DTDParser dTDParser;
            String string3 = this._tokenText.toString();
            while (this.isSpace(this.readChar())) {
            }
            if (this._curChar == 83 && this.canReadName("YSTEM")) {
                while (this.isSpace(this.readChar())) {
                }
                this.pushBack();
                if (this.readTokenQuoted()) {
                    string2 = this._tokenText.toString();
                } else {
                    this.error((short)1, "Document type definition missing quoted system identifier.");
                }
            } else if (this._curChar == 80 && this.canReadName("UBLIC")) {
                while (this.isSpace(this.readChar())) {
                }
                this.pushBack();
                if (this.readTokenQuoted()) {
                    string = this._tokenText.toString();
                    while (this.isSpace(this.readChar())) {
                    }
                    this.pushBack();
                    if (this.readTokenQuoted()) {
                        string2 = this._tokenText.toString();
                    } else {
                        this.error((short)1, "Document type definition missing quoted system identifier.");
                    }
                } else {
                    this.error((short)1, "Document type definition missing quoted public identifier.");
                }
            } else {
                this.pushBack();
            }
            if ((string2 != null || string != null) && bl) {
                this.error((short)2, "Document declared as standalone, but uses external DTD subset.");
                bl = false;
            }
            while (this.isSpace(this.readChar())) {
            }
            if (this._curChar == 91) {
                this._docType = new DTDDocument(this._document, string3, bl, string2, string);
                dTDParser = new DTDParser(this, this.getReader(), String.valueOf(this.getSourceURI()) + " (internal subset)");
                dTDParser.parseInternalSubset(this._docType);
                this.advanceLineNumber(dTDParser.getLineNumber());
            } else {
                this.pushBack();
            }
            if (string2 != null || string != null) {
                block34: {
                    Source source = DOMFactory.newSource();
                    source.setURI(string2);
                    source.setPublicId(string);
                    source.setDocClass(Source.DOCUMENT_DTD);
                    Holder holder = DOMFactory.getHolderFinder().findHolder(source, false);
                    if (holder != null) {
                        if (this._docType == null) {
                            this._docType = (DTDDocument)holder.newInstance();
                            if (this._docType == null) {
                                this.error((short)2, "Could not access external DTD subset '" + source + "'.");
                            }
                        } else {
                            try {
                                Reader reader = holder.getReader();
                                if (reader != null) {
                                    dTDParser = new DTDParser(this, reader, source.toString());
                                    dTDParser.parseExternalSubset(this._docType);
                                    break block34;
                                }
                                this.error((short)2, "Could not access external DTD subset '" + source + "'.");
                            }
                            catch (IOException iOException) {
                                this.error((short)2, "Could not access external DTD subset '" + source + "'. IOException: " + iOException.getMessage());
                            }
                        }
                    } else {
                        this.error((short)2, "Could not locate external DTD subset.");
                    }
                }
                if (this._docType == null) {
                    this._docType = new DTDDocument(this._document, string3, bl, string2, string);
                }
            }
            if (this._docType != null && this._document instanceof DocumentImpl) {
                ((DocumentImpl)this._document).assignDoctype(this._docType);
            }
        } else {
            this.error((short)1, "Document type definition missing root element type and was ignored.");
        }
        while (this.readChar() != -1 && this._curChar != 62) {
        }
        if (this._curChar == -1) {
            this.error((short)1, "Document type definition terminated at end of document.");
        }
    }

    public Document parseDocument() throws ParseException {
        return this.parseDocument(null, null);
    }

    public Document parseDocument(DTDDocument dTDDocument) throws ParseException {
        return this.parseDocument(dTDDocument);
    }

    public Document parseDocument(DTDDocument dTDDocument, Class clazz) throws ParseException {
        if (this.isClosed()) {
            throw new IllegalStateException("Parser has been closed and may not be used anymore.");
        }
        this._docType = dTDDocument;
        boolean bl = false;
        try {
            try {
                if (clazz != null) {
                    if (clazz != (class$org$w3c$dom$Document != null ? class$org$w3c$dom$Document : (class$org$w3c$dom$Document = XMLParser.class$("org.w3c.dom.Document"))) && !(class$org$w3c$dom$Document != null ? class$org$w3c$dom$Document : (class$org$w3c$dom$Document = XMLParser.class$("org.w3c.dom.Document"))).isAssignableFrom(clazz)) {
                        throw new IllegalArgumentException("Argument 'docClass' must extend Document.");
                    }
                    this._document = DOMFactory.createDocument(clazz);
                } else {
                    this._document = DOMFactory.createDocument(null);
                }
                this._currentNode = this._document;
                int n = this.readTokenContent();
                if (n == 5 && this._tokenText.length() > 3 && this._tokenText.startsWith("xml")) {
                    bl = this.parseDocumentDecl(true);
                    n = this.readTokenContent();
                }
                while (n == 4 || n == 5 || n == 0 && this.isTokenAllSpace()) {
                    if (n != 0) {
                        this.parseNextNode(n);
                    }
                    n = this.readTokenContent();
                }
                if (n == 7 && this._tokenText.equals("DOCTYPE")) {
                    this.parseDTDSubset(bl);
                    n = this.readTokenContent();
                }
                while (n != 2 && n != -1) {
                    if (n == 4 || n == 5) {
                        this.parseNextNode(n);
                    } else if (n != 0 || !this.isTokenAllSpace()) {
                        this.error((short)1, "Only comments and processing instructions allowed outside of root element.");
                    }
                    n = this.readTokenContent();
                }
                if (n == 2) {
                    while (this.parseNextNode(n)) {
                        n = this.readTokenContent();
                    }
                }
                while (n != 2 && n != -1) {
                    if (n == 4 || n == 5) {
                        this.parseNextNode(n);
                    } else if (n != 0 || !this.isTokenAllSpace()) {
                        this.error((short)1, "Only comments and processing instructions allowed outside of root element.");
                    }
                    n = this.readTokenContent();
                }
            }
            catch (ParseException parseException) {
                throw parseException;
            }
            catch (Exception exception) {
                this.error(exception);
            }
            Object var6_7 = null;
            this.close();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.close();
            throw throwable;
        }
        return this._document;
    }

    public final Entity parseEntity(EntityImpl entityImpl, boolean bl) throws ParseException {
        if (entityImpl == null) {
            throw new NullPointerException("Argument 'entity' is null.");
        }
        if (this.isClosed()) {
            throw new IllegalStateException("Parser has been closed and may not be used anymore.");
        }
        this._document = entityImpl.getOwnerDocument();
        try {
            try {
                this._currentNode = entityImpl;
                int n = this.readTokenContent();
                if (!bl && n == 5 && this._tokenText.length() > 3 && this._tokenText.startsWith("xml")) {
                    this.parseDocumentDecl(false);
                    n = this.readTokenContent();
                }
                while (this.parseNextNode(n)) {
                    n = this.readTokenContent();
                }
                if (this._nodeText != null && this._nodeText.length() > 0) {
                    this._currentNode.appendChild(this._document.createTextNode(this._nodeText.toString()));
                    this._nodeText = null;
                }
            }
            catch (ParseException parseException) {
                throw parseException;
            }
            catch (Exception exception) {
                this.error(exception);
            }
            Object var5_6 = null;
            this.close();
            entityImpl.makeReadOnly();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.close();
            entityImpl.makeReadOnly();
            throw throwable;
        }
        return entityImpl;
    }

    protected final boolean parseNextNode(int n) throws ParseException, IOException {
        if (n == 8) {
            this.error((short)1, "The sequence '<![' encountered for no good reason.");
            n = 0;
            this._tokenText.insert(0, "<![");
        }
        if (n == 7) {
            this.error((short)1, "The sequence '<!' encountered for no good reason.");
            n = 0;
            this._tokenText.insert(0, "<!");
        }
        if (n == 6 && !this.isMode((short)4)) {
            n = 0;
        }
        if (n == 5 && !this.isMode((short)1) || n == 4 && !this.isMode((short)2)) {
            return true;
        }
        if (n == 0) {
            if (this._nodeText == null) {
                this._nodeText = new FastString(this._tokenText);
            } else {
                this._nodeText.append(this._tokenText);
            }
        } else {
            Node node;
            if (this._nodeText != null && this._nodeText.length() > 0) {
                int n2 = this._nodeText.length();
                char[] cArray = this._nodeText.getCharArray();
                int n3 = 0;
                while (n3 < n2) {
                    if (!this.isSpace(cArray[n3])) break;
                    ++n3;
                }
                if (n3 < n2) {
                    node = this._document.createTextNode(this._nodeText.toString());
                    this._currentNode.appendChild(node);
                }
                this._nodeText.setLength(0);
            }
            if (n == -1) {
                return false;
            }
            if (n == 5) {
                String string = this.slicePITokenText();
                node = this._document.createProcessingInstruction(string, this._tokenText.toString());
                this._currentNode.appendChild(node);
            } else if (n == 4) {
                node = this._document.createComment(this._tokenText.toString());
                this._currentNode.appendChild(node);
            } else if (n == 6) {
                node = this._document.createCDATASection(this._tokenText.toString());
                this._currentNode.appendChild(node);
            } else if (n == 1) {
                if (this.isMode((short)8)) {
                    this.parseContentEntity();
                } else {
                    node = this._document.createEntityReference(this._tokenText.toString());
                    this._currentNode.appendChild(node);
                }
            } else if (n == 2) {
                Element element = this._document.createElement(this._tokenText.toString());
                this._currentNode.appendChild(element);
                boolean bl = this.parseAttributes(element, true);
                if (bl) {
                    this._currentNode = element;
                    n = this.readTokenContent();
                    while (this.parseNextNode(n)) {
                        n = this.readTokenContent();
                    }
                    this._currentNode = this._currentNode.getParentNode();
                    if (this._orphanClosingTag != null) {
                        return this.closingTag(this._orphanClosingTag, true);
                    }
                }
            } else if (n == 3) {
                if (this._tokenText.length() == 0) {
                    this.error((short)1, "Encountered closing tag with not tag name.");
                    return true;
                }
                return this.closingTag(this._tokenText.toString(), false);
            }
        }
        return true;
    }

    public final Node parseNode(Node node) throws ParseException {
        if (node == null) {
            throw new NullPointerException("Argument 'node' is null.");
        }
        if (this.isClosed()) {
            throw new IllegalStateException("Parser has been closed and may not be used anymore.");
        }
        this._document = node.getOwnerDocument();
        try {
            try {
                this._currentNode = node;
                int n = this.readTokenContent();
                while (this.parseNextNode(n)) {
                    n = this.readTokenContent();
                }
                if (this._nodeText != null && this._nodeText.length() > 0) {
                    this._currentNode.appendChild(this._document.createTextNode(this._nodeText.toString()));
                    this._nodeText = null;
                }
            }
            catch (ParseException parseException) {
                throw parseException;
            }
            catch (Exception exception) {
                this.error(exception);
            }
            Object var4_5 = null;
            this.close();
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.close();
            throw throwable;
        }
        return node;
    }
}

